/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.oc.components.event.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.tydic.dyc.oc.components.es.IUocEsSyncQryReqBo;
import com.tydic.dyc.oc.components.event.EventConsumer;
import com.tydic.dyc.oc.components.event.IUocEsSyncQryEventReqBo;
import com.tydic.dyc.oc.config.UocIndexConfig;
import com.tydic.dyc.oc.utils.UocRu;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class EventConsumerCommonSyncHRChng
implements EventConsumer {
    private static final Logger log = LoggerFactory.getLogger(EventConsumerCommonSyncHRChng.class);
    @Autowired
    private UocIndexConfig uocIndexConfig;

    @Override
    public List<IUocEsSyncQryEventReqBo> parseMap(Map<String, Object> map) {
        IUocEsSyncQryEventReqBo shipEvent;
        log.info("event-EventConsumerCommonSyncHRChng->{}", (Object)JSON.toJSONString(map));
        ArrayList<IUocEsSyncQryEventReqBo> retList = new ArrayList<IUocEsSyncQryEventReqBo>();
        Object chngOrderIdListObj = map.get("chngOrderIdList");
        Object saleOrderIdListObj = map.get("saleOrderIdList");
        Object inspOrderIdListObj = map.get("inspOrderIdList");
        Object shipOrderIdListObj = map.get("shipOrderIdList");
        Long sysTenantId = UocRu.parseLong(map.get("sysTenantId"));
        if (ObjectUtil.isNotEmpty((Object)saleOrderIdListObj)) {
            List<String> saleOrderIdList = UocRu.jsl(saleOrderIdListObj, String.class);
            ArrayList<IUocEsSyncQryReqBo> saleList = new ArrayList<IUocEsSyncQryReqBo>();
            saleOrderIdList.forEach(x -> {
                IUocEsSyncQryReqBo sale = new IUocEsSyncQryReqBo();
                String[] xsplit = x.split("-");
                sale.setOrderId(Long.parseLong(xsplit[1]));
                sale.setObjId(Long.parseLong(xsplit[0]));
                sale.setSysTenantId(sysTenantId);
                saleList.add(sale);
            });
            shipEvent = new IUocEsSyncQryEventReqBo();
            shipEvent.setIndexName(this.uocIndexConfig.getSaleOrderIndex());
            shipEvent.setDataList(saleList);
            retList.add(shipEvent);
        }
        if (ObjectUtil.isNotEmpty((Object)inspOrderIdListObj)) {
            List<String> inspOrderIdList = UocRu.jsl(inspOrderIdListObj, String.class);
            ArrayList<IUocEsSyncQryReqBo> inspList = new ArrayList<IUocEsSyncQryReqBo>();
            inspOrderIdList.forEach(x -> {
                IUocEsSyncQryReqBo insp = new IUocEsSyncQryReqBo();
                String[] xsplit = x.split("-");
                insp.setOrderId(Long.parseLong(xsplit[1]));
                insp.setObjId(Long.parseLong(xsplit[0]));
                insp.setSysTenantId(sysTenantId);
                inspList.add(insp);
            });
            shipEvent = new IUocEsSyncQryEventReqBo();
            shipEvent.setIndexName(this.uocIndexConfig.getInspOrderIndex());
            shipEvent.setDataList(inspList);
            retList.add(shipEvent);
        }
        if (ObjectUtil.isNotEmpty((Object)shipOrderIdListObj)) {
            List<String> shipOrderIdList = UocRu.jsl(shipOrderIdListObj, String.class);
            ArrayList<IUocEsSyncQryReqBo> shipList = new ArrayList<IUocEsSyncQryReqBo>();
            shipOrderIdList.forEach(x -> {
                IUocEsSyncQryReqBo ship = new IUocEsSyncQryReqBo();
                String[] xsplit = x.split("-");
                ship.setOrderId(Long.parseLong(xsplit[1]));
                ship.setObjId(Long.parseLong(xsplit[0]));
                ship.setSysTenantId(sysTenantId);
                shipList.add(ship);
            });
            shipEvent = new IUocEsSyncQryEventReqBo();
            shipEvent.setIndexName(this.uocIndexConfig.getShipOrderIndex());
            shipEvent.setDataList(shipList);
            retList.add(shipEvent);
        }
        if (ObjectUtil.isNotEmpty((Object)chngOrderIdListObj)) {
            List<String> chngOrderIdList = UocRu.jsl(chngOrderIdListObj, String.class);
            ArrayList<IUocEsSyncQryReqBo> chngList = new ArrayList<IUocEsSyncQryReqBo>();
            chngOrderIdList.forEach(x -> {
                IUocEsSyncQryReqBo chng = new IUocEsSyncQryReqBo();
                String[] xsplit = x.split("-");
                chng.setOrderId(Long.parseLong(xsplit[1]));
                chng.setObjId(Long.parseLong(xsplit[0]));
                chng.setSysTenantId(sysTenantId);
                chngList.add(chng);
            });
            shipEvent = new IUocEsSyncQryEventReqBo();
            shipEvent.setIndexName(this.uocIndexConfig.getChngOrderIndex());
            shipEvent.setDataList(chngList);
            retList.add(shipEvent);
        }
        return retList;
    }

    @Override
    public String getEvent() {
        return "UOCE_ES_SYNC_CHNG_ORDER_HR";
    }
}

