package com.tydic.dyc.oc.components.event.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.tydic.dyc.oc.components.es.IUocEsSyncQryReqBo;
import com.tydic.dyc.oc.components.event.EventConsumer;
import com.tydic.dyc.oc.components.event.IUocEsSyncQryEventReqBo;
import com.tydic.dyc.oc.config.UocIndexConfig;
import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.constants.UocEventConstant;
import com.tydic.dyc.oc.utils.UocRu;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

/**
 * 标题：EventConsumerSyncAllOrder
 * 说明：同步整单ES
 * 时间：2022/5/19 16:02
 *
 * @author 文乐
 */
@Component
@Slf4j
public class EventConsumerSyncAllOrder implements EventConsumer {

    @Autowired
    private UocIndexConfig uocIndexConfig;

    @Override
    public List<IUocEsSyncQryEventReqBo> parseMap(Map<String, Object> map) {
        log.info("event-EventConsumerSyncAllOrder->{}", JSON.toJSONString(map));

        List<IUocEsSyncQryEventReqBo> retList = new ArrayList<>();
        Long orderId = Long.valueOf((String) map.get("orderId"));
        Long sysTenantId = UocRu.parseLong(map.get("sysTenantId"));
        if (ObjectUtil.isNotEmpty(orderId)) {
            IUocEsSyncQryReqBo syncQryReqBo = new IUocEsSyncQryReqBo();
            syncQryReqBo.setOrderId(orderId);
            syncQryReqBo.setObjId(orderId);
            syncQryReqBo.setSysTenantId(sysTenantId);
            syncQryReqBo.setObjType(UocDicConstant.OBJ_TYPE.ORDER);
            List<IUocEsSyncQryReqBo> saleList = Collections.singletonList(syncQryReqBo);
            IUocEsSyncQryEventReqBo eventReqBo = new IUocEsSyncQryEventReqBo();
            eventReqBo.setIndexName(uocIndexConfig.getOrderIndex());
            eventReqBo.setDataList(saleList);
            retList.add(eventReqBo);
        }

        return retList;
    }

    @Override
    public String getEvent() {
        return UocEventConstant.UOC_ORDER_SYNC;
    }
}
