package com.tydic.dyc.oc.model.cmporder;

import com.tydic.dyc.oc.model.cmporder.sub.UocCmpMaterial;
import com.tydic.dyc.oc.model.cmporder.sub.UocCmpOrderItem;
import com.tydic.dyc.oc.model.cmporder.sub.UocCmpOrderMap;
import com.tydic.dyc.oc.model.cmporder.sub.UocCmpSupplier;
import com.tydic.utils.generatedoc.annotation.DocField;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * 标题：类名称:UocCmpOrderDo
 * 说明：描述一下类的作用TODO
 * 时间：2022/3/29 11:23
 * 作者 @author 尹栋梁
 */
@Data
public class UocCmpOrderDo implements Serializable {
    private static final long serialVersionUID = 4027456016585222599L;
    @DocField(value = "比选单id")
    private Long cmpOrderId;

    @DocField(value = "订单id")
    private Long orderId;

    @DocField(value = "比选单号")
    private String cmpOrderNo;

    @DocField(value = "订单状态")
    private String cmpOrderState;

    @DocField(value = "比选单来源")
    private Integer cmpOrderSource;

    @DocField(value = "租户ID")
    private String tenantId;

    @DocField(value = "创建时间")
    private Date createTime;

    @DocField(value = "创建时间 开始")
    private Date createTimeStart;

    @DocField(value = "创建时间 结束")
    private Date createTimeEnd;

    @DocField(value = "创建工号")
    private String createOperId;

    @DocField(value = "创建人名称")
    private String createOperName;

    @DocField(value = "机构id")
    private String createOrgId;

    @DocField(value = "机构名称")
    private String createOrgName;

    @DocField(value = "更新时间")
    private Date updateTime;

    @DocField(value = "更新时间 开始")
    private Date updateTimeStart;

    @DocField(value = "更新时间 结束")
    private Date updateTimeEnd;

    @DocField(value = "更新工号")
    private String updateOperId;

    @DocField(value = "备注")
    private String remark;

    @DocField(value = "删除标志1已删除")
    private Integer delTag;

    @DocField(value = "排序")
    private String orderBy;

    @DocField(value = "比选明细表")
    private List<UocCmpOrderItem> uocCmpOrderItemList;

    @DocField(value = "比选物料表")
    private List<UocCmpMaterial> uocCmpMaterialList;

    @DocField(value = "比选供应商")
    private List<UocCmpSupplier> uocCmpSupplierList;

    @DocField(value = "比选单扩展")
    private List<UocCmpOrderMap> uocCmpOrderMapList;


    /**
     * 租户id
     */
    private Long sysTenantId;
    private String sysTenantName;
}
