package com.tydic.dyc.oc.model.saleorder.qrybo;

import com.tydic.dyc.base.bo.BasePageReqBo;
import com.tydic.utils.generatedoc.annotation.DocField;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.math.BigDecimal;
import java.util.Date;

/**
 * 标题:UocSaleOrderPayConfQryBo
 * 说明:销售单支付配置
 * 时间:2022-02-21 19:11
 * 作者:罗有
 **/
@EqualsAndHashCode(callSuper = true)
@Data
public class UocSaleOrderPayConfQryBo extends BasePageReqBo {
	private static final long serialVersionUID =  6554222613895072882L;

	@DocField(value = "id")
	private Long id;

	@DocField(value = "订单id")
	private Long orderId;

	@DocField(value = "销售单id")
	private Long saleOrderId;

	@DocField(value = "付款方式 0 预付款按比例支付,1 按协议约束支付,2 按账期支付")
	private Integer payType;

	@DocField(value = "账期天数")
	private Integer paymentDays;

	@DocField(value = "指定账期日")
	private Integer payAccountDay;

	@DocField(value = "使用类型：1：采购方；2：平台方")
	private Integer userType;

	@DocField(value = "账期支付结算规则 1:指定账期日 2:账期起算特定业务节点+账期天数")
	private Integer payRule;

	@DocField(value = "违约金额比例")
	private BigDecimal payBreakScale;

	@DocField(value = "账期日结算订单规则 1:签收发票开始 2:订单验收 3:订单到货")
	private Integer payAccountDayRule;

	@DocField(value = "账期起算特定业务节点 1:签收发票开始计算 2:订单验收开始计算 3:订单到货开始计算")
	private Integer payNodeRule;

	@DocField(value = "合同ID")
	private String modelContractId;

	

	@DocField(value = "创建时间")
	private Date createTime;

	@DocField(value = "创建时间 开始")
	private Date createTimeStart;

	@DocField(value = "创建时间 结束")
	private Date createTimeEnd;

	@DocField(value = "创建工号")
	private String createOperId;

	@DocField(value = "更新时间")
	private Date updateTime;

	@DocField(value = "更新时间 开始")
	private Date updateTimeStart;

	@DocField(value = "更新时间 结束")
	private Date updateTimeEnd;

	@DocField(value = "更新工号")
	private String updateOperId;

	@DocField(value = "备注")
	private String remark;

	@DocField(value = "删除标志1已删除")
	private Integer delTag;

	@DocField(value = "排序")
	private String orderBy;
	/**
	 * 租户id
	 */
	private Long sysTenantId;
	private String sysTenantName;

}
