package com.tydic.dyc.oc.components.event.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.dyc.oc.components.es.IUocEsSyncQryReqBo;
import com.tydic.dyc.oc.components.event.EventConsumer;
import com.tydic.dyc.oc.components.event.IUocEsSyncQryEventReqBo;
import com.tydic.dyc.oc.config.UocIndexConfig;
import com.tydic.dyc.oc.constants.UocConstant;
import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.constants.UocEventConstant;
import com.tydic.dyc.oc.model.order.IUocOrderModel;
import com.tydic.dyc.oc.model.order.qrybo.UocOrderTaskInstQryBo;
import com.tydic.dyc.oc.model.order.sub.UocOrderTaskInst;
import com.tydic.dyc.oc.utils.UocRu;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;


/**
 * 标题:EventConsumerSyncTodo
 * 说明:代办
 * 时间:2022/3/10 20:10
 * 作者:罗有
 */
@Slf4j
@Component
public class EventConsumerSyncTodo implements EventConsumer {
    @Autowired
    private UocIndexConfig uocIndexConfig;

    @Autowired
    private IUocOrderModel iUocOrderModel;

    @Override
    public List<IUocEsSyncQryEventReqBo> parseMap(Map<String, Object> map) {
        log.info("event-EventConsumerSyncTodo->{}", JSON.toJSONString(map));

        List<IUocEsSyncQryEventReqBo> retList = new ArrayList<>();
        Long orderId = UocRu.parseLong(map.get("orderId"));
        Long objId = UocRu.parseLong(map.get("objId"));
        Long sysTenantId = UocRu.parseLong(map.get("sysTenantId"));
        Integer objType = UocRu.parseInteger(map.get("objType"));
        String oldTaskInstId = UocRu.parseStr(map.get("oldTaskInstId"));

        UocOrderTaskInstQryBo uocOrderTaskInstQryBo = new UocOrderTaskInstQryBo();
        uocOrderTaskInstQryBo.setOrderId(orderId);
        uocOrderTaskInstQryBo.setObjId(objId);
        uocOrderTaskInstQryBo.setObjType(objType);
        uocOrderTaskInstQryBo.setFinishTag(UocDicConstant.PROC_TASK_FINISHED.NO_FINISHED);
        uocOrderTaskInstQryBo.setSysTenantId(sysTenantId);
        List<UocOrderTaskInst> uocOrderTaskInsts = iUocOrderModel.qryOrderTaskInstList(uocOrderTaskInstQryBo);
        List<IUocEsSyncQryReqBo> todoList = new ArrayList<>();
        if (!CollectionUtils.isEmpty(uocOrderTaskInsts)) {
            uocOrderTaskInsts.forEach(uocOrderTaskInst -> {
                IUocEsSyncQryReqBo syncQryReqBo = new IUocEsSyncQryReqBo();
                syncQryReqBo.setOrderId(orderId);
                syncQryReqBo.setSysTenantId(sysTenantId);
                syncQryReqBo.setObjId(uocOrderTaskInst.getId());
                todoList.add(syncQryReqBo);
            });
        }
        if (!StringUtils.isBlank(oldTaskInstId)) {
            List<UocOrderTaskInst> deleteList = getDeleteList(oldTaskInstId,sysTenantId);
            if (!CollectionUtils.isEmpty(deleteList)) {
                deleteList.forEach(uocOrderTaskInst -> {
                    IUocEsSyncQryReqBo deleteReq = new IUocEsSyncQryReqBo();
                    deleteReq.setObjId(uocOrderTaskInst.getId());
					deleteReq.setOrderId(uocOrderTaskInst.getOrderId());
					deleteReq.setSysTenantId(sysTenantId);
					deleteReq.setOpFlag(UocConstant.ES_SYNC_OP_FLAG.DELETE);
					todoList.add(deleteReq);
                });
            }
        }
        IUocEsSyncQryEventReqBo eventReqBo = new IUocEsSyncQryEventReqBo();
        eventReqBo.setIndexName(uocIndexConfig.getTodoIndex());
        eventReqBo.setDataList(todoList);
        retList.add(eventReqBo);
        log.info("代办出参:{}", JSON.toJSONString(retList));
        return retList;
    }

    @Override
    public String getEvent() {
        return UocEventConstant.UOCE_ES_SYNC_TODO;
    }

    private List<UocOrderTaskInst> getDeleteList(String oldTaskInstId, Long sysTenantId) {
        UocOrderTaskInstQryBo uocOrderTaskInstQryBo = new UocOrderTaskInstQryBo();
        uocOrderTaskInstQryBo.setTaskInstId(oldTaskInstId);
        uocOrderTaskInstQryBo.setSysTenantId(sysTenantId);
        return iUocOrderModel.qryOrderTaskInstList(uocOrderTaskInstQryBo);
    }
}


