package com.tydic.dyc.oc.model.common.qrybo;

import com.tydic.utils.generatedoc.annotation.DocField;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

@Data
public class UocConfSupplierBo implements Serializable {
    
    private static final long serialVersionUID = -5531248350542707515L;
    @DocField(value = "供应商id")
    private String supNo;
    
    @DocField(value = "供应商名称")
    private String supName;
    
    @DocField(value = "供应商标识")
    private String supType;
    
    @DocField(value = "是否一次性发货             0 否             1 是")
    private Integer isOnceSendAll;
    
    @DocField(value = "订单超限额度")
    private String orderQuota;
    
    @DocField(value = "校验模式")
    private Integer checkFlag;
    
    @DocField(value = "接收消息类型")
    private String dealType;
    
    @DocField(value = "是否完结通知                         0 否                         1 是")
    private Integer completionFlag;
    
    @DocField(value = "业务类型编码")
    private String businessTypeCode;
    
    @DocField(value = "操作时间")
    private Date operatingTime;
    
    @DocField(value = "操作时间 开始")
    private Date operatingTimeStart;
    
    @DocField(value = "操作时间 结束")
    private Date operatingTimeEnd;
    
    @DocField(value = "操作人ID")
    private String operatorId;
    
    @DocField(value = "操作人名称")
    private String operatorName;
    
    @DocField(value = "订单限额额度")
    private String orderLimit;
    
    @DocField(value = "订单限额状态：0：生效；1：失效")
    private Integer limitStatus;
    
    @DocField(value = "排序")
    private String orderBy;


    /**
     * 租户id
     */
    private Long sysTenantId;
    private String sysTenantName;
    
}