package com.tydic.dyc.oc.model.order.qrybo;

import com.tydic.utils.generatedoc.annotation.DocField;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * 标题：UocTacheButtonQryBo
 * 说明：页面每个sheet页对应的按钮映射规则配置
 * 时间：2022/4/21 15:08
 *
 * @author 文乐
 */
@Data
public class UocTacheButtonQryBo implements Serializable {
    private static final long serialVersionUID = 4336262944488681842L;

    @DocField(value = "主键ID")
    private Long id;

    @DocField(value = "tab标签id")
    private Integer tabId;

    @DocField(value = "环节编码，逗号分隔")
    private String tacheCode;

    @DocField(value = "环节编码，逗号分隔")
    private List<String> tacheCodes;

    @DocField(value = "子环节订单状态编码，逗号分隔")
    private String subOrderStatusCode;

    @DocField(value = "单据状态")
    private List<String> orderStatusList;

    @DocField(value = "子环节订单状态编码，逗号分隔")
    private List<String> subOrderStatusCodes;

    @DocField(value = "按钮编码 取菜单表的menu_code")
    private String menuCode;

    @DocField(value = "描述")
    private String menuDesc;

    @DocField(value = "排序")
    private String orderBy;

    @DocField(value = "表单参数")
    private String formParam;

    @DocField(value = "表单环节编码")
    private String formTacheCode;


    /**
     * 租户id
     */
    private Long sysTenantId;
    private String sysTenantName;
}
