package com.tydic.dyc.oc.model.order.sub;

import com.tydic.utils.generatedoc.annotation.DocField;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 标题:UocOrderItemEw
 * 说明:订单明细延保信息
 * 时间:2022-02-21 19:10
 * 作者:罗有
 **/
@Data
public class UocOrderItemEw implements Serializable {
	private static final long serialVersionUID =  4418726659536349804L;

	@DocField(value = "id")
	private Long id;

	@DocField(value = "延保编号")
	private String ewNo;

	@DocField(value = "订单明细id")
	private Long orderItemId;

	@DocField(value = "订单id")
	private Long orderId;

	@DocField(value = "单品ID")
	private String skuId;

	@DocField(value = "保障服务skuid")
	private String bindSkuId;

	@DocField(value = "保障服务sku名称 ")
	private String bindSkuName;

	@DocField(value = "保障服务sku价格")
	private String price;

	@DocField(value = "保障服务sku原价格")
	private String originalPrice;

	@DocField(value = "延保分类编码")
	private String ewCode;

	@DocField(value = "是否是优惠保障服 pc单品页、pc购物车会根据此标识是否展示优惠图标，             优惠图标单品页提供）")
	private Integer favor;

	@DocField(value = "显示排序")
	private Integer sort;

	@DocField(value = "保障服务说明提示语")
	private String tip;

	@DocField(value = "创建时间")
	private Date createTime;

	@DocField(value = "创建工号")
	private String createOperId;

	@DocField(value = "更新时间")
	private Date updateTime;

	@DocField(value = "更新工号")
	private String updateOperId;

	@DocField(value = "备注")
	private String remark;

	/**
	 * 租户id
	 */
	private Long sysTenantId;
	/**
	 * 租户名称
	 */
	private String sysTenantName;


}
