package com.tydic.dyc.oc.repository;

import com.tydic.dyc.base.bo.BasePageRspBo;
import com.tydic.dyc.oc.model.sysdictionary.UocSysDictionaryDo;
import com.tydic.dyc.oc.model.sysdictionary.qrybo.UocSysDictionaryQryBo;

import java.util.List;


/**
 * 标题:UocSysDictionaryRepository
 * 说明:字典
 * 时间:2022/3/9 14:20
 * 作者:tiankunlin
 **/
public interface UocSysDictionaryRepository {

    /**
     * 描述: 查字典列表
     *
     * @param reqBO 入参对象
     * @return UocSycDictionaryDo
     */
    List<UocSysDictionaryDo> qryDicList(UocSysDictionaryQryBo reqBO);

    /**
     * 描述: 批量查字典
     *
     * @param pCodes 入参对象
     * @return UocSycDictionaryDo
     */
    List<UocSysDictionaryDo> qryDicListByPCodes(UocSysDictionaryQryBo reqBO);

    /**
     * 描述: 查字典
     *
     * @param reqBO 入参对象
     * @return UocSycDictionaryDo
     */
    UocSysDictionaryDo getModelBy(UocSysDictionaryQryBo reqBO);

    /**
     * 创建字典值
     *
     * @param uocSysDictionaryDo 入参对象
     * @return UocSycDictionaryDo
     */
    UocSysDictionaryDo createDic(UocSysDictionaryDo uocSysDictionaryDo);

    /**
     * 修改字典值
     *
     * @param uocSysDictionaryDo 入参对象
     * @return UocSycDictionaryDo
     */
    UocSysDictionaryDo updateDic(UocSysDictionaryDo uocSysDictionaryDo);

    /**
     * 删除字典值
     *
     * @param reqBO 入参对象
     * @return UocSysDictionaryQryBo
     */
    UocSysDictionaryQryBo deleteDic(UocSysDictionaryQryBo reqBO);

    List<UocSysDictionaryDo> getModelAmbiguousBy(UocSysDictionaryQryBo uocSysDictionaryQryBo);

    BasePageRspBo<UocSysDictionaryDo> getModelByPage(UocSysDictionaryQryBo reqBO);
}
