package com.tydic.dyc.oc.service.domainservice;

import com.tydic.dyc.base.constants.BaseRspConstant;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.constants.UocConstant;
import com.tydic.dyc.oc.constants.UocRspConstants;
import com.tydic.dyc.oc.constants.UocStateConstants;
import com.tydic.dyc.oc.model.chngorder.IUocChngOrderModel;
import com.tydic.dyc.oc.model.chngorder.UocChngOrderDo;
import com.tydic.dyc.oc.model.common.IUocCommonModel;
import com.tydic.dyc.oc.model.common.UocCommonDo;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo;
import com.tydic.dyc.oc.service.domainservice.bo.UocCancelSaleOrderBatchConfirmOrRefuseReqBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocCancelSaleOrderBatchConfirmOrRefuseRspBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocCancelSaleOrderInfoBo;
import com.tydic.dyc.oc.service.saleorder.bo.UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 描述: 〈领域服务-销售单取消申请同意/拒绝（批量）实现〉
 * @author : yuhao
 * @date : 2022/8/2 14:40
 */
@HTServiceImpl
public class UocCancelSaleOrderBatchConfirmOrRefuseServiceImpl implements UocCancelSaleOrderBatchConfirmOrRefuseService{
    @Autowired
    private IUocSaleOrderModel iUocSaleOrderModel;
    @Autowired
    private IUocChngOrderModel iUocChngOrderModel;
    @Autowired
    private IUocCommonModel iUocCommonModel;

    /**
     * 销售单取消申请同意/拒绝（批量）
     * @param reqBo
     * @return
     */
    @Override
    public UocCancelSaleOrderBatchConfirmOrRefuseRspBo cancelSaleOrderBatchConfirmOrRefuse(UocCancelSaleOrderBatchConfirmOrRefuseReqBo reqBo) {
        //参数校验
        this.verifyParam(reqBo);
        //批量更新取消申请变更单信息
        this.batchUpdateCancelApplyChangeOrderInfo(reqBo);
        //批量更新销售单信息
        this.batchUpdateSaleOrderInfo(reqBo);
        //如果确认取消申请，则需提交销售单任务
        if (UocConstant.CONFIRM_RESULT.ACCEPT.equals(reqBo.getConfirmResult())){
            this.batchSubmitTask(reqBo);
        }

        UocCancelSaleOrderBatchConfirmOrRefuseRspBo rspBo = new UocCancelSaleOrderBatchConfirmOrRefuseRspBo();
        //封装出参对象 (查询销售单明细 ，验收单明细，为了批量同步)
        buildSyncRsp(reqBo,rspBo);
        rspBo.setRespCode(BaseRspConstant.RSP_CODE_SUCCESS);
        rspBo.setRespDesc(BaseRspConstant.RSP_DESC_SUCCESS);
        return rspBo;
    }

    /**
     * 批量提交销售单任务
     * @param reqBo
     */
    private void batchSubmitTask(UocCancelSaleOrderBatchConfirmOrRefuseReqBo reqBo){
        for(UocCancelSaleOrderInfoBo uocCancelSaleOrderInfoBo:reqBo.getCancelApplyChangeOrderInfos()){
            UocCommonDo uocCommonDo = new UocCommonDo();
            List<UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo> taskInfos = new ArrayList<>();
            UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo task = new UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo();
            task.setTaskId(uocCancelSaleOrderInfoBo.getTaskId());
            taskInfos.add(task);
            uocCommonDo.setCompleteTaskInfos(taskInfos);
            uocCommonDo.setUserId(reqBo.getUserId());
            uocCommonDo.setOrderId(uocCancelSaleOrderInfoBo.getOrderId());
            this.iUocCommonModel.dealTask(uocCommonDo);
        }
    }

    /**
     * 构造出参，用于批量数据同步
     */
    private void buildSyncRsp(UocCancelSaleOrderBatchConfirmOrRefuseReqBo reqBo,UocCancelSaleOrderBatchConfirmOrRefuseRspBo rspBo){

        List<String> saleOrderIdList = reqBo.getCancelApplyChangeOrderInfos().stream().map(x -> x.getSaleOrderId() + "-" + x.getOrderId()).distinct().collect(Collectors.toList());
        List<String> chngOrderIdList = reqBo.getCancelApplyChangeOrderInfos().stream().map(x -> x.getChngOrderId() + "-" + x.getOrderId()).distinct().collect(Collectors.toList());

        rspBo.setSaleOrderIdList(saleOrderIdList);
        rspBo.setChngOrderIdList(chngOrderIdList);
    }

    /**
     * 批量更新销售单信息
     * @param reqBo
     */
    private void batchUpdateSaleOrderInfo(UocCancelSaleOrderBatchConfirmOrRefuseReqBo reqBo){
        for(UocCancelSaleOrderInfoBo uocCancelSaleOrderInfoBo:reqBo.getCancelApplyChangeOrderInfos()){
            UocSaleOrderDo updateSaleOrderDo = new UocSaleOrderDo();
            updateSaleOrderDo.setOrderId(uocCancelSaleOrderInfoBo.getOrderId());
            updateSaleOrderDo.setSaleOrderId(uocCancelSaleOrderInfoBo.getSaleOrderId());
            updateSaleOrderDo.setCancelReplyContent(reqBo.getCancelReplyContent());
            updateSaleOrderDo.setCancelReplyTime(new Date());
            updateSaleOrderDo.setUpdateOperId(String.valueOf(reqBo.getUserId()));
            updateSaleOrderDo.setUpdateOperName(reqBo.getName());
            updateSaleOrderDo.setUpdateTime(new Date());
            updateSaleOrderDo.setCancelTime(new Date());
            if (UocConstant.CONFIRM_RESULT.ACCEPT.equals(reqBo.getConfirmResult())) {
                updateSaleOrderDo.setSaleOrderState(UocStateConstants.SaleOrder.XS_QX_QX);
            }else{
                updateSaleOrderDo.setSaleOrderState(uocCancelSaleOrderInfoBo.getOriginalSaleOrderStatus());
            }
            this.iUocSaleOrderModel.modifySaleOrderMain(updateSaleOrderDo);
        }
    }

    /**
     * 批量更新取消申请变更单信息
     * @param reqBo
     */
    private void batchUpdateCancelApplyChangeOrderInfo(UocCancelSaleOrderBatchConfirmOrRefuseReqBo reqBo){
        for(UocCancelSaleOrderInfoBo uocCancelSaleOrderInfoBo:reqBo.getCancelApplyChangeOrderInfos()){
            UocChngOrderDo updateChngOrderDo = new UocChngOrderDo();
            updateChngOrderDo.setChngOrderId(uocCancelSaleOrderInfoBo.getChngOrderId());
            updateChngOrderDo.setOrderId(uocCancelSaleOrderInfoBo.getOrderId());
            if (UocConstant.CONFIRM_RESULT.ACCEPT.equals(reqBo.getConfirmResult())) {
                updateChngOrderDo.setChngOrderState(UocStateConstants.ChngOrder.SALE_ORDER_CANCEL.CHNG_XS_YQR);
            } else {
                updateChngOrderDo.setChngOrderState(UocStateConstants.ChngOrder.SALE_ORDER_CANCEL.CHNG_XS_YJJ);
            }
            updateChngOrderDo.setRejectReason(reqBo.getCancelReplyContent());
            updateChngOrderDo.setRejectTime(new Date());
            updateChngOrderDo.setUpdateOperName(reqBo.getName());
            updateChngOrderDo.setUpdateTime(new Date());
            updateChngOrderDo.setUpdateOperId(String.valueOf(reqBo.getUserId()));
            this.iUocChngOrderModel.updateChngOrderMain(updateChngOrderDo);
        }
    }

    /**
     * 参数校验
     * @param reqBo
     */
    private void verifyParam(UocCancelSaleOrderBatchConfirmOrRefuseReqBo reqBo) {
        if (null == reqBo) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象不能为空");
        }
        if (null == reqBo.getUserId()) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参用户ID不能为空");
        }
        if (null == reqBo.getConfirmResult()) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参操作类型不能为空");
        }
        if (CollectionUtils.isEmpty(reqBo.getCancelApplyChangeOrderInfos())) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "取消申请变更单不能为空");
        }
    }
}
