package com.tydic.dyc.oc.service.domainservice;

import com.tydic.dyc.base.constants.BaseRspConstant;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.constants.UocConstant;
import com.tydic.dyc.oc.constants.UocRspConstants;
import com.tydic.dyc.oc.constants.UocStateConstants;
import com.tydic.dyc.oc.model.chngorder.IUocChngOrderModel;
import com.tydic.dyc.oc.model.chngorder.UocChngOrderDo;
import com.tydic.dyc.oc.model.common.IUocCommonModel;
import com.tydic.dyc.oc.model.common.UocCommonDo;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo;
import com.tydic.dyc.oc.service.domainservice.bo.UocCancelSaleOrderConfirmOrRefuseReqBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocCancelSaleOrderConfirmOrRefuseRspBo;
import com.tydic.dyc.oc.service.saleorder.bo.UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 描述: 〈领域服务-销售单取消申请同意/拒绝（单条）实现〉
 * @author : yuhao
 * @date : 2022/8/1 11:06
 */
@HTServiceImpl
public class UocCancelSaleOrderConfirmOrRefuseServiceImpl implements UocCancelSaleOrderConfirmOrRefuseService {
    @Autowired
    private IUocSaleOrderModel iUocSaleOrderModel;
    @Autowired
    private IUocChngOrderModel iUocChngOrderModel;
    @Autowired
    private IUocCommonModel iUocCommonModel;

    @Override
    public UocCancelSaleOrderConfirmOrRefuseRspBo cancelSaleOrderConfirmOrRefuse(UocCancelSaleOrderConfirmOrRefuseReqBo reqBo) {
        //参数校验
        this.verifyParam(reqBo);
        //更新取消申请变更单信息
        this.updateCancelApplyChangeOrderInfo(reqBo);
        //更新销售单信息
        this.updateSaleOrderInfo(reqBo);
        //如果确认取消申请，则需提交销售单任务
        if (UocConstant.CONFIRM_RESULT.ACCEPT.equals(reqBo.getConfirmResult())){
            this.submitTask(reqBo);
        }

        UocCancelSaleOrderConfirmOrRefuseRspBo rspBo = new UocCancelSaleOrderConfirmOrRefuseRspBo();
        rspBo.setRespCode(BaseRspConstant.RSP_CODE_SUCCESS);
        rspBo.setRespDesc(BaseRspConstant.RSP_DESC_SUCCESS);
        rspBo.setSysTenantId(reqBo.getSysTenantId());
        return rspBo;
    }

    /**
     * 提交销售单任务
     * @param reqBo
     */
    private void submitTask(UocCancelSaleOrderConfirmOrRefuseReqBo reqBo){
        UocCommonDo uocCommonDo = new UocCommonDo();
        List<UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo> taskInfos = new ArrayList<>();
        UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo task = new UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo();
        task.setTaskId(reqBo.getTaskId());
        taskInfos.add(task);
        uocCommonDo.setCompleteTaskInfos(taskInfos);
        uocCommonDo.setUserId(reqBo.getUserId());
        uocCommonDo.setOrderId(reqBo.getOrderId());
        this.iUocCommonModel.dealTask(uocCommonDo);
    }

    /**
     * 更新取消申请变更单信息
     * @param reqBo
     */
    private void updateCancelApplyChangeOrderInfo(UocCancelSaleOrderConfirmOrRefuseReqBo reqBo){
        UocChngOrderDo updateChngOrderDo = new UocChngOrderDo();
        updateChngOrderDo.setChngOrderId(reqBo.getChngOrderId());
        updateChngOrderDo.setOrderId(reqBo.getOrderId());
        if (UocConstant.CONFIRM_RESULT.ACCEPT.equals(reqBo.getConfirmResult())) {
            updateChngOrderDo.setChngOrderState(UocStateConstants.ChngOrder.SALE_ORDER_CANCEL.CHNG_XS_YQR);
        } else {
            updateChngOrderDo.setChngOrderState(UocStateConstants.ChngOrder.SALE_ORDER_CANCEL.CHNG_XS_YJJ);
        }
        updateChngOrderDo.setRejectReason(reqBo.getCancelReplyContent());
        updateChngOrderDo.setRejectTime(new Date());
        updateChngOrderDo.setUpdateOperName(reqBo.getName());
        updateChngOrderDo.setUpdateTime(new Date());
        updateChngOrderDo.setUpdateOperId(String.valueOf(reqBo.getUserId()));
        this.iUocChngOrderModel.updateChngOrderMain(updateChngOrderDo);
    }
    /**
     * 更新销售单信息
     * @param reqBo
     */
    private void updateSaleOrderInfo(UocCancelSaleOrderConfirmOrRefuseReqBo reqBo){
        UocSaleOrderDo updateSaleOrderDo = new UocSaleOrderDo();
        updateSaleOrderDo.setOrderId(reqBo.getOrderId());
        updateSaleOrderDo.setSaleOrderId(reqBo.getSaleOrderId());
        updateSaleOrderDo.setCancelReplyContent(reqBo.getCancelReplyContent());
        updateSaleOrderDo.setCancelReplyTime(new Date());
        updateSaleOrderDo.setUpdateOperId(String.valueOf(reqBo.getUserId()));
        updateSaleOrderDo.setUpdateOperName(reqBo.getName());
        updateSaleOrderDo.setUpdateTime(new Date());
        updateSaleOrderDo.setCancelTime(new Date());
        if (UocConstant.CONFIRM_RESULT.ACCEPT.equals(reqBo.getConfirmResult())) {
            updateSaleOrderDo.setSaleOrderState(UocStateConstants.SaleOrder.XS_QX_QX);
        }else{
            updateSaleOrderDo.setSaleOrderState(reqBo.getOriginalSaleOrderStatus());
        }
        this.iUocSaleOrderModel.modifySaleOrderMain(updateSaleOrderDo);
    }

    /**
     * 参数校验
     * @param reqBo
     */
    private void verifyParam(UocCancelSaleOrderConfirmOrRefuseReqBo reqBo) {
        if (null == reqBo) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象不能为空");
        }
        if (null == reqBo.getUserId()) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参用户ID不能为空");
        }
        if (null == reqBo.getConfirmResult()) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参操作类型不能为空");
        }
        if (null == reqBo.getOrderId()) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参订单ID不能为空");
        }
        if (null == reqBo.getChngOrderId()) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参变更单ID不能为空");
        }
        if (null == reqBo.getSaleOrderId()) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参销售单ID不能为空");
        }
    }
}
