package com.tydic.dyc.oc.components.es.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.convert.Convert;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.tydic.dyc.oc.components.es.IUocEsSync;
import com.tydic.dyc.oc.components.es.IUocEsSyncQryReqBo;
import com.tydic.dyc.oc.components.es.IUocEsSyncQryRspBo;
import com.tydic.dyc.oc.config.UocIndexConfig;
import com.tydic.dyc.oc.constants.UocConstant;
import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.model.insporder.IUocInspOrderModel;
import com.tydic.dyc.oc.model.insporder.UocInspOrderDo;
import com.tydic.dyc.oc.model.insporder.qrybo.UocInspOrderItemQryBo;
import com.tydic.dyc.oc.model.insporder.qrybo.UocInspOrderQryBo;
import com.tydic.dyc.oc.model.insporder.sub.UocInspOrderItem;
import com.tydic.dyc.oc.model.order.IUocOrderModel;
import com.tydic.dyc.oc.model.order.UocOrderDo;
import com.tydic.dyc.oc.model.order.qrybo.UocOrdLogisticsRelaQryBo;
import com.tydic.dyc.oc.model.order.qrybo.UocOrderRelQryBo;
import com.tydic.dyc.oc.model.order.sub.UocOrdLogisticsRela;
import com.tydic.dyc.oc.model.order.sub.UocOrderRel;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderItemQryBo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleStakeholderQryBo;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleOrderItem;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleStakeholder;
import com.tydic.dyc.oc.model.sysdictionary.IUocSysDictionaryModel;
import com.tydic.dyc.oc.model.sysdictionary.qrybo.UocSysDictionaryQryBo;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 标题：UocEsSyncTransaction
 * 说明：成交服务费同步
 * 时间：2022/4/6 20:31
 *
 * @author 文乐
 */
@Component
@Slf4j
public class UocEsSyncTransaction implements IUocEsSync {

    @Autowired
    private UocIndexConfig uocIndexConfig;

    @Autowired
    private IUocSaleOrderModel iUocSaleOrderModel;

    @Autowired
    private IUocOrderModel iUocOrderModel;

    @Autowired
    private IUocInspOrderModel iUocInspOrderModel;
    @Autowired
    private IUocSysDictionaryModel iUocSysDictionaryModel;

    /**
     * 收取成交服务费
     */
    private static final String CHARGE_MONTH_SERVICE = "1";
    /**
     * 下单成功后收取
     */
    private static final String SALE = "1";
    /**
     * 验收后收取
     */
    private static final String INSP = "2";

    @Override
    public String indexName() {
        return uocIndexConfig.getTransactionIndex();
    }

    @Override
    public IUocEsSyncQryRspBo qryData(IUocEsSyncQryReqBo reqBo) {
        log.info("成交服务费同步入参："+reqBo);
        IUocEsSyncQryRspBo rspBo = new IUocEsSyncQryRspBo();
        rspBo.setObjId(reqBo.getObjId());
        Long orderId = reqBo.getOrderId();
        JSONObject supplierSignInfo = reqBo.getJsonObj();
        String supplierId = supplierSignInfo.getString("supplierId");
        // 是否收取月度成交服务费 1 收取 0 不收取
        String monthServiceFee = supplierSignInfo.getString("monthServiceFee");
        // 月度收取节点 1下单成功后收取 2 验收成功后收取'
        String monthReceiveNode = supplierSignInfo.getString("monthReceiveNode");
        // 销售品类列表
        JSONArray salesBOS = supplierSignInfo.getJSONArray("salesBOS");
        // 品类成交服务费率
        Map<String, String> serviceFeeRateMap = new HashMap<>(salesBOS.size());
        for (int i = 0; i < salesBOS.size(); i++) {
            JSONObject itemCat = salesBOS.getJSONObject(i);
            serviceFeeRateMap.put(supplierId + itemCat.getString("itemCatId"), itemCat.getString("serviceFeeRate"));
        }

        if (UocDicConstant.OBJ_TYPE.SALE.equals(reqBo.getObjType())) {
            // 下单成功 并且 是下单成功后收取服务费
            if ( SALE.equals(monthReceiveNode) ) {
                // 同步销售单成交服务费
                syncSaleTransaction(reqBo, rspBo, orderId, serviceFeeRateMap, monthServiceFee);
            } else {
                rspBo.setSyncFlag(false);
            }
        } else if (UocDicConstant.OBJ_TYPE.INSPECTION.equals(reqBo.getObjType())) {
            Long inspOrderId = reqBo.getObjId();
            // 验收单主体信息
            UocInspOrderDo inspOrderMain = getUocInspOrderDo(orderId, inspOrderId);
            // 销售单信息
            UocSaleOrderDo saleOrderMain = getUocSaleOrderDo(orderId, inspOrderMain.getSaleOrderId());
            // 查询是否已生成成交服务费（下单时的）
            UocOrderRel uocOrderRel = getUocOrderRel(orderId, saleOrderMain.getSaleOrderId(), UocDicConstant.OBJ_TYPE.SALE);
            // uocOrderRel为null代表下单的时候没有保存，说明是需要验收的时候同步成交服务费
            // 同理如果下单时候已经生成了成交服务费，说明下单时候同步；尽管验收的时候会走到这里但不需要同步
            if ( null == uocOrderRel ) {
                // 同步验收单成交服务费
                syncInspTransaction(reqBo, rspBo, orderId, serviceFeeRateMap, monthServiceFee, inspOrderMain, saleOrderMain);

                //对于没有成交服务的供应商不展示相关的已验收的订单(收取金额为0，不同步)
                String serMoney = rspBo.getJsonObj().getString("SER_PRICE_MONEY");
                if(new BigDecimal("serMoney").compareTo(BigDecimal.ZERO)==0){
                    rspBo.setSyncFlag(false);
                }
            } else {
                rspBo.setSyncFlag(false);
            }
        }
        putReceiverAddressBo(rspBo.getJsonObj(), orderId);
        return rspBo;
    }

    /**
     * 同步收货人地址
     * @param jsonObj
     * @param orderId
     */
    private void putReceiverAddressBo(JSONObject jsonObj, Long orderId) {
        UocOrderDo qryBo = new UocOrderDo();
        qryBo.setOrderId(orderId);
        UocOrderDo uocOrderDo = iUocOrderModel.qryOrderBy(qryBo);
        if (null != uocOrderDo) {
            UocOrdLogisticsRelaQryBo relaQryBo = new UocOrdLogisticsRelaQryBo();
            relaQryBo.setOrderId(uocOrderDo.getOrderId());
            relaQryBo.setContactId(uocOrderDo.getContactId());
            UocOrdLogisticsRela uocOrdLogisticsRela = this.iUocOrderModel.qryOrderLogisticsRela(relaQryBo);
            jsonObj.put(UocConstant.ES_MAIN_OTHER.RECEIVER_ADDRESS_BO, uocOrdLogisticsRela);
        }
    }

    /**
     * 同步验收单成交服务费
     */
    private void syncInspTransaction(IUocEsSyncQryReqBo reqBo, IUocEsSyncQryRspBo rspBo, Long orderId, Map<String, String> serviceFeeRateMap, String monthServiceFee, UocInspOrderDo inspOrderMain, UocSaleOrderDo saleOrderMain) {

        // 销售单明细
        List<UocSaleOrderItem> saleOrderItemList = getSaleOrderItemList(reqBo,saleOrderMain.getSaleOrderId());
        Map<Long, UocSaleOrderItem> saleOrderItemMap = saleOrderItemList.stream().collect(Collectors.toMap(UocSaleOrderItem::getSaleOrderItemId, o -> o));
        // 三方信息
        UocSaleStakeholder stakeholder = getStakeholder(saleOrderMain.getStakeholderId());
        // 订单关联结算信息
        UocOrderRel uocOrderRel = getUocOrderRel(orderId, inspOrderMain.getInspOrderId(), UocDicConstant.OBJ_TYPE.INSPECTION);
        // 验收单明细
        List<UocInspOrderItem> uocInspOrderItemList = getUocInspOrderItems(orderId, inspOrderMain,saleOrderItemMap);
        // 字典
        Map<String, Map<String, String>> dic = getDic(reqBo.getSysTenantId());
        Map<String, String> relTypeMap = dic.get(UocDicConstant.REL_TYPE.P_CODE);
        Map<String, String> relStatusMap = dic.get(UocDicConstant.REL_STATUS.P_CODE);

        JSONObject jsonObj = JSON.parseObject(JSON.toJSONString(saleOrderMain));
        jsonObj.putAll(BeanUtil.beanToMap(stakeholder, false, true));
        jsonObj.put(UocConstant.ES_MAIN_OTHER.INSP_ORDER_ID, inspOrderMain.getInspOrderId());
        jsonObj.put(UocConstant.ES_MAIN_OTHER.INSP_ORDER_NO, inspOrderMain.getInspOrderNo());

        log.info("成交服务费jsonObj："+jsonObj);
        log.info("成交服务费stakeholder："+stakeholder);
        log.info("成交服务费serviceFeeRateMap："+serviceFeeRateMap);

        JSONArray inspOrderItems = JSONArray.parseArray(JSON.toJSONString(uocInspOrderItemList));
        // 销售单成交服务费金额
        BigDecimal totalSerPriceMoney = BigDecimal.ZERO;
        // 单据销售金额
        BigDecimal totalSaleFee = BigDecimal.ZERO;
        // 单据采购金额
        BigDecimal totalPurchaseFee = BigDecimal.ZERO;
        for (int i = 0; i < inspOrderItems.size(); i++) {
            JSONObject inspItem = inspOrderItems.getJSONObject(i);
            UocSaleOrderItem uocSaleOrderItem = saleOrderItemMap.get(inspItem.getLong(UocConstant.ES_MAIN_OTHER.SALE_ORDER_ITEM_ID));
            log.info("销售单明细uocSaleOrderItem:"+uocSaleOrderItem+"saleOrderItemId:"+inspItem.getLong(UocConstant.ES_MAIN_OTHER.SALE_ORDER_ITEM_ID)+"验收明细："+inspItem);
            inspItem.put(UocConstant.ES_MAIN_OTHER.SKU_NAME, uocSaleOrderItem.getSkuName());
            inspItem.put(UocConstant.ES_MAIN_OTHER.SKU_ID, uocSaleOrderItem.getSkuId());
            inspItem.put(UocConstant.ES_MAIN_OTHER.SPEC, uocSaleOrderItem.getSpec());
            inspItem.put(UocConstant.ES_MAIN_OTHER.MODEL, uocSaleOrderItem.getModel());
            inspItem.put(UocConstant.ES_MAIN_OTHER.COMMODITY_TYPE_ID, uocSaleOrderItem.getCommodityTypeId());
            inspItem.put(UocConstant.ES_MAIN_OTHER.UNIT_NAME, uocSaleOrderItem.getUnitName());
            inspItem.put(UocConstant.ES_MAIN_OTHER.ITEM_COUNT, inspItem.get(UocConstant.ES_MAIN_OTHER.INSP_COUNT));
            inspItem.put(UocConstant.ES_MAIN_OTHER.SALE_PRICE, uocSaleOrderItem.getSalePrice());
            inspItem.put(UocConstant.ES_MAIN_OTHER.PUR_PRICE, uocSaleOrderItem.getPurchasePrice());
            log.info("诚交服务费inspItem debug："+inspItem);
            String serviceFeeRate = serviceFeeRateMap.get(jsonObj.getString(UocConstant.ES_MAIN_OTHER.SUP_ID) + inspItem.getString(UocConstant.ES_MAIN_OTHER.COMMODITY_TYPE_ID));
            log.info("诚交服务费serviceFeeRate debug："+serviceFeeRate);
            BigDecimal serPriceMoney = new BigDecimal(inspItem.getString(UocConstant.ES_MAIN_OTHER.ITEM_COUNT))
                    .multiply(new BigDecimal(inspItem.getString(UocConstant.ES_MAIN_OTHER.SALE_PRICE)))
                    .multiply(new BigDecimal(serviceFeeRate)).divide(new BigDecimal(100), RoundingMode.CEILING);
            // 明细成交服务费金额
            inspItem.put(UocConstant.ES_MAIN_OTHER.SER_PRICE_MONEY, serPriceMoney);
            inspItem.put(UocConstant.ES_MAIN_OTHER.SERVICE_FEE_RATE, CHARGE_MONTH_SERVICE.equals(monthServiceFee) ? serviceFeeRate : BigDecimal.ZERO);
            totalSerPriceMoney = totalSerPriceMoney.add(serPriceMoney);
            totalPurchaseFee = totalPurchaseFee.add(uocSaleOrderItem.getPurchasePrice().multiply(new BigDecimal(inspItem.getString(UocConstant.ES_MAIN_OTHER.INSP_COUNT))));
            totalSaleFee = totalSaleFee.add(uocSaleOrderItem.getSalePrice().multiply(new BigDecimal(inspItem.getString(UocConstant.ES_MAIN_OTHER.INSP_COUNT))));
        }
        jsonObj.put(UocConstant.ES_MAIN_OTHER.INSP_SALE_FEE, inspOrderMain.getInspOrderNo());
        jsonObj.put(UocConstant.ES_MAIN_OTHER.ORDER_ITEM, inspOrderItems);
        jsonObj.put(UocConstant.ES_MAIN_OTHER.MONTH_SERVICE_FEE, monthServiceFee);
        jsonObj.put(UocConstant.ES_MAIN_OTHER.SALE_FEE, totalSaleFee);
        jsonObj.put(UocConstant.ES_MAIN_OTHER.PUR_FEE, totalPurchaseFee);
        jsonObj.put(UocConstant.ES_MAIN_OTHER.SER_PRICE_MONEY, CHARGE_MONTH_SERVICE.equals(monthServiceFee) ? totalSerPriceMoney : BigDecimal.ZERO);
        jsonObj.put(UocConstant.ES_MAIN_OTHER.SUP_NO_RULE, jsonObj.getString(UocConstant.ES_MAIN_OTHER.SUP_ID) + INSP);
        jsonObj.put(UocConstant.ES_MAIN_OTHER.OBJ_TYPE, UocDicConstant.OBJ_TYPE.INSPECTION);
        jsonObj.put(UocConstant.ES_MAIN_OTHER.OBJ_TIME, new Date());
        if ( null != uocOrderRel ) {
            jsonObj.put(UocConstant.ES_MAIN_OTHER.REL_TYPE, uocOrderRel.getRelType());
            jsonObj.put(UocConstant.ES_MAIN_OTHER.REL_STATUS, uocOrderRel.getRelStatus());
            jsonObj.put(UocConstant.ES_MAIN_OTHER.REL_INFO, uocOrderRel.getRelStatus() +","+ uocOrderRel.getRelType());
            jsonObj.put(UocConstant.ES_MAIN_OTHER.REL_ID, uocOrderRel.getRelId());
            jsonObj.put(UocConstant.ES_MAIN_OTHER.REL_STATUS_STR, relStatusMap.get(Convert.toStr(uocOrderRel.getRelStatus())));
            jsonObj.put(UocConstant.ES_MAIN_OTHER.REL_TYPE_STR, relTypeMap.get(Convert.toStr(uocOrderRel.getRelType())));
        } else {
            jsonObj.put(UocConstant.ES_MAIN_OTHER.REL_TYPE, UocDicConstant.REL_TYPE.SERVICE_CHARGE);
            jsonObj.put(UocConstant.ES_MAIN_OTHER.REL_STATUS, UocDicConstant.REL_STATUS.UN_SUBMITTED);
            jsonObj.put(UocConstant.ES_MAIN_OTHER.REL_INFO, UocDicConstant.REL_STATUS.UN_SUBMITTED +","+ UocDicConstant.REL_TYPE.SERVICE_CHARGE);
            jsonObj.put(UocConstant.ES_MAIN_OTHER.REL_STATUS_STR, relStatusMap.get(Convert.toStr(UocDicConstant.REL_STATUS.UN_SUBMITTED)));
            jsonObj.put(UocConstant.ES_MAIN_OTHER.REL_TYPE_STR, relTypeMap.get(Convert.toStr(UocDicConstant.REL_TYPE.SERVICE_CHARGE)));
        }

        // 取销售单ID
        jsonObj.put(UocConstant.ES_MAIN_OTHER.ORDER_ID, saleOrderMain.getSaleOrderId());
        log.info("同步验收单成交服务费："+jsonObj);
        rspBo.setJsonObj(jsonObj);
    }

    /**
     * 同步验收单成交服务费
     */
    private void syncSaleTransaction(IUocEsSyncQryReqBo reqBo, IUocEsSyncQryRspBo rspBo, Long orderId, Map<String, String> serviceFeeRateMap, String monthServiceFee) {
        Long saleOrderId = reqBo.getObjId();
        // 销售单主体信息
        UocSaleOrderDo saleOrderMain = getUocSaleOrderDo(orderId, saleOrderId);
        // 三方信息
        UocSaleStakeholder stakeholder = getStakeholder(saleOrderMain.getStakeholderId());
        // 订单关联结算信息
        UocOrderRel uocOrderRel = getUocOrderRel(orderId, saleOrderId, UocDicConstant.OBJ_TYPE.SALE);
        // 销售单明细
        List<UocSaleOrderItem> saleOrderItemList = getSaleOrderItemList(reqBo,saleOrderMain.getSaleOrderId());
        // 字典
        Map<String, Map<String, String>> dic = getDic(reqBo.getSysTenantId());
        Map<String, String> relTypeMap = dic.get(UocDicConstant.REL_TYPE.P_CODE);
        Map<String, String> relStatusMap = dic.get(UocDicConstant.REL_STATUS.P_CODE);

        JSONObject jsonObj = JSON.parseObject(JSON.toJSONString(saleOrderMain));
        jsonObj.putAll(BeanUtil.beanToMap(stakeholder, false, true));
        jsonObj.put(UocConstant.ES_MAIN_OTHER.SUP_NO, stakeholder.getSupId());
        jsonObj.put(UocConstant.ES_MAIN_OTHER.SUP_ID, stakeholder.getSupId());
        JSONArray saleOrderItems = JSONArray.parseArray(JSON.toJSONString(saleOrderItemList));
        // 销售单成交服务费金额
        BigDecimal totalSerPriceMoney = BigDecimal.ZERO;
        // 单据销售金额
        BigDecimal totalSaleFee = BigDecimal.ZERO;
        // 单据采购金额
        BigDecimal totalPurchaseFee = BigDecimal.ZERO;
        for (int i = 0; i < saleOrderItems.size(); i++) {
            JSONObject saleItem = saleOrderItems.getJSONObject(i);
            saleItem.put(UocConstant.ES_MAIN_OTHER.ITEM_COUNT, saleItem.get(UocConstant.ES_MAIN_OTHER.PUR_COUNT));
            String serviceFeeRate = serviceFeeRateMap.get(jsonObj.getString(UocConstant.ES_MAIN_OTHER.SUP_ID) + saleItem.getString(UocConstant.ES_MAIN_OTHER.COMMODITY_TYPE_ID));
            BigDecimal serPriceMoney = new BigDecimal(saleItem.getString(UocConstant.ES_MAIN_OTHER.SALE_PRICE))
                    .multiply(new BigDecimal(saleItem.getString(UocConstant.ES_MAIN_OTHER.PURCHASE_COUNT)))
                    .multiply(new BigDecimal(serviceFeeRate)).divide(new BigDecimal(100), RoundingMode.CEILING);
            // 明细成交服务费金额
            saleItem.put(UocConstant.ES_MAIN_OTHER.SER_PRICE_MONEY, CHARGE_MONTH_SERVICE.equals(monthServiceFee) ? serPriceMoney : BigDecimal.ZERO);
            saleItem.put(UocConstant.ES_MAIN_OTHER.SERVICE_FEE_RATE, serviceFeeRate);
            totalSerPriceMoney = totalSerPriceMoney.add(serPriceMoney);
            totalPurchaseFee = totalPurchaseFee.add(new BigDecimal(saleItem.getString(UocConstant.ES_MAIN_OTHER.PURCHASE_PRICE)).multiply(new BigDecimal(saleItem.getString(UocConstant.ES_MAIN_OTHER.PURCHASE_COUNT))));
            totalSaleFee = totalSaleFee.add(new BigDecimal(saleItem.getString(UocConstant.ES_MAIN_OTHER.SALE_PRICE)).multiply(new BigDecimal(saleItem.getString(UocConstant.ES_MAIN_OTHER.PURCHASE_COUNT))));
        }
        jsonObj.put(UocConstant.ES_MAIN_OTHER.ORDER_ITEM, saleOrderItems);
        jsonObj.put(UocConstant.ES_MAIN_OTHER.MONTH_SERVICE_FEE, monthServiceFee);
        jsonObj.put(UocConstant.ES_MAIN_OTHER.SALE_FEE, totalSaleFee);
        jsonObj.put(UocConstant.ES_MAIN_OTHER.PUR_FEE, totalPurchaseFee);
        jsonObj.put(UocConstant.ES_MAIN_OTHER.SER_PRICE_MONEY, CHARGE_MONTH_SERVICE.equals(monthServiceFee) ? totalSerPriceMoney : BigDecimal.ZERO);
        jsonObj.put(UocConstant.ES_MAIN_OTHER.SUP_NO_RULE, jsonObj.getString(UocConstant.ES_MAIN_OTHER.SUP_ID) + SALE);
        jsonObj.put(UocConstant.ES_MAIN_OTHER.OBJ_TYPE, UocDicConstant.OBJ_TYPE.SALE);
        jsonObj.put(UocConstant.ES_MAIN_OTHER.OBJ_TIME, new Date());
        if ( null != uocOrderRel ) {
            jsonObj.put(UocConstant.ES_MAIN_OTHER.REL_TYPE, uocOrderRel.getRelType());
            jsonObj.put(UocConstant.ES_MAIN_OTHER.REL_STATUS, uocOrderRel.getRelStatus());
            jsonObj.put(UocConstant.ES_MAIN_OTHER.REL_INFO, uocOrderRel.getRelStatus() +","+ uocOrderRel.getRelType());
            jsonObj.put(UocConstant.ES_MAIN_OTHER.REL_ID, uocOrderRel.getRelId());
            jsonObj.put(UocConstant.ES_MAIN_OTHER.REL_STATUS_STR, relStatusMap.get(Convert.toStr(uocOrderRel.getRelStatus())));
            jsonObj.put(UocConstant.ES_MAIN_OTHER.REL_TYPE_STR, relTypeMap.get(Convert.toStr(uocOrderRel.getRelType())));
        } else {
            jsonObj.put(UocConstant.ES_MAIN_OTHER.REL_TYPE, UocDicConstant.REL_TYPE.SERVICE_CHARGE);
            jsonObj.put(UocConstant.ES_MAIN_OTHER.REL_STATUS, UocDicConstant.REL_STATUS.UN_SUBMITTED);
            jsonObj.put(UocConstant.ES_MAIN_OTHER.REL_INFO, UocDicConstant.REL_STATUS.UN_SUBMITTED +","+ UocDicConstant.REL_TYPE.SERVICE_CHARGE);
            jsonObj.put(UocConstant.ES_MAIN_OTHER.REL_STATUS_STR, relStatusMap.get(Convert.toStr(UocDicConstant.REL_STATUS.UN_SUBMITTED)));
            jsonObj.put(UocConstant.ES_MAIN_OTHER.REL_TYPE_STR, relTypeMap.get(Convert.toStr(UocDicConstant.REL_TYPE.SERVICE_CHARGE)));
        }

        // 取销售单ID
        jsonObj.put(UocConstant.ES_MAIN_OTHER.ORDER_ID, saleOrderMain.getSaleOrderId());
        rspBo.setJsonObj(jsonObj);
    }

    /**
     * 验收单明细
     */
    private List<UocInspOrderItem> getUocInspOrderItems(Long orderId, UocInspOrderDo inspOrderMain,Map<Long, UocSaleOrderItem> saleOrderItemMap) {
        UocInspOrderItemQryBo uocInspOrderItemQryBo = new UocInspOrderItemQryBo();
        uocInspOrderItemQryBo.setOrderId(orderId);
        uocInspOrderItemQryBo.setInspOrderId(inspOrderMain.getInspOrderId());
        UocInspOrderDo inspOrderItem = iUocInspOrderModel.getListInspOrderItem(uocInspOrderItemQryBo);
        List<UocInspOrderItem> uocInspOrderItemList = inspOrderItem.getUocInspOrderItemList();
        uocInspOrderItemList.forEach(obj->{
            UocSaleOrderItem saleOrderItem = saleOrderItemMap.get(obj.getSaleOrderItemId());
            if(null != saleOrderItem){
                obj.setUnitDigit(saleOrderItem.getUnitDigit());
            }
        });
        return uocInspOrderItemList;
    }

    /**
     * 验收单主体信息
     */
    private UocInspOrderDo getUocInspOrderDo(Long orderId, Long inspOrderId) {
        UocInspOrderQryBo uocInspOrderQryBo = new UocInspOrderQryBo();
        uocInspOrderQryBo.setOrderId(orderId);
        uocInspOrderQryBo.setInspOrderId(inspOrderId);
        return iUocInspOrderModel.getInspOrderMain(uocInspOrderQryBo);
    }


    /**
     * 订单结算关联信息
     */
    private UocOrderRel getUocOrderRel(Long orderId, Long objId, Integer objType) {
        UocOrderRelQryBo uocOrderRelQryBo = new UocOrderRelQryBo();
        uocOrderRelQryBo.setRelType(UocDicConstant.REL_TYPE.SERVICE_CHARGE);
        uocOrderRelQryBo.setOrderId(orderId);
        uocOrderRelQryBo.setObjId(objId);
        uocOrderRelQryBo.setObjType(objType);
        return iUocOrderModel.qryRelInfo(uocOrderRelQryBo);
    }

    /**
     * 查询销售单主体
     */
    private UocSaleOrderDo getUocSaleOrderDo(Long orderId, Long saleOrderId) {
        UocSaleOrderDo uocSaleOrderDo = new UocSaleOrderDo();
        uocSaleOrderDo.setOrderId(orderId);
        uocSaleOrderDo.setSaleOrderId(saleOrderId);
        return iUocSaleOrderModel.getSaleOrderMain(uocSaleOrderDo);
    }

    /**
     * 查询销售单明细
     */
    private List<UocSaleOrderItem> getSaleOrderItemList(IUocEsSyncQryReqBo reqBo,Long saleOrderId) {
        UocSaleOrderItemQryBo uocSaleOrderItemQryBo = new UocSaleOrderItemQryBo();
        uocSaleOrderItemQryBo.setSaleOrderId(saleOrderId);
        uocSaleOrderItemQryBo.setOrderId(reqBo.getOrderId());
        return iUocSaleOrderModel.getSaleOrderItemList(uocSaleOrderItemQryBo);
    }

    /**
     * 三方信息
     */
    private UocSaleStakeholder getStakeholder(Long stakeholderId) {
        UocSaleStakeholderQryBo uocSaleStakeholderQryBo = new UocSaleStakeholderQryBo();
        uocSaleStakeholderQryBo.setStakeholderId(stakeholderId);
        List<UocSaleStakeholder> uocSaleStakeholders = iUocSaleOrderModel.qrySaleOrderStakeholder(uocSaleStakeholderQryBo);
       return uocSaleStakeholders.get(0);
    }

    /**
     * 字典
     */
    private Map<String, Map<String, String>> getDic(Long sysTenantId) {
        List<String> pCodes = new ArrayList<>();
        pCodes.add(UocDicConstant.REL_TYPE.P_CODE);
        pCodes.add(UocDicConstant.REL_STATUS.P_CODE);
        UocSysDictionaryQryBo uocSysDictionaryQryBo = new UocSysDictionaryQryBo();
        uocSysDictionaryQryBo.setSysTenantId(sysTenantId);
        uocSysDictionaryQryBo.setPCodes(pCodes);
        return iUocSysDictionaryModel.getDictionaryMap(uocSysDictionaryQryBo);
    }
}
