/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.oc.components.event.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.tydic.dyc.oc.components.es.IUocEsSyncQryReqBo;
import com.tydic.dyc.oc.components.event.EventConsumer;
import com.tydic.dyc.oc.components.event.IUocEsSyncQryEventReqBo;
import com.tydic.dyc.oc.config.UocIndexConfig;
import com.tydic.dyc.oc.utils.UocRu;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class EventConsumerCreateOrder
implements EventConsumer {
    private static final Logger log = LoggerFactory.getLogger(EventConsumerCreateOrder.class);
    @Autowired
    private UocIndexConfig uocIndexConfig;

    @Override
    public List<IUocEsSyncQryEventReqBo> parseMap(Map<String, Object> map) {
        Object saleOrderListObj;
        log.info("event-EventConsumerCreateOrder->{}", (Object)JSON.toJSONString(map));
        ArrayList<IUocEsSyncQryEventReqBo> retList = new ArrayList<IUocEsSyncQryEventReqBo>();
        Long orderId = Long.valueOf((String)map.get("orderId"));
        Long sysTenantId = UocRu.parseLong(map.get("sysTenantId"));
        if (ObjectUtil.isNotEmpty((Object)orderId) && ObjectUtil.isNotEmpty((Object)(saleOrderListObj = map.get("saleOrderList")))) {
            JSONArray saleOrderList = JSON.parseArray((String)JSON.toJSONString((Object)saleOrderListObj));
            ArrayList<IUocEsSyncQryReqBo> saleList = new ArrayList<IUocEsSyncQryReqBo>();
            ArrayList implList = new ArrayList();
            if (ObjectUtil.isNotEmpty((Object)saleOrderList)) {
                for (int i = 0; i < saleOrderList.size(); ++i) {
                    JSONObject arrayJson = saleOrderList.getJSONObject(i);
                    Long saleOrderId = arrayJson.getLong("saleOrderId");
                    if (saleOrderId == null) continue;
                    IUocEsSyncQryReqBo syncQryReqBo = new IUocEsSyncQryReqBo();
                    syncQryReqBo.setOrderId(orderId);
                    syncQryReqBo.setObjId(saleOrderId);
                    syncQryReqBo.setSysTenantId(sysTenantId);
                    saleList.add(syncQryReqBo);
                }
            }
            if (ObjectUtil.isNotEmpty(saleList)) {
                IUocEsSyncQryEventReqBo eventReqBo = new IUocEsSyncQryEventReqBo();
                eventReqBo.setIndexName(this.uocIndexConfig.getSaleOrderIndex());
                eventReqBo.setDataList(saleList);
                retList.add(eventReqBo);
            }
        }
        return retList;
    }

    @Override
    public String getEvent() {
        return "UOCE_CREATE_ORDER";
    }
}

