package com.tydic.dyc.oc.service.order;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.constants.UocRspConstants;
import com.tydic.dyc.oc.model.audit.IUocAuditOrderModel;
import com.tydic.dyc.oc.model.audit.UocAuditOrderDo;
import com.tydic.dyc.oc.model.audit.qrybo.UocApprovalObjQryBo;
import com.tydic.dyc.oc.model.audit.qrybo.UocAuditOrderQryBo;
import com.tydic.dyc.oc.model.audit.sub.UocApprovalObj;
import com.tydic.dyc.oc.model.order.IUocOrderModel;
import com.tydic.dyc.oc.model.order.UocOrderDo;
import com.tydic.dyc.oc.model.order.qrybo.*;
import com.tydic.dyc.oc.model.order.sub.UocOrdLogisticsRela;
import com.tydic.dyc.oc.model.order.sub.UocOrderAccessory;
import com.tydic.dyc.oc.model.order.sub.UocOrderItem;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderItemQryBo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderQryBo;
import com.tydic.dyc.oc.model.sysdictionary.IUocSysDictionaryModel;
import com.tydic.dyc.oc.model.sysdictionary.qrybo.UocSysDictionaryQryBo;
import com.tydic.dyc.oc.service.order.bo.*;
import com.tydic.dyc.oc.utils.UocRu;
import lombok.extern.ohaotian.HTServiceImpl;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * 标题:UocGetOrderAllDetailServiceImpl
 * 说明:
 * 时间:2022/5/19 16:23
 *
 * @author 童垣杰
 */
@Slf4j
@HTServiceImpl
public class UocGetOrderAllDetailServiceImpl implements UocGetOrderAllDetailService{

    @Autowired
    private IUocOrderModel iUocOrderModel;

    @Autowired
    private IUocSaleOrderModel iUocSaleOrderModel;

    @Autowired
    private IUocSysDictionaryModel iUocSysDictionaryModel;
    
    @Autowired
    private IUocAuditOrderModel iUocAuditOrderModel;

    private static final String DEFAULT_PAY_TYPE = "2";
    private static final String DEFAULT_PAY_TYPE_STR = "帐期支付";

    @Override
    public UocGetOrderAllDetailServiceRspBo getOrderAllDetail(UocGetOrderAllDetailServiceReqBo reqBo) {
        //1.入参校验
        val(reqBo);

        //2.查询主订单信息
        UocOrderDo uocOrderDo = new UocOrderDo();
        uocOrderDo.setOrderId(reqBo.getOrderId());
        UocOrderDo orderDo = iUocOrderModel.qryOrderBy(uocOrderDo);
        if (orderDo == null){
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_THREE_DATA_NULL, "未查询到 [ orderId = "+reqBo.getOrderId()+" ]，对应的订单信息！");
        }
        //将主订单信息封装入反参
        UocGetOrderAllDetailServiceRspBo rspBo = UocRu.js(orderDo, UocGetOrderAllDetailServiceRspBo.class);

        // 付款方式
        rspBo.setPayType(DEFAULT_PAY_TYPE);
        rspBo.setPayTypeStr(DEFAULT_PAY_TYPE_STR);

        //3.查询收货地址信息
        UocOrdLogisticsRelaQryBo uocOrdLogisticsRelaQryBo = new UocOrdLogisticsRelaQryBo();
        uocOrdLogisticsRelaQryBo.setOrderId(reqBo.getOrderId());
        uocOrdLogisticsRelaQryBo.setContactId(orderDo.getContactId());
        log.info("查询收货地址信息入参,{}",uocOrdLogisticsRelaQryBo.toString());
        UocOrdLogisticsRela uocOrdLogisticsRela = iUocOrderModel.qryOrderLogisticsRela(uocOrdLogisticsRelaQryBo);
        //将收货地址封装入反参 一个整单对应一条地址
        rspBo.setLogisticsBo(UocRu.js(uocOrdLogisticsRela,UocGetOrderAllDetailServiceRspOrderLogisticsBo.class));

        //4.查询三方信息
        UocOrderStakeholderQryBo uocOrderStakeholderQryBo = new UocOrderStakeholderQryBo();
        uocOrderStakeholderQryBo.setOrderId(reqBo.getOrderId());
        List<UocOrderStakeholderQryBo> uocOrderStakeholderQryBos = iUocOrderModel.qryStakeholderList(uocOrderStakeholderQryBo);
        //封装三方信息
        rspBo.setSaleStakeBos(UocRu.jsl(uocOrderStakeholderQryBos, UocGetOrderAllDetailServiceRspSaleStakeBo.class));

        //5.查询附件信息
        UocOrderAccessoryQryBo accessoryQryBo = new UocOrderAccessoryQryBo();
        accessoryQryBo.setObjId(reqBo.getOrderId());
        accessoryQryBo.setOrderId(reqBo.getOrderId());
        accessoryQryBo.setObjType(UocDicConstant.OBJ_TYPE.ORDER);
        List<UocOrderAccessory> orderAccessoryList = iUocOrderModel.getOrderAccessoryList(accessoryQryBo);
        //封装附件信息
        rspBo.setAccessoryBos(UocRu.jsl(orderAccessoryList, UocGetOrderAllDetailServiceRspAccessoryBo.class));

        //6.查询商品详情
        UocOrderItemQryBo uocOrderItemQryBo = new UocOrderItemQryBo();
        uocOrderItemQryBo.setOrderId(reqBo.getOrderId());
        List<UocOrderItem> uocOrderItems = iUocOrderModel.qryOrderItemList(uocOrderItemQryBo);
        //封装商品信息
        //每条商品清单的商品金额自己算
        List<UocGetOrderAllDetailServiceRspOrderCommInfoBo> commInfoBos = UocRu.jsl(uocOrderItems, UocGetOrderAllDetailServiceRspOrderCommInfoBo.class);
        for (UocGetOrderAllDetailServiceRspOrderCommInfoBo commInfoBo : commInfoBos) {
            BigDecimal saleFee = new BigDecimal(commInfoBo.getSalePrice()).multiply(commInfoBo.getPurchaseCount());
            BigDecimal purchaseFee = commInfoBo.getPurchasePrice().multiply(commInfoBo.getPurchaseCount());
            commInfoBo.setSaleFee(saleFee);
            commInfoBo.setPurchaseFee(purchaseFee);

            //7.从saleOrderItem获取比选单号，取第一个就行。量很小，可循环
            UocSaleOrderItemQryBo uocSaleOrderItemQryBo = new UocSaleOrderItemQryBo();
            uocSaleOrderItemQryBo.setOrderId(commInfoBo.getOrderId());
            uocSaleOrderItemQryBo.setOrderItemId(commInfoBo.getOrderItemId());
            UocSaleOrderDo uocSaleOrderDo = iUocSaleOrderModel.qryListSaleOrderItem(uocSaleOrderItemQryBo);
            uocSaleOrderItemQryBo.setSaleOrderId(uocSaleOrderDo.getSaleOrderItems().get(0).getSaleOrderId());
            String cmpOrderNo = uocSaleOrderDo.getSaleOrderItems().get(0).getCmpOrderNo();
            //封装比选单号
            commInfoBo.setCmpOrderNo(cmpOrderNo);
            commInfoBo.setNoCmpReason(uocSaleOrderDo.getSaleOrderItems().get(0).getNoCmpReason());
        }
        rspBo.setCommInfoBos(commInfoBos);

        //7.从销售单获取支付状态，采购计划
        UocSaleOrderDo uocSaleOrderDo = new UocSaleOrderDo();
//        uocSaleOrderDo.setSaleOrderId(rspBo.getCommInfoBos().get(0).getSaleOrderId());
//        uocSaleOrderDo.setOrderId(reqBo.getOrderId());
        UocSaleOrderQryBo uocSaleOrderQryBo = new UocSaleOrderQryBo();
        uocSaleOrderQryBo.setOrderId(reqBo.getOrderId());
        List<UocSaleOrderDo> saleOrderList = iUocSaleOrderModel.getSaleOrderList(uocSaleOrderQryBo);
        if (CollectionUtil.isNotEmpty(saleOrderList)) {
            UocSaleOrderDo saleOrderMain = saleOrderList.get(0);
            //封装支付状态，采购计划
            rspBo.setPayState(saleOrderMain.getPayState().toString());
            rspBo.setPurchaseMode(saleOrderMain.getPurchaseMode());
            rspBo.setCancelOperName(saleOrderMain.getCancelOperName());
            rspBo.setCancelTime(saleOrderMain.getCancelTime());
            rspBo.setCancelReason(saleOrderMain.getCancelReason());
        }
        //查询审批状态
        UocApprovalObjQryBo uocApprovalObjQryBo = new UocApprovalObjQryBo();
        uocApprovalObjQryBo.setOrderId(reqBo.getOrderId());
        uocApprovalObjQryBo.setObjType(UocDicConstant.OBJ_TYPE.ORDER);
        List<UocApprovalObj> approvalObjList = iUocAuditOrderModel.qryApprovealObj(uocApprovalObjQryBo);
       
        if(ObjectUtil.isNotEmpty(approvalObjList)){
            UocAuditOrderQryBo auditOrderQryBo = new UocAuditOrderQryBo();
            auditOrderQryBo.setAuditOrderId(approvalObjList.get(0).getAuditOrderId());
            UocAuditOrderDo uocAuditOrderDo = iUocAuditOrderModel.qryAuditOrder(auditOrderQryBo);
            rspBo.setAuditOrderStatus(uocAuditOrderDo.getAuditOrderStatus());
        }
        
        //8. 翻译
        transelate(rspBo,reqBo.getSysTenantId());

        return rspBo;
    }

    private void transelate(UocGetOrderAllDetailServiceRspBo rspBo, Long sysTenantId) {
        Map<String, Map<String, String>> dic = getDic(sysTenantId);
        if (rspBo.getPayState() != null) {
            String payStateStr = dic.get(UocDicConstant.PAY_STATE.P_CODE).get(rspBo.getPayState());
            rspBo.setPayStateStr(payStateStr);
        }
        if (rspBo.getOrderState() != null) {
            String orderStateStr = dic.get(UocDicConstant.ORDER_STATE.P_CODE).get(rspBo.getOrderState());
            rspBo.setOrderStateStr(orderStateStr);
        }
        if (rspBo.getPurchaseMode() != null) {
            String purchaseModeStr = dic.get(UocDicConstant.PURCHASE_MODE.P_CODE).get(rspBo.getPurchaseMode().toString());
            rspBo.setPurchaseModeStr(purchaseModeStr);
        }
        if (rspBo.getPayType() != null) {
            String payTypeStr = dic.get(UocDicConstant.PAY_TYPE.P_CODE).get(rspBo.getPayType());
            rspBo.setPayTypeStr(payTypeStr);
        }
        //审批单状态
        if (rspBo.getAuditOrderStatus() != null) {
            String auditOrderStatusStr = dic.get(UocDicConstant.ORDER_STATE.P_CODE).get(rspBo.getAuditOrderStatus());
            rspBo.setAuditOrderStatusStr(auditOrderStatusStr);
        }

    }

    private void val(UocGetOrderAllDetailServiceReqBo reqBo){
        if (reqBo == null){
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象不能不为空");
        }
        if (StringUtils.isEmpty(reqBo.getOrderId())){
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参【orderId】不能为空");
        }
    }

    /**
     * 查询字典
     */
    private Map<String, Map<String, String>> getDic(Long sysTenantId) {
        List<String> pCodes = new ArrayList<>();
        pCodes.add(UocDicConstant.PAY_STATE.P_CODE);
        pCodes.add(UocDicConstant.PURCHASE_MODE.P_CODE);
        pCodes.add(UocDicConstant.ORDER_STATE.P_CODE);
        pCodes.add(UocDicConstant.PAY_TYPE.P_CODE);
        UocSysDictionaryQryBo uocSysDictionaryQryBo = new UocSysDictionaryQryBo();
        uocSysDictionaryQryBo.setSysTenantId(sysTenantId);
        uocSysDictionaryQryBo.setPCodes(pCodes);
        return iUocSysDictionaryModel.getDictionaryMap(uocSysDictionaryQryBo);
    }
}
