package com.tydic.dyc.oc.service.order;

import com.tydic.dyc.base.bo.BasePageRspBo;
import com.tydic.dyc.oc.model.order.IUocOrderModel;
import com.tydic.dyc.oc.model.order.qrybo.UocConfEvaluateQryBo;
import com.tydic.dyc.oc.model.order.sub.UocConfEvaluate;
import com.tydic.dyc.oc.service.order.bo.UocProOrderEvaluateInfoBo;
import com.tydic.dyc.oc.service.order.bo.UocProOrderEvaluatePageQueryReqBo;
import com.tydic.dyc.oc.service.order.bo.UocProOrderEvaluatePageQueryRspBo;
import com.tydic.dyc.oc.utils.UocRu;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;

/**
 * 标题：UocProOrderEvaluatePageQueryServiceImpl
 * 说明：订单评价配置分页查询API 实现类
 * 时间：2021/4/6 17:37
 * 作者 何秀全
 */
@HTServiceImpl
public class UocProOrderEvaluatePageQueryServiceImpl implements UocProOrderEvaluatePageQueryService {

	@Autowired
	private IUocOrderModel iUocOrderModel;

	@Override
	public UocProOrderEvaluatePageQueryRspBo queryOrderEvaluatePage(UocProOrderEvaluatePageQueryReqBo reqBo) {
		UocProOrderEvaluatePageQueryRspBo rspBo = UocRu.success(UocProOrderEvaluatePageQueryRspBo.class);
		UocConfEvaluateQryBo uocConfEvaluateQryBo = UocRu.js(reqBo, UocConfEvaluateQryBo.class);
		BasePageRspBo<UocConfEvaluate> uocConfEvaluateBasePageRspBo = iUocOrderModel.qryListPageConfEvaluate(uocConfEvaluateQryBo);
		rspBo.setTotal(uocConfEvaluateBasePageRspBo.getTotal());
		rspBo.setPageNo(uocConfEvaluateBasePageRspBo.getPageNo());
		rspBo.setRecordsTotal(uocConfEvaluateBasePageRspBo.getRecordsTotal());
		rspBo.setRows(UocRu.jsl(uocConfEvaluateBasePageRspBo.getRows(), UocProOrderEvaluateInfoBo.class));
		return rspBo;
	}
}
