package com.tydic.dyc.oc.components.event.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.tydic.dyc.oc.components.es.IUocEsSyncQryReqBo;
import com.tydic.dyc.oc.components.event.EventConsumer;
import com.tydic.dyc.oc.components.event.IUocEsSyncQryEventReqBo;
import com.tydic.dyc.oc.config.UocIndexConfig;
import com.tydic.dyc.oc.constants.UocEventConstant;
import com.tydic.dyc.oc.utils.UocRu;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;


/**
 * 标题:EventConsumerCommonSyncSale
 * 说明:解释变更单HR
 * 时间:2022/3/10 20:10
 * 作者:罗有
 */
@Component
@Slf4j
public class EventConsumerCommonSyncHRChng implements EventConsumer {
    @Autowired
    private UocIndexConfig uocIndexConfig;

    @Override
    public List<IUocEsSyncQryEventReqBo> parseMap(Map<String, Object> map) {
        log.info("event-EventConsumerCommonSyncHRChng->{}", JSON.toJSONString(map));
        List<IUocEsSyncQryEventReqBo> retList = new ArrayList<>();
        Object chngOrderIdListObj = map.get("chngOrderIdList");
        Object saleOrderIdListObj = map.get("saleOrderIdList");
        Object inspOrderIdListObj = map.get("inspOrderIdList");
        Object shipOrderIdListObj = map.get("shipOrderIdList");
        if (ObjectUtil.isNotEmpty(saleOrderIdListObj)) {
            List<String> saleOrderIdList = UocRu.jsl(saleOrderIdListObj, String.class);
            List<IUocEsSyncQryReqBo> saleList = new ArrayList<>();
            saleOrderIdList.forEach(x -> {
                IUocEsSyncQryReqBo sale = new IUocEsSyncQryReqBo();
                String[] xsplit = x.split("-");
                sale.setOrderId(Long.parseLong(xsplit[1]));
                sale.setObjId(Long.parseLong(xsplit[0]));
                saleList.add(sale);
            });
            IUocEsSyncQryEventReqBo shipEvent = new IUocEsSyncQryEventReqBo();
            shipEvent.setIndexName(uocIndexConfig.getSaleOrderIndex());
            shipEvent.setDataList(saleList);
            retList.add(shipEvent);
        }
        if (ObjectUtil.isNotEmpty(inspOrderIdListObj)) {
            List<String> inspOrderIdList = UocRu.jsl(inspOrderIdListObj, String.class);
            List<IUocEsSyncQryReqBo> inspList = new ArrayList<>();
            inspOrderIdList.forEach(x -> {
                IUocEsSyncQryReqBo insp = new IUocEsSyncQryReqBo();
                String[] xsplit = x.split("-");
                insp.setOrderId(Long.parseLong(xsplit[1]));
                insp.setObjId(Long.parseLong(xsplit[0]));
                inspList.add(insp);
            });
            IUocEsSyncQryEventReqBo shipEvent = new IUocEsSyncQryEventReqBo();
            shipEvent.setIndexName(uocIndexConfig.getInspOrderIndex());
            shipEvent.setDataList(inspList);
            retList.add(shipEvent);
        }
        if (ObjectUtil.isNotEmpty(shipOrderIdListObj)) {
            List<String> shipOrderIdList = UocRu.jsl(shipOrderIdListObj, String.class);
            List<IUocEsSyncQryReqBo> shipList = new ArrayList<>();
            shipOrderIdList.forEach(x -> {
                IUocEsSyncQryReqBo ship = new IUocEsSyncQryReqBo();
                String[] xsplit = x.split("-");
                ship.setOrderId(Long.parseLong(xsplit[1]));
                ship.setObjId(Long.parseLong(xsplit[0]));
                shipList.add(ship);
            });
            IUocEsSyncQryEventReqBo shipEvent = new IUocEsSyncQryEventReqBo();
            shipEvent.setIndexName(uocIndexConfig.getShipOrderIndex());
            shipEvent.setDataList(shipList);
            retList.add(shipEvent);
        }
        if (ObjectUtil.isNotEmpty(chngOrderIdListObj)) {
            List<String> chngOrderIdList = UocRu.jsl(chngOrderIdListObj, String.class);
            List<IUocEsSyncQryReqBo> chngList = new ArrayList<>();
            chngOrderIdList.forEach(x -> {
                IUocEsSyncQryReqBo chng = new IUocEsSyncQryReqBo();
                String[] xsplit = x.split("-");
                chng.setOrderId(Long.parseLong(xsplit[1]));
                chng.setObjId(Long.parseLong(xsplit[0]));
                chngList.add(chng);
            });
            IUocEsSyncQryEventReqBo shipEvent = new IUocEsSyncQryEventReqBo();
            shipEvent.setIndexName(uocIndexConfig.getChngOrderIndex());
            shipEvent.setDataList(chngList);
            retList.add(shipEvent);
        }

        return retList;
    }

    @Override
    public String getEvent() {
        return UocEventConstant.UOCE_ES_SYNC_CHNG_ORDER_HR;
    }
}


