package com.tydic.dyc.oc.service.domainservice;

import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.constants.UocRspConstants;
import com.tydic.dyc.oc.model.payorder.IUocPayOrderModel;
import com.tydic.dyc.oc.model.payorder.sub.UocOrderShouldPay;
import com.tydic.dyc.oc.service.domainservice.bo.UocShouldPayOrderQryServiceReqBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocShouldPayOrderQryServiceRspBo;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;

/**
 * 标题：UocShouldPayOrderQryServiceImpl
 * 说明：销售单应付单查询
 * 时间：2022/4/6 16:11
 * 作者： 周中贤
 */
@HTServiceImpl
public class UocShouldPayOrderQryServiceImpl implements UocShouldPayOrderQryService {

    /**
     * 应付单model
     */
    @Autowired
    private IUocPayOrderModel iUocPayOrderModel;

    /**
     * 销售单应付单查询
     *
     * @param reqBo
     * @return
     */
    @Override
    public UocShouldPayOrderQryServiceRspBo qryShouldPayOrder(UocShouldPayOrderQryServiceReqBo reqBo) {
        //1.入参校验
        val(reqBo);
        UocShouldPayOrderQryServiceRspBo rspBo = new UocShouldPayOrderQryServiceRspBo();
        rspBo.setRespCode(UocRspConstants.RSP_CODE_SUCCESS);
        rspBo.setRespDesc(UocRspConstants.RSP_DESC_SUCCESS);
        //2.查询应付单
        UocOrderShouldPay uocOrderShouldPay = new UocOrderShouldPay();
        uocOrderShouldPay.setOrderId(reqBo.getOrderId());
        uocOrderShouldPay.setObjectId(reqBo.getObjectId());
        uocOrderShouldPay.setObjectType(reqBo.getObjectType());
        uocOrderShouldPay.setShouldPayType(reqBo.getShouldPayType());
        UocOrderShouldPay orderShouldPay = iUocPayOrderModel.getOrderShouldPay(uocOrderShouldPay);
        if (orderShouldPay != null) {
            BeanUtils.copyProperties(orderShouldPay,rspBo);
        }
        return rspBo;
    }


    private void val(UocShouldPayOrderQryServiceReqBo reqBo) {
        if (reqBo == null) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象不能为空");
        }
        if (reqBo.getOrderId() == null) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参OrderId不能为空");
        }
        if (reqBo.getObjectId() == null) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参ObjectId不能为空");
        }
        if (reqBo.getObjectType() == null) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参ObjectType不能为空");
        }
        if (reqBo.getShouldPayType() == null) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参ShouldPayType不能为空");
        }
    }
}
