/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.oc.service.domainservice;

import cn.hutool.core.convert.Convert;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.components.es.UocEsSyncManager;
import com.tydic.dyc.oc.components.es.UocEsSyncManagerSaveDataReqBo;
import com.tydic.dyc.oc.config.UocIndexConfig;
import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.model.insporder.IUocInspOrderModel;
import com.tydic.dyc.oc.model.insporder.UocInspOrderDo;
import com.tydic.dyc.oc.model.insporder.qrybo.UocInspOrderQryBo;
import com.tydic.dyc.oc.model.payorder.IUocPayOrderModel;
import com.tydic.dyc.oc.model.payorder.sub.UocOrderShouldPay;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo;
import com.tydic.dyc.oc.model.shiporder.IUocShipOrderModel;
import com.tydic.dyc.oc.model.shiporder.UocShipOrderDo;
import com.tydic.dyc.oc.model.shiporder.qrybo.UocShipOrderQryBo;
import com.tydic.dyc.oc.model.sysdictionary.IUocSysDictionaryModel;
import com.tydic.dyc.oc.service.domainservice.UocPaymentCallbackService;
import com.tydic.dyc.oc.service.domainservice.bo.UocPaymentCallbackBO;
import com.tydic.dyc.oc.service.domainservice.bo.UocPaymentCallbackReqBO;
import com.tydic.dyc.oc.service.domainservice.bo.UocPaymentCallbackRspBO;
import com.tydic.dyc.oc.utils.UocRu;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"OC_GROUP_DEV/3.0.0/com.tydic.dyc.oc.service.domainservice.UocPaymentCallbackService"})
public class UocPaymentCallbackServiceImpl
implements UocPaymentCallbackService {
    private static final Logger log = LoggerFactory.getLogger(UocPaymentCallbackServiceImpl.class);
    @Autowired
    private IUocSaleOrderModel iUocSaleOrderModel;
    @Autowired
    private IUocPayOrderModel iUocPayOrderModel;
    @Autowired
    private IUocShipOrderModel iUocShipOrderModel;
    @Autowired
    private IUocInspOrderModel iUocInspOrderModel;
    @Autowired
    private IUocSysDictionaryModel iUocSysDictionaryModel;
    @Autowired
    private UocEsSyncManager uocEsSyncManager;
    @Autowired
    private UocIndexConfig uocIndexConfig;

    @PostMapping(value={"dealCallback"})
    public UocPaymentCallbackRspBO dealCallback(@RequestBody UocPaymentCallbackReqBO reqBO) {
        this.val(reqBO);
        for (UocPaymentCallbackBO uocPaymentCallbackBO : reqBO.getUocPaymentCallbackBOS()) {
            UocSaleOrderDo modifyEsBO = new UocSaleOrderDo();
            Long saleOrderID = this.qryBeforeData(uocPaymentCallbackBO);
            if (!uocPaymentCallbackBO.getPayResult().booleanValue()) {
                log.error("\u7ed3\u7b97\u56de\u8c03\u652f\u4ed8\u72b6\u6001\u4e3afalse");
                UocSaleOrderDo uocSaleOrderDo = new UocSaleOrderDo();
                uocSaleOrderDo.setOrderId(uocPaymentCallbackBO.getOrderId());
                uocSaleOrderDo.setSaleOrderId(saleOrderID);
                uocSaleOrderDo.setPayMod(uocPaymentCallbackBO.getPayMod());
                uocSaleOrderDo.setPayState(UocDicConstant.PAY_STATE.PAY_FAILED);
                this.iUocSaleOrderModel.modifySaleOrderMain(uocSaleOrderDo);
                modifyEsBO.setPayMod(uocPaymentCallbackBO.getPayMod());
                modifyEsBO.setPayState(UocDicConstant.PAY_STATE.PAY_FAILED);
            } else {
                UocOrderShouldPay set = new UocOrderShouldPay();
                set.setIsPayCompleted(UocDicConstant.SHOULD_PAY_ORDER_PAY_STATE.PAY_COMPLETED);
                set.setPaidAmount(uocPaymentCallbackBO.getShouldPayMoney());
                set.setUpdateTime(new Date());
                UocOrderShouldPay where = new UocOrderShouldPay();
                where.setFscShouldPayId(uocPaymentCallbackBO.getFscShouldPayId());
                this.iUocPayOrderModel.modifyOrderShouldPayMain(set, where);
                UocSaleOrderDo uocSaleOrderDo = new UocSaleOrderDo();
                uocSaleOrderDo.setOrderId(uocPaymentCallbackBO.getOrderId());
                uocSaleOrderDo.setSaleOrderId(saleOrderID);
                uocSaleOrderDo.setUsedFee(uocPaymentCallbackBO.getShouldPayMoney());
                uocSaleOrderDo.setPayMod(uocPaymentCallbackBO.getPayMod());
                Integer payStatus = this.payJudgeMethod(uocPaymentCallbackBO, saleOrderID);
                log.info("\u8ba2\u5355\u72b6\u6001\uff1a" + payStatus);
                uocSaleOrderDo.setPayState(payStatus);
                this.iUocSaleOrderModel.modifySaleOrderMain(uocSaleOrderDo);
                modifyEsBO.setUsedFee(uocPaymentCallbackBO.getShouldPayMoney());
                modifyEsBO.setPayMod(uocPaymentCallbackBO.getPayMod());
                modifyEsBO.setPayState(payStatus);
            }
            modifyEsBO.setSaleOrderId(saleOrderID);
            this.syncEs(modifyEsBO);
        }
        return UocRu.success(UocPaymentCallbackRspBO.class);
    }

    private Long qryBeforeData(UocPaymentCallbackBO uocPaymentCallbackBO) {
        UocOrderShouldPay uocOrderShouldPay = new UocOrderShouldPay();
        uocOrderShouldPay.setFscShouldPayId(uocPaymentCallbackBO.getFscShouldPayId());
        UocOrderShouldPay orderShouldPay = this.iUocPayOrderModel.getOrderShouldPay(uocOrderShouldPay);
        if (orderShouldPay == null) {
            log.error("\u6839\u636e\u7ed3\u7b97\u5e94\u4ed8id\u67e5\u8be2\u5e94\u4ed8\u5355\u4e3a\u7a7a,\u4f20\u5165\u7684fscShouldPayId\u4e3a\uff1a{}", (Object)uocPaymentCallbackBO.getFscShouldPayId());
            throw new BaseBusinessException("100001", "\u6839\u636e\u7ed3\u7b97\u5e94\u4ed8id\u67e5\u8be2\u5e94\u4ed8\u5355\u4e3a\u7a7a");
        }
        Long objectId = orderShouldPay.getObjectId();
        Integer objectType = orderShouldPay.getObjectType();
        uocPaymentCallbackBO.setObjectType(objectType);
        Long saleOrderID = this.qrySaleOrderID(uocPaymentCallbackBO, objectId, objectType);
        if (saleOrderID == null) {
            throw new BaseBusinessException("100001", "\u67e5\u8be2\u9500\u552e\u5355ID\u4e3a\u7a7a");
        }
        return saleOrderID;
    }

    private Integer payJudgeMethod(UocPaymentCallbackBO callbackBO, Long saleOrderID) {
        UocSaleOrderDo uocSaleOrderDo = new UocSaleOrderDo();
        uocSaleOrderDo.setSaleOrderId(saleOrderID);
        UocSaleOrderDo saleOrderMain = this.iUocSaleOrderModel.getSaleOrderMain(uocSaleOrderDo);
        Integer patStauts = saleOrderMain.getPayState();
        String saleOrderState = saleOrderMain.getSaleOrderState();
        Integer payType = Integer.valueOf(saleOrderMain.getPayType());
        if (UocDicConstant.PAY_TYPE.ADVANCE_PAYMENT_PRORATED.equals(payType)) {
            patStauts = UocDicConstant.PAY_STATE.PAYED;
        } else if (UocDicConstant.PAY_TYPE.PAY_BY_AGR_CONSTRAINT.equals(payType)) {
            patStauts = UocDicConstant.PAY_STATE.PART_PAY;
        } else {
            UocOrderShouldPay uocOrderShouldPay = new UocOrderShouldPay();
            uocOrderShouldPay.setOrderId(callbackBO.getOrderId());
            uocOrderShouldPay.setObjectType(callbackBO.getObjectType());
            if (UocDicConstant.OBJ_TYPE.SHIP.equals(callbackBO.getObjectType())) {
                UocShipOrderQryBo shipOrderQryBo = new UocShipOrderQryBo();
                shipOrderQryBo.setSaleOrderId(saleOrderID);
                List<UocShipOrderDo> shipOrderDoList = this.iUocShipOrderModel.getListShipOrder(shipOrderQryBo);
                uocOrderShouldPay.setObjectIdList(shipOrderDoList.stream().map(obj -> obj.getShipOrderId()).collect(Collectors.toList()));
                List<UocOrderShouldPay> listOrderShouldPay = this.iUocPayOrderModel.getListOrderShouldPay(uocOrderShouldPay);
                boolean payFlag = listOrderShouldPay.stream().allMatch(obj -> obj.getIsPayCompleted() == 1);
                patStauts = "XS_DH_DH".equals(saleOrderState) || "XS_YS_YS".equals(saleOrderState) && payFlag ? UocDicConstant.PAY_STATE.PAYED : UocDicConstant.PAY_STATE.PART_PAY;
            } else {
                UocInspOrderQryBo inspOrderQryBo = new UocInspOrderQryBo();
                inspOrderQryBo.setSaleOrderId(saleOrderID);
                List<UocInspOrderDo> inspOrderList = this.iUocInspOrderModel.getListInspOrder(inspOrderQryBo);
                uocOrderShouldPay.setObjectIdList(inspOrderList.stream().map(obj -> obj.getInspOrderId()).collect(Collectors.toList()));
                List<UocOrderShouldPay> listOrderShouldPay = this.iUocPayOrderModel.getListOrderShouldPay(uocOrderShouldPay);
                boolean payFlag = listOrderShouldPay.stream().allMatch(obj -> obj.getIsPayCompleted() == 1);
                patStauts = "XS_YS_YS".equals(saleOrderState) && payFlag ? UocDicConstant.PAY_STATE.PAYED : UocDicConstant.PAY_STATE.PART_PAY;
            }
        }
        return patStauts;
    }

    private Long qrySaleOrderID(UocPaymentCallbackBO uocPaymentCallbackBO, Long objectId, Integer objectType) {
        Long saleOrderId;
        if (UocDicConstant.OBJ_TYPE.SALE.equals(objectType)) {
            saleOrderId = objectId;
        } else if (UocDicConstant.OBJ_TYPE.SHIP.equals(objectType)) {
            UocShipOrderQryBo uocShipOrderQryBo = new UocShipOrderQryBo();
            uocShipOrderQryBo.setOrderId(uocPaymentCallbackBO.getOrderId());
            uocShipOrderQryBo.setShipOrderId(objectId);
            UocShipOrderDo uocShipOrderDo = this.iUocShipOrderModel.getShipOrderById(uocShipOrderQryBo);
            if (uocShipOrderDo == null) {
                throw new BaseBusinessException("100001", "\u67e5\u8be2\u53d1\u8d27\u5355\u4e3a\u7a7a");
            }
            saleOrderId = uocShipOrderDo.getSaleOrderId();
        } else if (UocDicConstant.OBJ_TYPE.INSPECTION.equals(objectType)) {
            UocInspOrderQryBo uocInspOrderQryBo = new UocInspOrderQryBo();
            uocInspOrderQryBo.setOrderId(uocPaymentCallbackBO.getOrderId());
            uocInspOrderQryBo.setInspOrderId(objectId);
            UocInspOrderDo inspOrderMain = this.iUocInspOrderModel.getInspOrderMain(uocInspOrderQryBo);
            if (inspOrderMain == null) {
                throw new BaseBusinessException("100001", "\u67e5\u8be2\u9a8c\u6536\u5355\u4e3a\u7a7a");
            }
            saleOrderId = inspOrderMain.getSaleOrderId();
        } else {
            throw new BaseBusinessException("100001", "\u6682\u4ec5\u652f\u6301\u9500\u552e\u5355\u3001\u53d1\u8d27\u5355\u3001\u9a8c\u6536\u5355\u5355\u636e\u7c7b\u578b");
        }
        return saleOrderId;
    }

    private void val(UocPaymentCallbackReqBO reqBO) {
        if (reqBO == null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u4e3a\u7a7a");
        }
        if (CollectionUtils.isEmpty((Collection)reqBO.getUocPaymentCallbackBOS())) {
            throw new BaseBusinessException("100001", "\u5165\u53c2[\u56de\u8c03\u4fe1\u606f\u96c6\u5408]\u4e3a\u7a7a");
        }
        for (UocPaymentCallbackBO uocPaymentCallbackBO : reqBO.getUocPaymentCallbackBOS()) {
            if (uocPaymentCallbackBO == null) {
                throw new BaseBusinessException("100001", "\u5165\u53c2[\u652f\u4ed8\u662f\u5426\u6210\u529f]\u4e3a\u7a7a");
            }
            if (!uocPaymentCallbackBO.getPayResult().booleanValue()) continue;
            if (uocPaymentCallbackBO.getFscShouldPayId() == null) {
                throw new BaseBusinessException("100001", "\u5165\u53c2[\u7ed3\u7b97\u5e94\u4ed8ID]\u4e3a\u7a7a");
            }
            if (uocPaymentCallbackBO.getOrderId() == null) {
                throw new BaseBusinessException("100001", "\u5165\u53c2[\u8ba2\u5355ID]\u4e3a\u7a7a");
            }
            if (uocPaymentCallbackBO.getShouldPayMoney() != null) continue;
            throw new BaseBusinessException("100001", "\u5165\u53c2[\u5e94\u4ed8\u91d1\u989d]\u4e3a\u7a7a");
        }
    }

    private void syncEs(UocSaleOrderDo uocSaleOrderDo) {
        UocOrderShouldPay uocOrderShouldPay = new UocOrderShouldPay();
        uocOrderShouldPay.setOrderId(uocSaleOrderDo.getOrderId());
        uocOrderShouldPay.setObjectId(uocSaleOrderDo.getSaleOrderId());
        uocOrderShouldPay.setObjectType(UocDicConstant.OBJ_TYPE.SALE);
        uocOrderShouldPay.setIsPayCompleted(UocDicConstant.SHOULD_PAY_ORDER_PAY_STATE.NOT_PAY_COMPLETED);
        List<UocOrderShouldPay> listOrderShouldPay = this.iUocPayOrderModel.getListOrderShouldPay(uocOrderShouldPay);
        JSONArray jsonArray = new JSONArray();
        if (!CollectionUtils.isEmpty(listOrderShouldPay)) {
            for (UocOrderShouldPay item : listOrderShouldPay) {
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("fscShouldPayId", (Object)item.getFscShouldPayId());
                jsonObject.put("shouldPayAmount", (Object)item.getShouldPayAmount());
                jsonObject.put("paidAmount", (Object)item.getPaidAmount());
                jsonObject.put("shouldPayType", (Object)item.getShouldPayType());
                jsonArray.add((Object)jsonObject);
            }
        }
        JSONObject jsonObj = new JSONObject();
        if (!CollectionUtils.isEmpty((Collection)jsonArray)) {
            jsonObj.put("orderShouldPayList", (Object)jsonArray.toString());
        }
        UocEsSyncManagerSaveDataReqBo uocEsSyncManagerSaveDataReqBo = new UocEsSyncManagerSaveDataReqBo();
        uocEsSyncManagerSaveDataReqBo.setObjId(uocSaleOrderDo.getSaleOrderId());
        uocEsSyncManagerSaveDataReqBo.setIndexName(this.uocIndexConfig.getSaleOrderIndex());
        if (uocSaleOrderDo.getUsedFee() != null) {
            jsonObj.put("usedFee", (Object)uocSaleOrderDo.getUsedFee());
        }
        Map<String, Map<String, String>> dic = this.getDic();
        jsonObj.put("payMod", (Object)uocSaleOrderDo.getPayMod());
        Map<String, String> payModMap = dic.get("UOC_SALE_ORDER_PAY_MOD");
        jsonObj.put("payModStr", (Object)payModMap.get(Convert.toStr((Object)uocSaleOrderDo.getPayMod())));
        jsonObj.put("payState", (Object)uocSaleOrderDo.getPayState());
        Map<String, String> payStateMap = dic.get("UOC_SALE_ORDER_PAY_STATE");
        jsonObj.put("payStateStr", (Object)payStateMap.get(Convert.toStr((Object)uocSaleOrderDo.getPayState())));
        uocEsSyncManagerSaveDataReqBo.setJsonObj(jsonObj);
        log.info("paymentCallBack\u540c\u6b65ES\u5165\u53c2\u4e3a\uff1a{}", (Object)JSONObject.toJSONString((Object)uocEsSyncManagerSaveDataReqBo));
        this.uocEsSyncManager.updateData(uocEsSyncManagerSaveDataReqBo);
    }

    private Map<String, Map<String, String>> getDic() {
        ArrayList<String> pCodes = new ArrayList<String>();
        pCodes.add("UOC_SALE_ORDER_PAY_STATE");
        pCodes.add("UOC_SALE_ORDER_PAY_MOD");
        return this.iUocSysDictionaryModel.getDictionaryMap(pCodes);
    }
}

