package com.tydic.dyc.oc.model.chngorder.sub;

import com.tydic.utils.generatedoc.annotation.DocField;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * 标题:UocChngOrderItemObj
 * 说明:变更单明细对
 * 时间:2022-02-23 20:57
 * 作者:罗有
 **/
@Data
public class UocChngOrderItemObj implements Serializable {
	private static final long serialVersionUID = -2733242861628184323L;

	@DocField(value = "id")
	private Long id;

	@DocField(value = "变更单id")
	private Long chngOrderId;

	@DocField(value = "变更单对象id")
	private Long chngOrderObjId;

	@DocField(value = "订单id")
	private Long orderId;

	@DocField(value = "验收明细id")
	private Long inspOrderItemId;

	@DocField(value = "发货明细id")
	private Long shipOrderItemId;

	@DocField(value = "执行明细id")
	private Long implOrderItemId;

	@DocField(value = "销售明细id")
	private Long saleOrderItemId;

	@DocField(value = "订单明细id")
	private Long orderItemId;

	@DocField(value = "变更类型 1:状态变更 2:采购价变更 3:销售价变更 4:加价率变更")
	private Integer chngType;

	@DocField(value = "变更数量")
	private BigDecimal chngNum;

	@DocField(value = "变更金额")
	private BigDecimal chngFee;

	@DocField(value = "采购变更金额")
	private BigDecimal chngPurchaseFee;

	@DocField(value = "变更金额5")
	private BigDecimal chngFeeFive;

	@DocField(value = "变更状态")
	private String chngState;

	@DocField(value = "其他变更")
	private String otherChngValue;

	@DocField(value = "创建时间")
	private Date createTime;

	@DocField(value = "创建时间 开始")
	private Date createTimeStart;

	@DocField(value = "创建时间 结束")
	private Date createTimeEnd;

	@DocField(value = "创建工号")
	private String createOperId;

	@DocField(value = "更新时间")
	private Date updateTime;

	@DocField(value = "更新时间 开始")
	private Date updateTimeStart;

	@DocField(value = "更新时间 结束")
	private Date updateTimeEnd;

	@DocField(value = "更新工号")
	private String updateOperId;

	@DocField(value = "备注")
	private String remark;

	@DocField(value = "删除标志1已删除")
	private Integer delTag;


	/**
	 * 租户id
	 */
	private Long sysTenantId;
	private String sysTenantName;

}
