package com.tydic.dyc.oc.model.implorder.sub;

import com.tydic.utils.generatedoc.annotation.DocField;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * 标题:UocImplOrderItem
 * 说明:执行单明细
 * 时间:2022-02-21 14:29
 * 作者:罗有
 **/
@Data
public class UocImplOrderItem implements Serializable {
	private static final long serialVersionUID =  7221949021183192542L;

	@DocField("id")
	private Long id;

	@DocField(value = "订单id")
	private Long orderId;

	@DocField(value = "销售单id")
	private Long saleOrderId;

	@DocField(value = "执行明细id")
	private Long implOrderItemId;

	@DocField(value = "销售明细id")
	private Long saleOrderItemId;


	@DocField(value = "明细状态")
	private String implItemState;

	@DocField(value = "明细状态翻译")
	private String implItemStateStr;

	@DocField(value = "明细类型             1 商品sku             2 物资             3 项目")
	private Integer itemType;

	@DocField(value = "明细类型翻译")
	private String itemTypeStr;

	@DocField(value = "单品ID")
	private String skuId;

	@DocField(value = "供应商ID")
	private String supplierId;

	@DocField(value = "店铺ID")
	private String supplierShopId;

	@DocField(value = "计量单位")
	private String unitName;

	@DocField(value = "结算计量单位")
	private String settleUnit;

	@DocField(value = "采购金额")
	private BigDecimal purchaseFee;

	@DocField(value = "应付金额")
	private BigDecimal payFee;

	@DocField(value = "运费")
	private BigDecimal transFee;

	@DocField(value = "积分优惠金额")
	private BigDecimal integralDisFee;

	@DocField(value = "活动优惠金额")
	private BigDecimal actDisFee;

	@DocField(value = "其它优惠金额")
	private BigDecimal otherDisFee;

	@DocField(value = "实付金额")
	private BigDecimal usedFee;

	@DocField(value = "实付积分")
	private BigDecimal usedIntegral;

	@DocField(value = "币种")
	private String currencyType;

	@DocField(value = "税金")
	private String taxPrice;

	@DocField(value = "税率")
	private String tax;

	@DocField(value = "税务编码")
	private String taxId;

	@DocField(value = "采购数量")
	private BigDecimal purchaseCount;

	@DocField(value = "发货数量")
	private BigDecimal sendCount;

	@DocField(value = "到货数量")
	private BigDecimal arriveCount;

	@DocField(value = "拒收数量")
	private BigDecimal refuseCount;

	@DocField(value = "退货数量")
	private BigDecimal returnCount;

	@DocField(value = "验收数量")
	private BigDecimal acceptanceCount;

	@DocField(value = "异常变更在途数量，表示异常供应商确认之前的记录数量")
	private BigDecimal chngingCount;

	@DocField(value = "售后在途数量")
	private BigDecimal afterServingCount;

	@DocField(value = "超验百分比，下单时保存（协议、无协议）")
	private Integer inspectionExcessPercent;

	@DocField(value = "采购金额")
	private BigDecimal purchasePrice;

	@DocField(value = "销售金额")
	private BigDecimal salePrice;

	@DocField(value = "创建时间")
	private Date createTime;

	@DocField(value = "创建工号")
	private String createOperId;

	@DocField(value = "更新时间")
	private Date updateTime;

	@DocField(value = "更新工号")
	private String updateOperId;

	@DocField(value = "备注")
	private String remark;

	@DocField(value = "删除标志1已删除")
	private Integer delTag;

	@DocField(value = "纵向扩展")
	private List<UocImplItemMap> uocImplItemMapList;


	/**
	 * 租户id
	 */
	private Long sysTenantId;
	private String sysTenantName;
	

}
