package com.tydic.dyc.oc.service.order;

import com.ohaotian.plugin.common.util.DateUtils;
import com.tydic.dyc.base.bo.BasePageRspBo;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.base.utils.JUtil;
import com.tydic.dyc.oc.constants.UocConstant;
import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.constants.UocRspConstants;
import com.tydic.dyc.oc.model.order.IUocOrderModel;
import com.tydic.dyc.oc.model.order.qrybo.ConfSupplierQryBo;
import com.tydic.dyc.oc.model.order.sub.UocConfSupplier;
import com.tydic.dyc.oc.model.sysdictionary.IUocSysDictionaryModel;
import com.tydic.dyc.oc.model.sysdictionary.UocSysDictionaryDo;
import com.tydic.dyc.oc.model.sysdictionary.qrybo.UocSysDictionaryQryBo;
import com.tydic.dyc.oc.service.order.bo.UocProOrderQuotaAllocationInfoBo;
import com.tydic.dyc.oc.service.order.bo.UocProOrderQuotaAllocationPageQueryReqBo;
import com.tydic.dyc.oc.service.order.bo.UocProOrderQuotaAllocationPageQueryRspBo;
import com.tydic.dyc.oc.utils.UocMoneyUtil;
import com.tydic.dyc.oc.utils.UocRu;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 标题：类名称:UocProOrderQuotaAllocationPageQueryAbilityServiceImpl
 * 说明：描述一下类的作用TODO
 * 时间：2022/4/8 16:36
 * 作者 @author 尹栋梁
 */
@HTServiceImpl
public class UocProOrderQuotaAllocationPageQueryAbilityServiceImpl implements UocProOrderQuotaAllocationPageQueryAbilityService{
    @Autowired
    private IUocOrderModel iUocOrderModel;

    @Autowired
    private IUocSysDictionaryModel uocSysDictionaryModel;


    @Override
    public UocProOrderQuotaAllocationPageQueryRspBo queryOrderQuotaAllocationPage(UocProOrderQuotaAllocationPageQueryReqBo reqBo) {
        UocProOrderQuotaAllocationPageQueryRspBo rspBo = UocRu.success(UocProOrderQuotaAllocationPageQueryRspBo.class);
        rspBo.setPageNo(reqBo.getPageNo());

        UocConfSupplier supplierPOWhere = new UocConfSupplier();
        supplierPOWhere.setBusinessTypeCode(reqBo.getBusinessTypeCode());
        supplierPOWhere.setSupNo(reqBo.getSupNo());
        try {
            supplierPOWhere.setOrderQuotaStart(UocMoneyUtil.bigDecimal2Long(reqBo.getOrderQuotaStart()));
            supplierPOWhere.setOrderQuotaEnd(UocMoneyUtil.bigDecimal2Long(reqBo.getOrderQuotaEnd()));
        } catch (Exception e) {
            e.printStackTrace();
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象转换金额有误");
        }
        supplierPOWhere.setOperatingTimeStart(DateUtils.strToDateLong(reqBo.getOperatingTimeStart()));
        supplierPOWhere.setOperatingTimeEnd(DateUtils.strToDateLong(reqBo.getOperatingTimeEnd()));
        supplierPOWhere.setOperatorName(reqBo.getOperatorName());
        supplierPOWhere.setOrderBy("sup_no");
        supplierPOWhere.setLimitStatus(0);
        ConfSupplierQryBo confSupplierQryBo = JUtil.js(supplierPOWhere, ConfSupplierQryBo.class);
        confSupplierQryBo.setPageNo(reqBo.getPageNo());
        confSupplierQryBo.setPageSize(reqBo.getPageSize());
        BasePageRspBo<ConfSupplierQryBo> uocOrderModelListPage = iUocOrderModel.getListPage(confSupplierQryBo);
        if (CollectionUtils.isEmpty(uocOrderModelListPage.getRows())) {
            rspBo.setTotal(0);
            rspBo.setRecordsTotal(0);
            rspBo.setRows(new ArrayList<>(0));
        } else {
            rspBo.setTotal(uocOrderModelListPage.getTotal());
            rspBo.setRecordsTotal(uocOrderModelListPage.getRecordsTotal());
            List<UocProOrderQuotaAllocationInfoBo> rows = new ArrayList<>(uocOrderModelListPage.getRows().size());
            UocProOrderQuotaAllocationInfoBo orderQuotaAllocationInfoBo;
            UocSysDictionaryQryBo uocSysDictionaryQryBo = new UocSysDictionaryQryBo();
            uocSysDictionaryQryBo.setPCode(UocDicConstant.ORDER_SOURCE.P_CODE);
            List<UocSysDictionaryDo> uocSysDictionaryDos = uocSysDictionaryModel.qryDicList(uocSysDictionaryQryBo);
            Map<String, String> businessTypeMap = uocSysDictionaryDos.stream().collect(Collectors.toMap(UocSysDictionaryDo::getCode, UocSysDictionaryDo::getDescrip));
            for (ConfSupplierQryBo supplierPO : uocOrderModelListPage.getRows()) {
                orderQuotaAllocationInfoBo = new UocProOrderQuotaAllocationInfoBo();
                orderQuotaAllocationInfoBo.setSupNo(supplierPO.getSupNo());
                orderQuotaAllocationInfoBo.setSupName(supplierPO.getSupName());
                try {
                    orderQuotaAllocationInfoBo.setOrderQuota(UocMoneyUtil.long2BigDecimal(supplierPO.getOrderLimit()));
                } catch (Exception e) {
                    e.printStackTrace();
                    throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "转换金额有误");

                }
                orderQuotaAllocationInfoBo.setBusinessTypeCode(supplierPO.getBusinessTypeCode());

                if (null != businessTypeMap) {
                    orderQuotaAllocationInfoBo.setBusinessTypeName(businessTypeMap.get(supplierPO.getBusinessTypeCode()));
                }
                orderQuotaAllocationInfoBo.setOperatingTime(supplierPO.getOperatingTime());
                orderQuotaAllocationInfoBo.setOperatorId(supplierPO.getOperatorId());
                orderQuotaAllocationInfoBo.setOperatorName(supplierPO.getOperatorName());
                orderQuotaAllocationInfoBo.setConfId(supplierPO.getConfId());
                orderQuotaAllocationInfoBo.setSysAttr(supplierPO.getSysAttr());
                // 翻译属性
                if (UocConstant.SYS_ATTR.SYSTEM.equals(supplierPO.getSysAttr())){
                    orderQuotaAllocationInfoBo.setSysAttrStr("系统");
                }
                if (UocConstant.SYS_ATTR.CUSTOMIZE.equals(supplierPO.getSysAttr())){
                    orderQuotaAllocationInfoBo.setSysAttrStr("自定义");
                }
                rows.add(orderQuotaAllocationInfoBo);
            }
            rspBo.setRows(rows);
        }
        return rspBo;
    }

}
