package com.tydic.dyc.oc.service.order;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.model.aforder.IUocAfOrderModel;
import com.tydic.dyc.oc.model.aforder.qrybo.UocAfOrderQryBo;
import com.tydic.dyc.oc.model.aforder.sub.UocAfOrder;
import com.tydic.dyc.oc.model.order.IUocOrderModel;
import com.tydic.dyc.oc.model.order.qrybo.UocDMsgPoolQryBo;
import com.tydic.dyc.oc.model.order.qrybo.UocOrderQueryIndexQryBo;
import com.tydic.dyc.oc.model.order.qrybo.UocOrderStakeholderQryBo;
import com.tydic.dyc.oc.model.order.sub.UocOrderQueryIndex;
import com.tydic.dyc.oc.service.order.bo.UocQryOutOrderIndexBo;
import com.tydic.dyc.oc.service.order.bo.UocQryOutOrderIndexServiceReqBo;
import com.tydic.dyc.oc.service.order.bo.UocQryOutOrderIndexServiceRspBo;
import com.tydic.dyc.oc.utils.UocRu;
import lombok.extern.ohaotian.HTServiceImpl;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

/*
 * @Author lsl
 * @Description //TODO 查询外部与内部订单关联信息接口实现
 * @Date 17:10 2022/4/8
 * @Param
 * @return
 */
@Slf4j
@HTServiceImpl
public class UocQryOutOrderIndexServiceImpl implements UocQryOutOrderIndexService {
    
    @Autowired
    private IUocOrderModel iUocOrderModel;

    @Autowired
    private IUocAfOrderModel uocAfOrderModel;
    
    @Override
    public UocQryOutOrderIndexServiceRspBo qryOutOrderIndex(UocQryOutOrderIndexServiceReqBo reqBo) {
        UocQryOutOrderIndexServiceRspBo rspBo = new UocQryOutOrderIndexServiceRspBo();
        List<UocQryOutOrderIndexBo> uocQryOutOrderIndexBoList = new ArrayList<>();
        UocOrderQueryIndexQryBo uocOrderQueryIndexQryBo = new UocOrderQueryIndexQryBo();

        if(ObjectUtil.isNotEmpty(reqBo.getType()) && (5L == reqBo.getType())){
            UocDMsgPoolQryBo msgPoolQryBo = new UocDMsgPoolQryBo();
            msgPoolQryBo.setPackageId(reqBo.getOutOrderNo());
//            msgPoolQryBo = iUocOrderModel.getModelByMsgId(msgPoolQryBo);
            //防止电商重复发货，改查list
            List<UocDMsgPoolQryBo> msgPoolQryBoList =  iUocOrderModel.getMsgList(msgPoolQryBo);
            
            if(ObjectUtil.isNotEmpty(msgPoolQryBoList)){
                msgPoolQryBo = msgPoolQryBoList.get(0);
                uocOrderQueryIndexQryBo.setOutObjId(msgPoolQryBo.getOutOrderId());
                uocOrderQueryIndexQryBo.setOrderId(msgPoolQryBo.getOrderId());
//                uocOrderQueryIndexQryBo.setObjType(UocDicConstant.OBJ_TYPE.SHIP);
                List<UocOrderQueryIndex> uocOrderQueryIndexList = iUocOrderModel.qryOrderQueryIndexList(uocOrderQueryIndexQryBo);
                if (ObjectUtil.isNotEmpty(uocOrderQueryIndexList)) {
                    for (UocOrderQueryIndex item : uocOrderQueryIndexList) {
                        uocQryOutOrderIndexBoList.add(UocRu.js(item, UocQryOutOrderIndexBo.class));
                    }
                }
            }
        }
//        else if(ObjectUtil.isNotEmpty(reqBo.getType()) && (102L == reqBo.getType())){
//
//
//            UocAfOrderQryBo uocAfOrderQryBo = new UocAfOrderQryBo();
//            uocAfOrderQryBo.setExtAfId(reqBo.getOutOrderNo());
//            List<UocAfOrder> afOrderList = uocAfOrderModel.getAfOrderList(uocAfOrderQryBo);
//            if (CollectionUtil.isNotEmpty(afOrderList)) {
//                UocAfOrder uocAfOrder = afOrderList.get(0);
//                Long saleOrderId = uocAfOrder.getSaleOrderId();
//                uocOrderQueryIndexQryBo.setOrderId(uocAfOrder.getOrderId());
//                uocOrderQueryIndexQryBo.setObjId(saleOrderId);
//                uocOrderQueryIndexQryBo.setObjType(2);
//                List<UocOrderQueryIndex> uocOrderQueryIndexList = iUocOrderModel.qryOrderQueryIndexList(uocOrderQueryIndexQryBo);
//                if (ObjectUtil.isNotEmpty(uocOrderQueryIndexList)) {
//                    for (UocOrderQueryIndex item : uocOrderQueryIndexList) {
//                        uocQryOutOrderIndexBoList.add(UocRu.js(item, UocQryOutOrderIndexBo.class));
//                    }
//                }
//                Optional.ofNullable(uocAfOrder.getOrderId()).ifPresent(x->{
//                    UocOrderStakeholderQryBo qryBo = new UocOrderStakeholderQryBo();
//                    qryBo.setOrderId(x);
//                    List<UocOrderStakeholderQryBo> qryBoList = iUocOrderModel.qryStakeholderList(qryBo);
//                    if(ObjectUtil.isNotEmpty(qryBoList)){
//                        rspBo.setSupplierNo(qryBoList.get(0).getSupId());
//                    }
//                });
//            }
//        }
        else{
            uocOrderQueryIndexQryBo.setOutObjId(reqBo.getOutOrderNo());//外部订单号
            uocOrderQueryIndexQryBo.setOrderId(reqBo.getOrderId());
            List<UocOrderQueryIndex> uocOrderQueryIndexList = iUocOrderModel.qryOrderQueryIndexList(uocOrderQueryIndexQryBo);
            if (ObjectUtil.isNotEmpty(uocOrderQueryIndexList)) {
                for (UocOrderQueryIndex item : uocOrderQueryIndexList) {
                    uocQryOutOrderIndexBoList.add(UocRu.js(item, UocQryOutOrderIndexBo.class));
                }
            }
            Optional.ofNullable(reqBo.getOrderId()).ifPresent(x->{
                UocOrderStakeholderQryBo qryBo = new UocOrderStakeholderQryBo();
                qryBo.setOrderId(x);
                List<UocOrderStakeholderQryBo> qryBoList = iUocOrderModel.qryStakeholderList(qryBo);
                if(ObjectUtil.isNotEmpty(qryBoList)){
                    rspBo.setSupplierNo(qryBoList.get(0).getSupId());
                }
            });
        }

        rspBo.setQryOutOrderIndexBoList(uocQryOutOrderIndexBoList);
        return rspBo;
    }
}
