package com.tydic.dyc.oc.service.order;

import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.constants.UocConstant;
import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.constants.UocRspConstants;
import com.tydic.dyc.oc.constants.UocStateConstants;
import com.tydic.dyc.oc.model.order.IUocOrderModel;
import com.tydic.dyc.oc.model.order.UocOrderDo;
import com.tydic.dyc.oc.model.order.qrybo.UocOrderProcInstQryBo;
import com.tydic.dyc.oc.model.order.qrybo.UocOrderQueryIndexQryBo;
import com.tydic.dyc.oc.model.order.sub.UocOrderCancelAdvanceOrderTask;
import com.tydic.dyc.oc.model.order.sub.UocOrderProcInst;
import com.tydic.dyc.oc.model.order.sub.UocOrderQueryIndex;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo;
import com.tydic.dyc.oc.service.order.bo.UocCancelOrderBo;
import com.tydic.dyc.oc.service.order.bo.UocLastEsPreOrderDealReqBo;
import com.tydic.dyc.oc.service.order.bo.UocLastEsPreOrderDealRspBo;
import com.tydic.dyc.oc.utils.IdUtil;
import com.tydic.dyc.oc.utils.UocRu;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * @description 预订单尾单完结处理API实现类
 * @author Luokan
 * @date 2022-07-05 11:18 AM
 **/
@HTServiceImpl
public class UocLastEsPreOrderDealServiceImpl implements UocLastEsPreOrderDealService {

    /**
     * 订单领域方法服务
     */
    @Autowired
    private IUocOrderModel iUocOrderModel;
    /**
     * 销售单领域方法服务
     */
    @Autowired
    private IUocSaleOrderModel iUocSaleOrderModel;

    /**
     * 预订单尾单完结处理
     * @param reqBo
     * @return
     */
    @Override
    public UocLastEsPreOrderDealRspBo dealLastEsPreOrder(UocLastEsPreOrderDealReqBo reqBo) {
        //定义出参
        UocLastEsPreOrderDealRspBo rsp = UocRu.success(UocLastEsPreOrderDealRspBo.class);
        //查询整单详情
        UocOrderDo selectDo = new UocOrderDo();
        selectDo.setOrderId(reqBo.getOrderId());
        UocOrderDo resultDo = iUocOrderModel.qryOrderBy(selectDo);
        if (null == resultDo) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_SYSTEM_EXCEPTION, "该订单不存在！");
        }
        //如果整单状态是取消，则更新所有成功的销售单状态为取消
        if (UocStateConstants.Order.ZD_SP_QX.equals(resultDo.getOrderState())) {
            //查询出所有已成功的电商的销售单。
            UocSaleOrderDo uocSaleOrderDo = new UocSaleOrderDo();
            uocSaleOrderDo.setOrderId(reqBo.getOrderId());
            List<UocSaleOrderDo> saleOrderList = iUocSaleOrderModel.qrySaleOrderList(uocSaleOrderDo);
            //过滤出需要手动取消的订单
            List<UocSaleOrderDo> cancelSaleOrderList = new ArrayList<>();
            cancelSaleOrderList.addAll(saleOrderList.stream().filter(bo -> bo.getOrderSource().equals(UocConstant.SkuSource.ELC) && bo.getCreatedResult().equals(UocConstant.CREATED_RESULT.SUCCESS)).collect(Collectors.toList()));
            //存入电商取消定时任务表
            if (!CollectionUtils.isEmpty(cancelSaleOrderList)) {
                //查询外部订单号
                UocOrderQueryIndexQryBo uocOrderQueryIndexQryBo = new UocOrderQueryIndexQryBo();
                uocOrderQueryIndexQryBo.setOrderId(reqBo.getOrderId());
                uocOrderQueryIndexQryBo.setObjType(UocDicConstant.OBJ_TYPE.SALE);
                List<UocOrderQueryIndex> uocOrderQueryIndexs = iUocOrderModel.qryOrderQueryIndexList(uocOrderQueryIndexQryBo);
                if (CollectionUtils.isEmpty(uocOrderQueryIndexs)) {
                    throw new BaseBusinessException(UocRspConstants.RSP_CODE_SYSTEM_EXCEPTION, "查询订单关联外部单号为空！");
                }
                Map<Long, String> saleOrderOutOrderMap = uocOrderQueryIndexs.stream().collect(Collectors.toMap(UocOrderQueryIndex::getObjId, UocOrderQueryIndex::getOutObjId));
                List<UocOrderCancelAdvanceOrderTask> advanceOrderTaskList = new ArrayList<>();
                for (UocSaleOrderDo bo : cancelSaleOrderList) {
                    UocOrderCancelAdvanceOrderTask uocOrderCancelAdvanceOrderTask = new UocOrderCancelAdvanceOrderTask();
                    uocOrderCancelAdvanceOrderTask.setId(IdUtil.nextId());
                    uocOrderCancelAdvanceOrderTask.setOrderId(bo.getOrderId());
                    uocOrderCancelAdvanceOrderTask.setSaleOrderId(bo.getSaleOrderId());
                    uocOrderCancelAdvanceOrderTask.setSaleOrderNo(bo.getSaleOrderNo());
                    uocOrderCancelAdvanceOrderTask.setCreateTime(new Date());
                    if (null != saleOrderOutOrderMap.get(bo.getSaleOrderId())) {
                        uocOrderCancelAdvanceOrderTask.setOutObjId(saleOrderOutOrderMap.get(bo.getSaleOrderId()));
                    }
                    advanceOrderTaskList.add(uocOrderCancelAdvanceOrderTask);
                }
                iUocOrderModel.batchCreateCancelAdvanceOrderTask(advanceOrderTaskList);
            }
            cancelSaleOrderList.addAll(saleOrderList.stream().filter(bo -> bo.getOrderSource().equals(UocConstant.SkuSource.AGR)).collect(Collectors.toList()));
            if (!CollectionUtils.isEmpty(cancelSaleOrderList)) {
                List<UocCancelOrderBo> uocCancelOrderBos = UocRu.jsl(saleOrderList, UocCancelOrderBo.class);
                UocOrderProcInstQryBo uocOrderProcInstQryBo = new UocOrderProcInstQryBo();
                uocOrderProcInstQryBo.setObjIdList(uocCancelOrderBos.stream().map(UocCancelOrderBo::getSaleOrderId).collect(Collectors.toList()));
                uocOrderProcInstQryBo.setObjType(UocDicConstant.OBJ_TYPE.SALE);
                List<UocOrderProcInst> uocOrderProcInsts = iUocOrderModel.qryOrderProcInstList(uocOrderProcInstQryBo);
                if(!CollectionUtils.isEmpty(uocOrderProcInsts)){
                    Map<Long, UocOrderProcInst> uocOrderProcInstMap = uocOrderProcInsts.stream().collect(Collectors.toMap(UocOrderProcInst::getObjId, o -> o));
                    for (UocCancelOrderBo uocCancelOrderBo : uocCancelOrderBos) {
                        UocOrderProcInst uocOrderProcInst = uocOrderProcInstMap.get(uocCancelOrderBo.getSaleOrderId());
                        if(null != uocOrderProcInst) {
                            uocCancelOrderBo.setProcInstId(uocOrderProcInst.getProcInstId());
                        }
                    }
                }
                rsp.setUocCancelOrderBoList(uocCancelOrderBos);
            }
            rsp.setIsStartProcess(false);
        }else {
        //否则返回需要启动子流程标识
            rsp.setOrderNo(resultDo.getOrderNo());
            rsp.setIsStartProcess(true);
        }
        return rsp;
    }
}
