package com.tydic.dyc.oc.service.order;

import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.oc.model.order.IUocOrderModel;
import com.tydic.dyc.oc.model.order.sub.UocOrderCancelAdvanceOrderTask;
import com.tydic.dyc.oc.service.order.bo.UocOrderCancelAdvanceOrderTaskUpdateReqBO;
import com.tydic.dyc.oc.service.order.bo.UocOrderCancelAdvanceOrderTaskUpdateRspBO;
import com.tydic.dyc.oc.utils.UocRu;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;

@HTServiceImpl
public class UocOrderCancelAdvanceOrderTaskUpdateServiceImpl implements UocOrderCancelAdvanceOrderTaskUpdateService {

    @Autowired
    private IUocOrderModel iUocOrderModel;

    @Override
    public UocOrderCancelAdvanceOrderTaskUpdateRspBO updateCancelAdvanceOrderTask(UocOrderCancelAdvanceOrderTaskUpdateReqBO reqBO) {
        UocOrderCancelAdvanceOrderTaskUpdateRspBO rspBO = UocRu.success(UocOrderCancelAdvanceOrderTaskUpdateRspBO.class);
        if (ObjectUtil.isNotEmpty(reqBO.getCancelAdvanceOrderTaskUpdateBOList())) {
            reqBO.getCancelAdvanceOrderTaskUpdateBOList().forEach(each -> {
                iUocOrderModel.updateCancelAdvanceOrderTask(UocRu.js(each, UocOrderCancelAdvanceOrderTask.class));
            });
        }
        return rspBO;
    }
}
