package com.tydic.dyc.oc.service.order;

import com.tydic.dyc.oc.model.order.IUocOrderModel;
import com.tydic.dyc.oc.model.order.sub.UocOrderCancelAdvanceOrderTask;
import com.tydic.dyc.oc.service.order.bo.*;
import com.tydic.dyc.oc.utils.UocRu;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.Arrays;
import java.util.List;

@HTServiceImpl
public class UocOrderCancelAdvanceOrderTaskQryServiceImpl implements UocOrderCancelAdvanceOrderTaskQryService {

    @Autowired
    private IUocOrderModel iUocOrderModel;

    @Override
    public UocOrderCancelAdvanceOrderTaskQryRspBO qryCancelAdvanceOrderTask(UocOrderCancelAdvanceOrderTaskQryReqBO reqBO) {
        UocOrderCancelAdvanceOrderTaskQryRspBO rspBO = UocRu.success(UocOrderCancelAdvanceOrderTaskQryRspBO.class);
        UocOrderCancelAdvanceOrderTask advanceOrderTask = UocRu.js(reqBO, UocOrderCancelAdvanceOrderTask.class);
        advanceOrderTask.setStatusList(Arrays.asList(1, 3));
        List<UocOrderCancelAdvanceOrderTask> cancelAdvanceOrderTaskList = iUocOrderModel.getCancelAdvanceOrderTaskList(advanceOrderTask);
        rspBO.setCancelAdvanceOrderTaskBOList(UocRu.jsl(cancelAdvanceOrderTaskList, UocCancelAdvanceOrderTaskBO.class));
        return rspBO;
    }
}
