/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.oc.service.domainservice;

import cn.hutool.core.convert.Convert;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.model.order.IUocOrderModel;
import com.tydic.dyc.oc.model.order.qrybo.UocOrderTaskInstQryBo;
import com.tydic.dyc.oc.model.order.qrybo.UocTacheButtonQryBo;
import com.tydic.dyc.oc.model.order.sub.UocOrderTaskInst;
import com.tydic.dyc.oc.model.order.sub.UocTacheButton;
import com.tydic.dyc.oc.service.domainservice.UocTacheButtonQryService;
import com.tydic.dyc.oc.service.domainservice.bo.UocTacheButtonInfoBO;
import com.tydic.dyc.oc.service.domainservice.bo.UocTacheButtonQryReqBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocTacheButtonQryRspBo;
import com.tydic.dyc.oc.utils.UocRu;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"OC_GROUP_DEV/2.0.0/com.tydic.dyc.oc.service.domainservice.UocTacheButtonQryService"})
public class UocTacheButtonQryServiceImpl
implements UocTacheButtonQryService {
    @Autowired
    private IUocOrderModel iUocOrderModel;
    public static final String DEFAULT = "DEFAULT";
    @Value(value="${button.url.prefix:http://39.96.39.0/lowCode/}")
    private String BUTTON_URL_PREFIX;
    @Value(value="${button.url.prefix.real:http://39.96.39.0/lowCodeRelease/#/}")
    private String BUTTON_URL_PREFIX_REAL;

    @PostMapping(value={"qryTacheButton"})
    public UocTacheButtonQryRspBo qryTacheButton(@RequestBody UocTacheButtonQryReqBo reqBo) {
        this.validateArg(reqBo);
        UocTacheButtonQryRspBo rspBo = UocRu.success(UocTacheButtonQryRspBo.class);
        UocTacheButtonQryBo uocTacheButtonQryBo = new UocTacheButtonQryBo();
        uocTacheButtonQryBo.setTabId(Convert.toInt((Object)reqBo.getTabId()));
        uocTacheButtonQryBo.setTacheCodes(reqBo.getTacheCodes());
        uocTacheButtonQryBo.getTacheCodes().add(DEFAULT);
        uocTacheButtonQryBo.setSubOrderStatusCodes(reqBo.getSubOrderStatusCodes());
        uocTacheButtonQryBo.setOrderStatusList(reqBo.getOrderStatusList());
        uocTacheButtonQryBo.setOrderBy("id");
        List<UocTacheButton> uocTacheButtons = this.iUocOrderModel.qryTacheButton(uocTacheButtonQryBo);
        List<UocTacheButtonInfoBO> uocTacheButtonInfoBOS = UocRu.jsl(uocTacheButtons, UocTacheButtonInfoBO.class);
        List<String> formTacheCodeList = uocTacheButtonInfoBOS.stream().map(UocTacheButtonInfoBO::getFormTacheCode).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(formTacheCodeList)) {
            UocOrderTaskInstQryBo uocOrderTaskInstQryBo = new UocOrderTaskInstQryBo();
            uocOrderTaskInstQryBo.setOrderIdList(reqBo.getOrderIdList());
            uocOrderTaskInstQryBo.setObjIdList(reqBo.getObjIdList());
            uocOrderTaskInstQryBo.setObjType(reqBo.getObjType());
            uocOrderTaskInstQryBo.setProcStateList(formTacheCodeList);
            uocOrderTaskInstQryBo.setFinishTag(UocDicConstant.PROC_TASK_FINISHED.NO_FINISHED);
            uocOrderTaskInstQryBo.setOrderBy("create_time desc");
            List<UocOrderTaskInst> uocOrderTaskInsts = this.iUocOrderModel.qryOrderTaskInstList(uocOrderTaskInstQryBo);
            if (!CollectionUtils.isEmpty(uocOrderTaskInsts)) {
                ConcurrentMap<String, List<UocOrderTaskInst>> tacheCodeMap = uocOrderTaskInsts.stream().collect(Collectors.groupingByConcurrent(UocOrderTaskInst::getProcState));
                uocTacheButtonInfoBOS.forEach(uocTacheButtonInfoBO -> {
                    List formTaskList;
                    if (StringUtils.isNotBlank((CharSequence)uocTacheButtonInfoBO.getFormTacheCode()) && !CollectionUtils.isEmpty((Collection)(formTaskList = (List)tacheCodeMap.get(uocTacheButtonInfoBO.getFormTacheCode()))) && StringUtils.isNotBlank((CharSequence)((UocOrderTaskInst)formTaskList.get(0)).getFormUrl())) {
                        String url = "";
                        if (reqBo.getReflected() != null && reqBo.getReflected().booleanValue()) {
                            url = this.BUTTON_URL_PREFIX + ((UocOrderTaskInst)formTaskList.get(0)).getFormUrl();
                        } else {
                            String fromUrl = ((UocOrderTaskInst)formTaskList.get(0)).getFormUrl();
                            if (fromUrl.contains(".html")) {
                                fromUrl = fromUrl.substring(0, fromUrl.length() - 5);
                            }
                            url = this.BUTTON_URL_PREFIX_REAL + fromUrl;
                        }
                        if (StringUtils.isNotBlank((CharSequence)uocTacheButtonInfoBO.getFormParam())) {
                            uocTacheButtonInfoBO.setUri(url + "?" + uocTacheButtonInfoBO.getFormParam());
                        } else {
                            uocTacheButtonInfoBO.setUri(url);
                        }
                    }
                });
            }
        }
        rspBo.setUocTacheButtonS(uocTacheButtonInfoBOS);
        return rspBo;
    }

    private void validateArg(UocTacheButtonQryReqBo reqBo) {
        if (StringUtils.isBlank((CharSequence)reqBo.getTabId())) {
            throw new BaseBusinessException("100001", "\u5165\u53c2tabId\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

