package com.tydic.dyc.oc.model.implorder;

import com.tydic.dyc.oc.model.implorder.sub.UocImplOrderItem;
import com.tydic.dyc.oc.model.implorder.sub.UocImplOrderMap;
import com.tydic.utils.generatedoc.annotation.DocField;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * 标题:UocImplOrder
 * 说明:执行单
 * 时间:2022-02-21 14:29
 * 作者:罗有
 **/
@Data
public class UocImplOrderDo implements Serializable {
	private static final long serialVersionUID =  2843195778662013062L;


	@DocField(value = "销售单id")
	private Long saleOrderId;

	@DocField(value = "订单id")
	private Long orderId;

	@DocField(value = "执行单编码")
	private String implOrderNo;

	@DocField(value = "外部执行单编码")
	private String implOrderNoExt;

	@DocField(value = "执行单名称")
	private String implOrderName;

	@DocField(value = "执行单类型")
	private Integer implOrderType;

	@DocField(value = "执行单类型翻译")
	private String implOrderTypeStr;

	@DocField(value = "执行单状态")
	private String implOrderState;

	@DocField(value = "执行单状态翻译")
	private String implOrderStateStr;

	@DocField(value = "执行单说明")
	private String implOrderDesc;

	@DocField(value = "开票标识 0未开票 1已开票")
	private Integer invoiceTag;

	@DocField(value = "开票标识翻译")
	private String invoiceTagStr;

	@DocField(value = "销售金额")
	private BigDecimal totalSaleFee;

	@DocField(value = "采购金额")
	private BigDecimal totalPurchaseFee;

	@DocField(value = "优惠金额")
	private BigDecimal totalActShareFee;

	@DocField(value = "运费")
	private BigDecimal totalTransFee;

	@DocField(value = "实付金额")
	private BigDecimal usedFee;

	@DocField(value = "实付积分")
	private BigDecimal usedIntegral;

	@DocField(value = "协议编号")
	private String agreementNo;

	@DocField(value = "合同编号")
	private String contractNo;

	@DocField(value = "流转状态")
	private String procState;

	@DocField(value = "流转状态翻译")
	private String procStateStr;

	@DocField(value = "对账状态")
	private String checkState;

	@DocField(value = "对账状态翻译")
	private String checkStateStr;

	@DocField(value = "税率")
	private String taxRate;

	@DocField(value = "竣工标志 1 竣工 0 在途")
	private Integer finishFlag;

	@DocField(value = "竣工标志翻译")
	private String finishFlagStr;

	@DocField(value = "租户ID")
	private String tenantId;

	@DocField(value = "创建时间")
	private Date createTime;

	@DocField(value = "创建工号")
	private String createOperId;

	@DocField(value = "更新时间")
	private Date updateTime;

	@DocField(value = "更新工号")
	private String updateOperId;

	@DocField(value = "撤单时间")
	private Date cancelTime;

	@DocField(value = "撤单工号")
	private String cancelOperId;

	@DocField(value = "撤单原因")
	private String cancelReason;

	@DocField(value = "撤单标志:1 已撤单 0 未撤单")
	private Integer cancelFlag;

	@DocField(value = "撤单标志翻译")
	private String cancelFlagStr;

	@DocField(value = "备注")
	private String remark;

	@DocField(value = "竣工时间")
	private Date finishTime;

	@DocField(value = "逾期时间")
	private Date expTime;

	@DocField(value = "结算模式 2:撮合 1:贸易")
	private Integer modelSettle;

	@DocField(value = "结算模式翻译")
	private String modelSettleStr;

	@DocField(value = "采购类别 1 物资 2 施工 3 服务")
	private Integer purchaseType;

	@DocField(value = "采购类别翻译")
	private String purchaseTypeStr;

	@DocField(value = "执行单明细")
	private List<UocImplOrderItem> uocImplOrderItemList;

	@DocField(value = "执行单纵向扩展")
	private List<UocImplOrderMap> uocImplOrderMapList;

	@DocField(value = "执行单明细IDList")
	private List<Long> implOrderItemIdList;

	@DocField(value = "订单IDList")
	private List<Long> orderIdList;

}
