package com.tydic.dyc.oc.service.domainservice;

import cn.hutool.core.util.ObjectUtil;
import com.ohaotian.plugin.common.util.DateUtils;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.constants.UocRspConstants;
import com.tydic.dyc.oc.model.order.IUocOrderModel;
import com.tydic.dyc.oc.model.order.UocOrderDo;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderItemQryBo;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleOrderItem;
import com.tydic.dyc.oc.model.shiporder.IUocShipOrderModel;
import com.tydic.dyc.oc.model.shiporder.qrybo.UocShipOrderItemQryBo;
import com.tydic.dyc.oc.model.shiporder.sub.UocShipOrderItem;
import com.tydic.dyc.oc.model.sysdictionary.IUocSysDictionaryModel;
import com.tydic.dyc.oc.service.domainservice.bo.*;
import com.tydic.dyc.oc.utils.UocRu;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.*;
import java.util.stream.Collectors;


/**
 * 标题:UocQryOrderOverallProgressServiceImpl
 * 说明:
 * 时间:2022/2/27 14:59
 * 作者:tkl
 */
@HTServiceImpl
public class UocQryOrderOverallProgressServiceImpl implements UocQryOrderOverallProgressService {

    @Autowired
    private IUocSaleOrderModel iUocSaleOrderModel;

    @Autowired
    private IUocOrderModel iUocOrderModel;

    @Autowired
    private IUocShipOrderModel iUocShipOrderModel;

    @Autowired
    private IUocSysDictionaryModel iUocSysDictionaryModel;

    @Override
    public UocQryOrderOverallProgressRspBo qryOrderOverallProjress(UocQryOrderOverallProgressReqBo reqBo) {
        validateArg(reqBo);
        UocQryOrderOverallProgressRspBo rspBo = UocRu.success(UocQryOrderOverallProgressRspBo.class);
        //查询订单主体
        UocOrderDo uocOrderDo = getUocOrderDo(reqBo);
        if (ObjectUtil.isNull(uocOrderDo)) {
            return rspBo;
        }
        //查询销售单明细
        List<UocSaleOrderItem> saleOrderItemList = getSaleOrderItemList(reqBo);
        //查询销售单主体
        UocSaleOrderDo uocSaleOrderDo = getUocSaleOrderDo(reqBo);
        if (ObjectUtil.isNull(uocSaleOrderDo)) {
            return rspBo;
        }
        //封装订单主体信息
        buildOrderMain(rspBo, uocOrderDo);
        //封装销售单明细信息
        buildSaleOrderItem(rspBo, saleOrderItemList);
        //封装销售单和三方信息
        buildStakeHolder(rspBo, uocSaleOrderDo);

        return rspBo;
    }

    /**
     * 封装三方信息
     *
     * @param rspBo
     * @param uocSaleOrderDo
     */
    private void buildStakeHolder(UocQryOrderOverallProgressRspBo rspBo, UocSaleOrderDo uocSaleOrderDo) {
        if (ObjectUtil.isNotNull(uocSaleOrderDo)) {
            rspBo.setSaleOrderNo(uocSaleOrderDo.getSaleOrderNo());
            rspBo.setSaleOrderState(uocSaleOrderDo.getSaleOrderState());
            rspBo.setSaleOrderStateStr(getDic().get(UocDicConstant.SALE_ORD_STATE.P_CODE).get(uocSaleOrderDo.getSaleOrderState()));
            if (ObjectUtil.isNotNull(uocSaleOrderDo.getStakeholder())) {
                rspBo.setStakeholderInfo(UocRu.js(uocSaleOrderDo.getStakeholder(), UocOverallProgressStakeholderInfoBO.class));
            }
        }
    }

    /**
     * 查询发货单明细信息
     *
     * @param reqBo
     * @param saleOrderItemIdList
     * @return java.util.List<com.tydic.dyc.oc.model.shiporder.sub.UocShipOrderItem></>
     */
    private List<UocShipOrderItem> getShipOrderItemList(UocSaleOrderItem reqBo, List<Long> saleOrderItemIdList) {
        UocShipOrderItemQryBo uocShipOrderItemQryBo = new UocShipOrderItemQryBo();
        uocShipOrderItemQryBo.setOrderId(reqBo.getOrderId());
        uocShipOrderItemQryBo.setSaleOrderId(reqBo.getSaleOrderId());
        uocShipOrderItemQryBo.setSaleOrderItemIdList(saleOrderItemIdList);
        return iUocShipOrderModel.getListShipOrderItem(uocShipOrderItemQryBo).getShipOrderItemBoList();
    }

    /**
     * 封装销售单明细信息
     *
     * @param rspBo
     * @param saleOrderItemList
     */
    private void buildSaleOrderItem(UocQryOrderOverallProgressRspBo rspBo, List<UocSaleOrderItem> saleOrderItemList) {
        if (ObjectUtil.isNotEmpty(saleOrderItemList)) {
            //获取发货单信息
            List<Long> saleOrderItemIdList = saleOrderItemList.stream().map(UocSaleOrderItem::getSaleOrderItemId).filter(Objects::nonNull).collect(Collectors.toList());
            List<UocShipOrderItem> shipOrderItemList = getShipOrderItemList(saleOrderItemList.get(0), saleOrderItemIdList);
            Map<Long, UocShipOrderItem> shipOrderItemMap = new HashMap<>();
            if (ObjectUtil.isNotEmpty(shipOrderItemList)) {
                shipOrderItemMap = shipOrderItemList.stream().collect(Collectors.toMap(UocShipOrderItem::getSaleOrderItemId, o -> o, (k1, k2) -> k2));
            }
            for (UocSaleOrderItem each : saleOrderItemList) {
                if (ObjectUtil.isNotNull(each.getSalePrice()) && ObjectUtil.isNotNull(each.getPurchaseCount())) {
                    //总销售金额
                    each.setTotalSaleFee(each.getSalePrice().multiply(each.getPurchaseCount()));
                }
                //发货信息
                if (ObjectUtil.isNotEmpty(shipOrderItemMap) && ObjectUtil.isNotNull(shipOrderItemMap.get(each.getSaleOrderItemId()))) {
                    //发货数量
                    each.setSendCount(shipOrderItemMap.get(each.getSaleOrderItemId()).getSendCount());
                    //验收数量
                    each.setAcceptanceCount(shipOrderItemMap.get(each.getSaleOrderItemId()).getInspCount());
                }
                //到货时间
                if (ObjectUtil.isNotEmpty(each.getArrivalTime())) {
                    each.setArriveTime(DateUtils.strToDate(each.getArrivalTime()));
                }
            }
            rspBo.setSaleOrderItemInfos(UocRu.jsl(saleOrderItemList, UocOverallProgressSaleOrderItemBO.class));
        }
    }

    /**
     * 查询销售单主体
     *
     * @param reqBo
     * @return com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo
     */
    private UocSaleOrderDo getUocSaleOrderDo(UocQryOrderOverallProgressReqBo reqBo) {
        UocSaleOrderDo qryBo = new UocSaleOrderDo();
        qryBo.setSaleOrderId(reqBo.getSaleOrderId());
        qryBo.setOrderId(reqBo.getOrderId());
        List<UocSaleOrderDo> uocSaleOrderDos = iUocSaleOrderModel.qrySaleOrderList(qryBo);
        return ObjectUtil.isNotNull(uocSaleOrderDos) ? uocSaleOrderDos.get(0) : null;
    }

    /**
     * 查询订单主体
     *
     * @param reqBo
     * @return com.tydic.dyc.oc.model.order.UocOrderDo
     */
    private UocOrderDo getUocOrderDo(UocQryOrderOverallProgressReqBo reqBo) {
        UocOrderDo uocOrderDo = new UocOrderDo();
        uocOrderDo.setOrderId(reqBo.getOrderId());
        return iUocOrderModel.qryOrderBy(uocOrderDo);
    }


    /**
     * 查询销售单明细
     *
     * @param reqBo
     * @return com.tydic.dyc.oc.model.saleorder.sub.UocSaleOrderItem
     */
    private List<UocSaleOrderItem> getSaleOrderItemList(UocQryOrderOverallProgressReqBo reqBo) {
        UocSaleOrderItemQryBo uocSaleOrderItemQryBo = new UocSaleOrderItemQryBo();
        uocSaleOrderItemQryBo.setSaleOrderId(reqBo.getSaleOrderId());
        uocSaleOrderItemQryBo.setOrderId(reqBo.getOrderId());
        return iUocSaleOrderModel.getSaleOrderItemList(uocSaleOrderItemQryBo);
    }

    /**
     * 封装订单主体信息
     *
     * @param rspBo
     * @param uocOrderDo
     * @return
     */
    private void buildOrderMain(UocQryOrderOverallProgressRspBo rspBo, UocOrderDo uocOrderDo) {
        rspBo.setOrderId(uocOrderDo.getOrderId());
        rspBo.setOrderNo(uocOrderDo.getOrderNo());
        rspBo.setOrderName(uocOrderDo.getOrderName());
        rspBo.setOrderState(uocOrderDo.getOrderState());
        rspBo.setOrderStateStr(getDic().get(UocDicConstant.ORD_STATE.P_CODE).get(uocOrderDo.getOrderState()));
        rspBo.setCreateTime(uocOrderDo.getCreateTime());
    }

    /**
     * 查询字典
     */
    private Map<String, Map<String, String>> getDic() {
        List<String> pCodes = new ArrayList<>();
        pCodes.add(UocDicConstant.SALE_ORD_STATE.P_CODE);
        pCodes.add(UocDicConstant.ORD_STATE.P_CODE);
        return iUocSysDictionaryModel.getDictionaryMap(pCodes);
    }

    /**
     * 入参校验
     *
     * @param reqBo
     */
    private void validateArg(UocQryOrderOverallProgressReqBo reqBo) {

        if (reqBo == null) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象[UocQryOrderOverallProgressReqBo]不能为空");
        }
        if (ObjectUtil.isEmpty(reqBo.getOrderId())) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性【订单id】不能为空");
        }
        if (ObjectUtil.isEmpty(reqBo.getSaleOrderId())) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性【销售单id】不能为空");
        }

    }
}


