/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.oc.service.domainservice;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.constants.UocAttachementTypeConstants;
import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.model.order.IUocOrderModel;
import com.tydic.dyc.oc.model.order.qrybo.UocConfEffectiveQryBo;
import com.tydic.dyc.oc.model.order.sub.UocConfEffective;
import com.tydic.dyc.oc.model.order.sub.UocOrderAccessory;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderItemQryBo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderQryBo;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleOrderItem;
import com.tydic.dyc.oc.model.shiporder.IUocShipOrderModel;
import com.tydic.dyc.oc.model.shiporder.UocShipOrderDo;
import com.tydic.dyc.oc.service.domainservice.UocSaleShipOrderService;
import com.tydic.dyc.oc.service.domainservice.bo.UocSaleShipOrderReqBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocSaleShipOrderReqItemBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocSaleShipOrderRspBo;
import com.tydic.dyc.oc.utils.IdUtil;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"OC_GROUP_DEV/3.0.0/com.tydic.dyc.oc.service.domainservice.UocSaleShipOrderService"})
public class UocSaleShipOrderServiceImpl
implements UocSaleShipOrderService {
    @Autowired
    private IUocShipOrderModel iUocShipOrderModel;
    @Autowired
    private IUocSaleOrderModel iUocSaleOrderModel;
    @Autowired
    private IUocOrderModel iUocOrderModel;
    private static final String OP_FLAG_YES = "1";
    private static final String OP_FLAG_NO = "0";
    private static final String EC_IMPORT = "2";
    private static final String SUP_NO = "0";

    @PostMapping(value={"dealImplShipOrder"})
    public UocSaleShipOrderRspBo dealImplShipOrder(@RequestBody UocSaleShipOrderReqBo reqBo) {
        this.validateArg(reqBo);
        UocSaleOrderDo saleOrderInfo = this.getSaleOrderInfo(reqBo);
        List<UocSaleOrderItem> saleOrderItemInfos = this.getSaleOrderItemInfos(reqBo);
        Long shipOrderId = IdUtil.nextId();
        String shipOrderNo = this.getShipOrderNo(saleOrderInfo.getOrderSource());
        this.createShipOrder(reqBo, saleOrderItemInfos, shipOrderId, shipOrderNo);
        this.updateSaleOrderSendCount(reqBo);
        boolean finish = this.checkSaleOrderIsFinish(reqBo);
        if (finish && !"XS_FH_FHWC".equals(saleOrderInfo.getSaleOrderState())) {
            this.updateSaleOrderState(reqBo, "XS_FH_FHWC");
        } else if ("XS_FH_DFH".equals(saleOrderInfo.getSaleOrderState())) {
            this.updateSaleOrderState(reqBo, "XS_FH_FHZ");
        }
        UocSaleShipOrderRspBo rspBo = new UocSaleShipOrderRspBo();
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        rspBo.setShipOrderId(shipOrderId);
        rspBo.setShipOrderNo(shipOrderNo);
        rspBo.setFinish(Boolean.valueOf(finish));
        if (finish) {
            rspBo.setOpFlag(OP_FLAG_YES);
        } else {
            rspBo.setOpFlag("0");
        }
        return rspBo;
    }

    private void updateSaleOrderState(UocSaleShipOrderReqBo reqBo, String saleOrderState) {
        UocSaleOrderDo updateSaleOrderDo = new UocSaleOrderDo();
        updateSaleOrderDo.setOrderId(reqBo.getOrderId());
        updateSaleOrderDo.setSaleOrderId(reqBo.getSaleOrderId());
        updateSaleOrderDo.setUpdateOperId(reqBo.getUserId().toString());
        updateSaleOrderDo.setSaleOrderState(saleOrderState);
        this.iUocSaleOrderModel.updateSaleStatusAndProCode(updateSaleOrderDo);
    }

    private boolean checkSaleOrderIsFinish(UocSaleShipOrderReqBo reqBo) {
        UocSaleOrderItemQryBo uocSaleOrderItemQryBo = new UocSaleOrderItemQryBo();
        uocSaleOrderItemQryBo.setOrderId(reqBo.getOrderId());
        uocSaleOrderItemQryBo.setSaleOrderId(reqBo.getSaleOrderId());
        UocSaleOrderDo uocSaleOrderDo = this.iUocSaleOrderModel.getCollectCountImplOrderItem(uocSaleOrderItemQryBo);
        if (null != uocSaleOrderDo && !CollectionUtils.isEmpty(uocSaleOrderDo.getSaleOrderItems()) && null != uocSaleOrderDo.getSaleOrderItems().get(0)) {
            return uocSaleOrderDo.getSaleOrderItems().get(0).getPurchaseCount().compareTo(uocSaleOrderDo.getSaleOrderItems().get(0).getSendCount().add(uocSaleOrderDo.getSaleOrderItems().get(0).getReturnCount())) == 0;
        }
        throw new BaseBusinessException("101003", "\u67e5\u8be2\u9500\u552e\u5355\u660e\u7ec6\u6570\u91cf\u6c47\u603b\u4e3a\u7a7a");
    }

    private void updateSaleOrderSendCount(UocSaleShipOrderReqBo reqBo) {
        UocSaleOrderDo updateSaleOrderDo = new UocSaleOrderDo();
        updateSaleOrderDo.setOrderId(reqBo.getOrderId());
        updateSaleOrderDo.setSaleOrderId(reqBo.getSaleOrderId());
        updateSaleOrderDo.setUpdateOperId(String.valueOf(reqBo.getUserId()));
        updateSaleOrderDo.setUpdateTime(new Date());
        updateSaleOrderDo.setSaleOrderItems(reqBo.getShipOrderItemBoList().stream().map(uocImplShipOrderReqItemBo -> {
            UocSaleOrderItem uocSaleOrderItem = new UocSaleOrderItem();
            uocSaleOrderItem.setSaleOrderItemId(uocImplShipOrderReqItemBo.getSaleOrderItemId());
            uocSaleOrderItem.setSendCount(uocImplShipOrderReqItemBo.getSendCount());
            return uocSaleOrderItem;
        }).collect(Collectors.toList()));
        this.iUocSaleOrderModel.modifyBatchItemSendCount(updateSaleOrderDo);
    }

    private void createShipOrder(UocSaleShipOrderReqBo reqBo, List<UocSaleOrderItem> saleOrderItemInfos, Long shipOrderId, String shipOrderNo) {
        Map<Long, UocSaleOrderItem> saleOrderItemMap = saleOrderItemInfos.stream().collect(Collectors.toMap(UocSaleOrderItem::getSaleOrderItemId, o -> o));
        UocShipOrderDo createShipOrderDo = (UocShipOrderDo)JSONObject.parseObject((String)JSON.toJSONString((Object)reqBo), UocShipOrderDo.class);
        createShipOrderDo.setShipOrderState("FH_FH_FH");
        createShipOrderDo.setShipOperId(String.valueOf(reqBo.getUserId()));
        createShipOrderDo.setCreateOperId(String.valueOf(reqBo.getUserId()));
        createShipOrderDo.setCreateTime(new Date());
        createShipOrderDo.setShipOrderId(shipOrderId);
        createShipOrderDo.setSupNo(saleOrderItemInfos.get(0).getSupplierId());
        createShipOrderDo.setShipOrderNo(shipOrderNo);
        if (!CollectionUtils.isEmpty((Collection)reqBo.getOrderAccessoryBoList())) {
            List uocOrderAccessoryList = JSONArray.parseArray((String)JSON.toJSONString((Object)reqBo.getOrderAccessoryBoList())).toJavaList(UocOrderAccessory.class);
            uocOrderAccessoryList.forEach(uocOrderAccessory -> {
                uocOrderAccessory.setOrderId(reqBo.getOrderId());
                uocOrderAccessory.setCreateTime(new Date());
                uocOrderAccessory.setCreateOperId(reqBo.getUserId().toString());
                uocOrderAccessory.setId(IdUtil.nextId());
                uocOrderAccessory.setObjType(UocDicConstant.OBJ_TYPE.SHIP);
                uocOrderAccessory.setObjId(shipOrderId);
                uocOrderAccessory.setAttachmentType(UocAttachementTypeConstants.DELIVERY);
            });
            createShipOrderDo.setOrderAccessoryBoList(uocOrderAccessoryList);
        }
        createShipOrderDo.getShipOrderItemBoList().forEach(uocShipOrderItem -> {
            UocSaleOrderItem uocSaleOrderItem = (UocSaleOrderItem)((Object)((Object)saleOrderItemMap.get(uocShipOrderItem.getSaleOrderItemId())));
            if (uocShipOrderItem.getSendCount().add(uocSaleOrderItem.getSendCount()).compareTo(uocSaleOrderItem.getPurchaseCount()) > 0) {
                throw new BaseBusinessException("101002", "\u5b58\u5728\u5df2\u53d1\u8d27\u5b8c\u6210\u7684\u5546\u54c1\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u5546\u54c1\u53d1\u8d27");
            }
            uocShipOrderItem.setShipOrderId(shipOrderId);
            uocShipOrderItem.setOrderId(reqBo.getOrderId());
            uocShipOrderItem.setSaleOrderId(reqBo.getSaleOrderId());
            uocShipOrderItem.setSaleOrderItemId(uocSaleOrderItem.getSaleOrderItemId());
            uocShipOrderItem.setUnitName(uocSaleOrderItem.getUnitName());
            uocShipOrderItem.setCreateOperId(String.valueOf(reqBo.getUserId()));
            uocShipOrderItem.setCreateTime(new Date());
            uocShipOrderItem.setShipOrderItemId(IdUtil.nextId());
        });
        createShipOrderDo.setAllowChngTime(this.getShipAllowChngTime(reqBo));
        this.iUocShipOrderModel.createShipOrder(createShipOrderDo);
    }

    private Date getShipAllowChngTime(UocSaleShipOrderReqBo reqBo) {
        UocSaleOrderQryBo querySaleOrderQryBo = new UocSaleOrderQryBo();
        querySaleOrderQryBo.setSaleOrderId(reqBo.getSaleOrderId());
        querySaleOrderQryBo.setOrderId(reqBo.getOrderId());
        UocSaleOrderDo saleOrderInfo = this.iUocSaleOrderModel.qrySaleOrder(querySaleOrderQryBo);
        UocConfEffectiveQryBo uocConfEffectiveQryBo = new UocConfEffectiveQryBo();
        uocConfEffectiveQryBo.setEffectiveCode("5");
        List rows = this.iUocOrderModel.qryListPageConfEffective(uocConfEffectiveQryBo).getRows();
        Date allowChngTime = null;
        if (ObjectUtil.isNotEmpty((Object)rows)) {
            Map confEffectiveMap = rows.stream().collect(Collectors.toMap(o -> o.getBusinessTypeCode() + o.getSupplierNo(), Function.identity()));
            if (null != saleOrderInfo) {
                String key = null;
                key = null != saleOrderInfo.getStakeholder() ? saleOrderInfo.getOrderSource() + saleOrderInfo.getStakeholder().getSupId() : String.valueOf(saleOrderInfo.getOrderSource()) + reqBo.getSupId();
                allowChngTime = ObjectUtil.isNotNull(confEffectiveMap.get(key)) ? new Date(((UocConfEffective)confEffectiveMap.get(key)).getAging()) : new Date(((UocConfEffective)confEffectiveMap.get(saleOrderInfo.getOrderSource() + "0")).getAging());
            } else {
                allowChngTime = new Date(((UocConfEffective)confEffectiveMap.get("20")).getAging());
            }
        }
        return allowChngTime;
    }

    private List<UocSaleOrderItem> getSaleOrderItemInfos(UocSaleShipOrderReqBo reqBo) {
        List<Long> saleOrderItemIds = reqBo.getShipOrderItemBoList().stream().map(UocSaleShipOrderReqItemBo::getSaleOrderItemId).collect(Collectors.toList());
        UocSaleOrderItemQryBo uocSaleOrderItemQryBo = new UocSaleOrderItemQryBo();
        uocSaleOrderItemQryBo.setSaleOrderItemIdList(saleOrderItemIds);
        uocSaleOrderItemQryBo.setOrderId(reqBo.getOrderId());
        uocSaleOrderItemQryBo.setSaleOrderId(reqBo.getSaleOrderId());
        UocSaleOrderDo uocSaleOrderDo = this.iUocSaleOrderModel.getListSaleOrderItem(uocSaleOrderItemQryBo);
        List<UocSaleOrderItem> saleOrderItems = uocSaleOrderDo.getSaleOrderItems();
        if (CollectionUtils.isEmpty(saleOrderItems)) {
            throw new BaseBusinessException("101002", "\u83b7\u53d6\u9500\u552e\u5355\u660e\u7ec6\u4e3a\u7a7a");
        }
        return saleOrderItems;
    }

    private String getShipOrderNo(Integer orderSource) {
        UocShipOrderDo uocShipOrderDo = new UocShipOrderDo();
        uocShipOrderDo.setOrderSource(orderSource);
        uocShipOrderDo = this.iUocShipOrderModel.getShipOrderNo(uocShipOrderDo);
        if (null != uocShipOrderDo) {
            return uocShipOrderDo.getShipOrderNo();
        }
        throw new BaseBusinessException("101002", "\u751f\u6210\u53d1\u8d27\u5355\u7f16\u53f7\u5931\u8d25");
    }

    private UocSaleOrderDo getSaleOrderInfo(UocSaleShipOrderReqBo reqBo) {
        UocSaleOrderDo uocSaleOrderDo = new UocSaleOrderDo();
        uocSaleOrderDo.setSaleOrderId(reqBo.getSaleOrderId());
        uocSaleOrderDo.setOrderId(reqBo.getOrderId());
        uocSaleOrderDo = this.iUocSaleOrderModel.getSaleOrderMain(uocSaleOrderDo);
        if (null == uocSaleOrderDo) {
            throw new BaseBusinessException("101002", "\u67e5\u8be2\u9500\u552e\u5355\u4e3a\u7a7a");
        }
        return uocSaleOrderDo;
    }

    private void validateArg(UocSaleShipOrderReqBo reqBo) {
        if (null == reqBo) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u4e3a\u7a7a");
        }
        if (null == reqBo.getOrderId()) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u8ba2\u5355ID\u4e3a\u7a7a");
        }
        if (null == reqBo.getSaleOrderId()) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u9500\u552e\u5355ID\u4e3a\u7a7a");
        }
        if (null == reqBo.getUserId()) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u7528\u6237ID\u4e3a\u7a7a");
        }
    }
}

