/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.oc.components.event.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.tydic.dyc.oc.components.es.IUocEsSyncQryReqBo;
import com.tydic.dyc.oc.components.event.EventConsumer;
import com.tydic.dyc.oc.components.event.IUocEsSyncQryEventReqBo;
import com.tydic.dyc.oc.config.UocIndexConfig;
import com.tydic.dyc.oc.utils.UocRu;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class EventConsumerSyncAfterOrder
implements EventConsumer {
    private static final Logger log = LoggerFactory.getLogger(EventConsumerSyncAfterOrder.class);
    @Autowired
    private UocIndexConfig uocIndexConfig;

    @Override
    public List<IUocEsSyncQryEventReqBo> parseMap(Map<String, Object> map) {
        log.info("event-EventConsumerSyncAfterOrder->{}", (Object)JSON.toJSONString(map));
        ArrayList<IUocEsSyncQryEventReqBo> retList = new ArrayList<IUocEsSyncQryEventReqBo>();
        Long afOrderId = UocRu.parseLong(map.get("afOrderId"));
        Long orderId = UocRu.parseLong(map.get("orderId"));
        Long saleOrderId = UocRu.parseLong(map.get("saleOrderId"));
        Long shipOrderId = UocRu.parseLong(map.get("shipOrderId"));
        Long sysTenantId = UocRu.parseLong(map.get("sysTenantId"));
        String extObj = UocRu.parseStr(map.get("saleOrderExtObj"));
        ArrayList<IUocEsSyncQryReqBo> afOrderList = new ArrayList<IUocEsSyncQryReqBo>();
        IUocEsSyncQryReqBo afOrder = new IUocEsSyncQryReqBo();
        afOrder.setOrderId(orderId);
        afOrder.setObjId(afOrderId);
        afOrder.setSysTenantId(sysTenantId);
        afOrderList.add(afOrder);
        IUocEsSyncQryEventReqBo saleEventReqBo = new IUocEsSyncQryEventReqBo();
        saleEventReqBo.setIndexName(this.uocIndexConfig.getAfOrderIndex());
        saleEventReqBo.setDataList(afOrderList);
        retList.add(saleEventReqBo);
        if (ObjectUtil.isNotEmpty((Object)shipOrderId)) {
            ArrayList<IUocEsSyncQryReqBo> shipList = new ArrayList<IUocEsSyncQryReqBo>();
            IUocEsSyncQryReqBo ship = new IUocEsSyncQryReqBo();
            ship.setOrderId(orderId);
            ship.setObjId(shipOrderId);
            ship.setSysTenantId(sysTenantId);
            shipList.add(ship);
            IUocEsSyncQryEventReqBo shipEventReqBo = new IUocEsSyncQryEventReqBo();
            shipEventReqBo.setIndexName(this.uocIndexConfig.getShipOrderIndex());
            shipEventReqBo.setDataList(shipList);
            retList.add(shipEventReqBo);
        }
        if (ObjectUtil.isNotEmpty((Object)saleOrderId)) {
            ArrayList<IUocEsSyncQryReqBo> saleList = new ArrayList<IUocEsSyncQryReqBo>();
            IUocEsSyncQryReqBo sale = new IUocEsSyncQryReqBo();
            sale.setOrderId(orderId);
            sale.setObjId(saleOrderId);
            sale.setSysTenantId(sysTenantId);
            Optional.ofNullable(extObj).ifPresent(x -> sale.setJsonObj(JSONObject.parseObject((String)x)));
            saleList.add(sale);
            IUocEsSyncQryEventReqBo eventReqBo = new IUocEsSyncQryEventReqBo();
            eventReqBo.setIndexName(this.uocIndexConfig.getSaleOrderIndex());
            eventReqBo.setDataList(saleList);
            retList.add(eventReqBo);
        }
        return retList;
    }

    @Override
    public String getEvent() {
        return "UOCE_CREATE_AFTER";
    }
}

