/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.oc.service.domainservice;

import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.constants.UocConstant;
import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.model.chngorder.IUocChngOrderModel;
import com.tydic.dyc.oc.model.chngorder.UocChngOrderDo;
import com.tydic.dyc.oc.model.chngorder.qrybo.UocChngOrderItemObjQryBo;
import com.tydic.dyc.oc.model.chngorder.qrybo.UocChngOrderObjQryBo;
import com.tydic.dyc.oc.model.chngorder.qrybo.UocChngOrderQryBo;
import com.tydic.dyc.oc.model.chngorder.sub.UocChngOrderItemMap;
import com.tydic.dyc.oc.model.chngorder.sub.UocChngOrderItemObj;
import com.tydic.dyc.oc.model.chngorder.sub.UocChngOrderObj;
import com.tydic.dyc.oc.model.order.IUocOrderModel;
import com.tydic.dyc.oc.model.order.UocOrderDo;
import com.tydic.dyc.oc.model.order.qrybo.UocOrderAccessoryQryBo;
import com.tydic.dyc.oc.model.order.sub.UocOrderAccessory;
import com.tydic.dyc.oc.model.order.sub.UocOrderAgreement;
import com.tydic.dyc.oc.model.payorder.IUocPayOrderModel;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocOrderAgreementQryBo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderItemQryBo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderQryBo;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleOrderItem;
import com.tydic.dyc.oc.model.shiporder.IUocShipOrderModel;
import com.tydic.dyc.oc.model.shiporder.UocShipOrderDo;
import com.tydic.dyc.oc.model.shiporder.qrybo.UocShipOrderItemQryBo;
import com.tydic.dyc.oc.model.shiporder.qrybo.UocShipOrderQryBo;
import com.tydic.dyc.oc.model.shiporder.sub.UocShipOrderItem;
import com.tydic.dyc.oc.model.sysdictionary.IUocSysDictionaryModel;
import com.tydic.dyc.oc.model.sysdictionary.qrybo.UocSysDictionaryQryBo;
import com.tydic.dyc.oc.service.common.bo.UocBaseOrderAccessoryDetailBo;
import com.tydic.dyc.oc.service.common.bo.UocBaseOrderAccessoryTypeDetailBo;
import com.tydic.dyc.oc.service.domainservice.UocQryChngOrderDetailsService;
import com.tydic.dyc.oc.service.domainservice.bo.UocQryChngOrderDetailsReqBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocQryChngOrderDetailsRspBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocQryChngOrderDetailsRspInfoAgreementDataBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocQryChngOrderDetailsRspInfoBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocQryChngOrderDetailsRspInfoItemBo;
import com.tydic.dyc.oc.utils.UocRu;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"OC_GROUP_DEV/3.0.0/com.tydic.dyc.oc.service.domainservice.UocQryChngOrderDetailsService"})
public class UocQryChngOrderDetailsServiceImpl
implements UocQryChngOrderDetailsService {
    @Autowired
    private IUocChngOrderModel iUocChngOrderModel;
    @Autowired
    private IUocSysDictionaryModel iUocSysDictionaryModel;
    @Autowired
    private IUocSaleOrderModel iUocSaleOrderModel;
    @Autowired
    private IUocShipOrderModel iUocShipOrderModel;
    @Autowired
    private IUocOrderModel iUocOrderModel;
    @Autowired
    private IUocPayOrderModel iUocPayOrderModel;

    @PostMapping(value={"getChngOrderDetails"})
    public UocQryChngOrderDetailsRspBo getChngOrderDetails(@RequestBody UocQryChngOrderDetailsReqBo reqBo) {
        this.val(reqBo);
        if (null == reqBo.getChngOrderId()) {
            UocChngOrderObjQryBo selectUocChngOrderObjQryBo = new UocChngOrderObjQryBo();
            selectUocChngOrderObjQryBo.setOrderId(reqBo.getOrderId());
            selectUocChngOrderObjQryBo.setSaleOrderId(reqBo.getSaleOrderId());
            selectUocChngOrderObjQryBo.setChngType(UocConstant.BUSI_TYPE.PRICE_CHG);
            List<UocChngOrderObj> uocChngOrderObjs = this.iUocChngOrderModel.getListChngOrderObjWithOutItem(selectUocChngOrderObjQryBo);
            if (CollectionUtils.isEmpty(uocChngOrderObjs)) {
                throw new BaseBusinessException("101005", "\u67e5\u8be2\u53d8\u66f4\u5355\u5bf9\u8c61\u8868\u4e3a\u7a7a\uff01");
            }
            if (uocChngOrderObjs.size() > 1) {
                uocChngOrderObjs.sort((m1, m2) -> m2.getCreateTime().compareTo(m1.getCreateTime()));
            }
            reqBo.setChngOrderId(uocChngOrderObjs.get(0).getChngOrderId());
        }
        UocQryChngOrderDetailsRspBo uocQryChngOrderDetailsRspBo = UocRu.success(UocQryChngOrderDetailsRspBo.class);
        UocChngOrderQryBo uocChngOrderQryBo = UocRu.js(reqBo, UocChngOrderQryBo.class);
        UocChngOrderDo chngOrder = this.iUocChngOrderModel.getChngOrder(uocChngOrderQryBo);
        if (null != chngOrder) {
            List<UocOrderAccessory> orderAccessoryList;
            UocQryChngOrderDetailsRspInfoBo chngOrderInfo = UocRu.js(chngOrder, UocQryChngOrderDetailsRspInfoBo.class);
            Map<String, Map<String, String>> dicMap = this.getDic(reqBo.getSysTenantId());
            Map<String, String> chngStateMap = dicMap.get("CHNG_ORDER_STATE_SALE_ORDER_CANCEL");
            Map<String, String> saleStateMap = dicMap.get("UOC_SALE_ORDER_STATE");
            Map<String, String> orderStateMap = dicMap.get("UOC_ORDER_STATE");
            Map<String, String> adjustPriceMap = dicMap.get("UOC_ORD_ADJUST_PRICE");
            Map<String, String> agreementModeMap = dicMap.get("UOC_ORD_AGREEMENT_MODE");
            Map<String, String> tradeModeMap = dicMap.get("UOC_COMMON_MODEL_SETTLE");
            Map<String, String> chngTypeMap = dicMap.get("CHNG_ORDER_TYPE");
            Map<String, String> interTypeMap = dicMap.get("INTER_TYPE");
            Map<String, String> shipStateMap = dicMap.get("SHIP_ORDER_STATE");
            Map<String, String> chngStateContentMap = dicMap.get("ORD_SHIP_ABNORMAL_STATUS");
            Map<String, String> chngOrderStateMap = dicMap.get("CHNG_ORDER_STATE");
            if (ObjectUtil.equal((Object)chngOrder.getBusiType(), (Object)UocConstant.BUSI_TYPE.SALE_ORDER_CANCEL)) {
                chngOrderInfo.setChngOrderStateStr(chngStateMap.get(chngOrderInfo.getChngOrderState()));
            } else {
                chngOrderInfo.setChngOrderStateStr(chngOrderStateMap.get(chngOrderInfo.getChngOrderState()));
            }
            UocOrderDo uocOrderDo = new UocOrderDo();
            uocOrderDo.setOrderId(reqBo.getOrderId());
            uocOrderDo = this.iUocOrderModel.qryOrderBy(uocOrderDo);
            if (ObjectUtil.isNotNull((Object)((Object)uocOrderDo))) {
                chngOrderInfo.setOrderNo(uocOrderDo.getOrderNo());
                chngOrderInfo.setOrderTime(uocOrderDo.getCreateTime());
                chngOrderInfo.setOrderState(uocOrderDo.getOrderState());
                chngOrderInfo.setOrderStateStr(orderStateMap.get(uocOrderDo.getOrderState()));
            }
            UocOrderAccessoryQryBo uocOrderAccessoryQryBo = new UocOrderAccessoryQryBo();
            uocOrderAccessoryQryBo.setOrderId(reqBo.getOrderId());
            uocOrderAccessoryQryBo.setObjId(reqBo.getChngOrderId());
            uocOrderAccessoryQryBo.setObjType(UocDicConstant.OBJ_TYPE.CHNG);
            if (null != reqBo.getAttachmentType()) {
                uocOrderAccessoryQryBo.setAttachmentType(reqBo.getAttachmentType());
            }
            if (ObjectUtil.isNotEmpty(orderAccessoryList = this.iUocOrderModel.getOrderAccessoryList(uocOrderAccessoryQryBo))) {
                ArrayList orderAccessoryTypeDetailBos = new ArrayList();
                ConcurrentMap<Integer, List<UocOrderAccessory>> orderAccessoryMap = orderAccessoryList.stream().collect(Collectors.groupingByConcurrent(UocOrderAccessory::getAttachmentType));
                orderAccessoryMap.keySet().forEach(each -> {
                    UocBaseOrderAccessoryTypeDetailBo typeDetailBo = new UocBaseOrderAccessoryTypeDetailBo();
                    typeDetailBo.setAttachmentType(each);
                    if (ObjectUtil.isNotNull((Object)each)) {
                        typeDetailBo.setAttachmentTypeStr(this.getDic(reqBo.getSysTenantId()).get("UOC_ORDER_ACCESSORY_ATTACHMENT_TYPE").get(each.toString()));
                    }
                    typeDetailBo.setAttchList(UocRu.jsl((List)orderAccessoryMap.get(each), UocBaseOrderAccessoryDetailBo.class));
                    orderAccessoryTypeDetailBos.add(typeDetailBo);
                });
                chngOrderInfo.setChngOrderAccessoryList(orderAccessoryTypeDetailBos);
            }
            UocChngOrderObjQryBo uocChngOrderObjQryBo = new UocChngOrderObjQryBo();
            uocChngOrderObjQryBo.setOrderId(reqBo.getOrderId());
            uocChngOrderObjQryBo.setChngOrderId(reqBo.getChngOrderId());
            List<UocChngOrderObj> uocChngOrderObjList = this.iUocChngOrderModel.getListChngOrderObj(uocChngOrderObjQryBo);
            if (!CollectionUtils.isEmpty(uocChngOrderObjList)) {
                UocChngOrderObj uocChngOrderObj = uocChngOrderObjList.get(0);
                List shipOrderItemIdList = uocChngOrderObj.getUocChngOrderItemObjList().stream().map(UocChngOrderItemObj::getShipOrderItemId).filter(Objects::nonNull).collect(Collectors.toList());
                if (org.apache.commons.collections.CollectionUtils.isNotEmpty(shipOrderItemIdList)) {
                    chngOrderInfo.setShipOrderItemIdList(shipOrderItemIdList);
                }
                chngOrderInfo.setChngType(uocChngOrderObj.getChngType());
                if (null != chngOrderInfo.getChngType()) {
                    chngOrderInfo.setChngTypeStr(chngTypeMap.get(chngOrderInfo.getChngType().toString()));
                }
                if (!Objects.isNull(uocChngOrderObj.getShipOrderId())) {
                    UocShipOrderQryBo uocShipOrderQryBo = new UocShipOrderQryBo();
                    uocShipOrderQryBo.setOrderId(reqBo.getOrderId());
                    uocShipOrderQryBo.setShipOrderId(uocChngOrderObj.getShipOrderId());
                    UocShipOrderDo shipOrderOrderDo = this.iUocShipOrderModel.getShipOrderById(uocShipOrderQryBo);
                    if (ObjectUtil.isNotNull((Object)shipOrderOrderDo)) {
                        chngOrderInfo.setShipOrderNo(shipOrderOrderDo.getShipOrderNo());
                    }
                }
                chngOrderInfo.setPayFee(uocChngOrderObj.getChngFee());
                if (uocChngOrderObj.getChngFee() != null) {
                    if (uocChngOrderObj.getChngFee().compareTo(BigDecimal.ZERO) > 0) {
                        chngOrderInfo.setInterType(UocDicConstant.INTER_TYPE.REFUND);
                        chngOrderInfo.setInterTypeStr(interTypeMap.get(chngOrderInfo.getInterType().toString()));
                    } else {
                        chngOrderInfo.setInterType(UocDicConstant.INTER_TYPE.DEBIT);
                        chngOrderInfo.setInterTypeStr(interTypeMap.get(chngOrderInfo.getInterType().toString()));
                    }
                }
                UocSaleOrderQryBo uocSaleOrderQryBo = new UocSaleOrderQryBo();
                uocSaleOrderQryBo.setSaleOrderId(uocChngOrderObj.getSaleOrderId());
                uocSaleOrderQryBo.setOrderId(reqBo.getOrderId());
                UocSaleOrderDo uocSaleOrderDo = this.iUocSaleOrderModel.qrySaleOrder(uocSaleOrderQryBo);
                if (null != uocSaleOrderDo) {
                    if (null != uocSaleOrderDo.getStakeholder()) {
                        BeanUtils.copyProperties((Object)uocSaleOrderDo.getStakeholder(), (Object)chngOrderInfo);
                    }
                    chngOrderInfo.setOrderSource(uocSaleOrderDo.getOrderSource());
                    chngOrderInfo.setSaleOrderNo(uocSaleOrderDo.getSaleOrderNo());
                    chngOrderInfo.setSaleOrderId(uocSaleOrderDo.getSaleOrderId());
                    chngOrderInfo.setSaleOrderState(uocSaleOrderDo.getSaleOrderState());
                    chngOrderInfo.setSaleOrderStateStr(saleStateMap.get(uocSaleOrderDo.getSaleOrderState()));
                    chngOrderInfo.setTotalSaleFee(uocSaleOrderDo.getTotalSaleFee());
                    chngOrderInfo.setTotalTransFee(uocSaleOrderDo.getTotalTransFee());
                    chngOrderInfo.setCommodityFee(uocSaleOrderDo.getTotalSaleFee());
                    if (UocDicConstant.ORDER_SOURCE.AGR_GENERATE.equals(uocSaleOrderDo.getOrderSource())) {
                        UocOrderAgreementQryBo uocOrderAgreementQryBo = new UocOrderAgreementQryBo();
                        uocOrderAgreementQryBo.setOrderId(reqBo.getOrderId());
                        uocOrderAgreementQryBo.setId(uocSaleOrderDo.getAgrDataId());
                        List<UocOrderAgreement> agreementOrderList = this.iUocSaleOrderModel.getAgreementOrderList(uocOrderAgreementQryBo);
                        if (ObjectUtil.isNotEmpty(agreementOrderList)) {
                            chngOrderInfo.setChngAgreementInfo(new UocQryChngOrderDetailsRspInfoAgreementDataBo());
                            chngOrderInfo.getChngAgreementInfo().setAgreementCode(agreementOrderList.get(0).getAgreementCode());
                            chngOrderInfo.getChngAgreementInfo().setPlaAgreementCode(agreementOrderList.get(0).getPlaAgreementCode());
                            chngOrderInfo.getChngAgreementInfo().setEntAgreementCode(agreementOrderList.get(0).getEntAgreementCode());
                            chngOrderInfo.getChngAgreementInfo().setProducerName(agreementOrderList.get(0).getProducerName());
                            chngOrderInfo.getChngAgreementInfo().setAgreementName(agreementOrderList.get(0).getAgreementName());
                            chngOrderInfo.getChngAgreementInfo().setAdjustPrice(agreementOrderList.get(0).getAdjustPrice());
                            chngOrderInfo.setModelSettle(agreementOrderList.get(0).getTradeMode());
                            if (null != agreementOrderList.get(0).getTradeMode()) {
                                chngOrderInfo.setModelSettleStr(tradeModeMap.get(agreementOrderList.get(0).getTradeMode().toString()));
                            }
                            if (null != agreementOrderList.get(0).getAdjustPrice()) {
                                chngOrderInfo.getChngAgreementInfo().setAdjustPriceStr(adjustPriceMap.get(agreementOrderList.get(0).getAdjustPrice().toString()));
                            }
                            if (null != agreementOrderList.get(0).getAgreementCode()) {
                                chngOrderInfo.getChngAgreementInfo().setAgreementCodeStr(agreementModeMap.get(agreementOrderList.get(0).getAgreementCode().toString()));
                            }
                        }
                    }
                    UocShipOrderItemQryBo uocShipOrderItemQryBo = new UocShipOrderItemQryBo();
                    uocShipOrderItemQryBo.setOrderId(uocChngOrderObj.getOrderId());
                    uocShipOrderItemQryBo.setShipOrderId(uocChngOrderObj.getShipOrderId());
                    UocShipOrderDo listShipOrderItem = this.iUocShipOrderModel.getListShipOrderItem(uocShipOrderItemQryBo);
                    Map<Object, Object> shipOrderItemMap = new HashMap();
                    if (ObjectUtil.isNotEmpty(listShipOrderItem.getShipOrderItemBoList())) {
                        shipOrderItemMap = listShipOrderItem.getShipOrderItemBoList().stream().collect(Collectors.toMap(UocShipOrderItem::getSaleOrderItemId, Function.identity(), (k1, k2) -> k2));
                    }
                    UocSaleOrderItemQryBo uocSaleOrderItemQryBo = new UocSaleOrderItemQryBo();
                    uocSaleOrderItemQryBo.setSaleOrderId(uocSaleOrderDo.getSaleOrderId());
                    uocSaleOrderItemQryBo.setOrderId(uocSaleOrderDo.getOrderId());
                    List<UocSaleOrderItem> saleOrderItemList = this.iUocSaleOrderModel.getSaleOrderItemList(uocSaleOrderItemQryBo);
                    if (!CollectionUtils.isEmpty(saleOrderItemList)) {
                        List<UocChngOrderItemObj> uocChngOrderItemObjList = uocChngOrderObj.getUocChngOrderItemObjList();
                        List changeSaleOrderItemList = uocChngOrderItemObjList.stream().map(UocChngOrderItemObj::getSaleOrderItemId).filter(Objects::nonNull).collect(Collectors.toList());
                        Map changeItemMap = uocChngOrderItemObjList.stream().filter(item -> item.getShipOrderItemId() != null).collect(Collectors.toMap(UocChngOrderItemObj::getSaleOrderItemId, Function.identity()));
                        saleOrderItemList = saleOrderItemList.stream().filter(item -> changeSaleOrderItemList.contains(item.getSaleOrderItemId())).collect(Collectors.toList());
                        chngOrderInfo.setChngOrderItemList(UocRu.jsl(saleOrderItemList, UocQryChngOrderDetailsRspInfoItemBo.class));
                        for (UocQryChngOrderDetailsRspInfoItemBo each2 : chngOrderInfo.getChngOrderItemList()) {
                            UocChngOrderItemObjQryBo qryBo = new UocChngOrderItemObjQryBo();
                            qryBo.setOrderId(each2.getOrderId());
                            qryBo.setChngOrderId(chngOrder.getChngOrderId());
                            qryBo.setSaleOrderItemId(each2.getSaleOrderItemId());
                            List<UocChngOrderItemObj> chngItemObjList = this.iUocChngOrderModel.getListChngOrderItemObj(qryBo);
                            UocChngOrderItemMap uocChngOrderItemMap = new UocChngOrderItemMap();
                            uocChngOrderItemMap.setOrderId(each2.getOrderId());
                            uocChngOrderItemMap.setChngOrderId(chngOrder.getChngOrderId());
                            uocChngOrderItemMap.setChngOrderObjId(each2.getSaleOrderItemId());
                            List<UocChngOrderItemMap> chngItemMapItem = this.iUocChngOrderModel.getChngItemMapItem(uocChngOrderItemMap);
                            if (!CollectionUtils.isEmpty(chngItemMapItem)) {
                                List<UocChngOrderItemMap> adjustPurchasePriceList;
                                Map<String, List<UocChngOrderItemMap>> collect = chngItemMapItem.stream().collect(Collectors.groupingBy(UocChngOrderItemMap::getFieldCode));
                                List<UocChngOrderItemMap> adjustPriceList = collect.get("adjustPrice");
                                if (!CollectionUtils.isEmpty(adjustPriceList)) {
                                    each2.setSalePrice(new BigDecimal(adjustPriceList.get(0).getFieldValue()));
                                }
                                if (!CollectionUtils.isEmpty(adjustPurchasePriceList = collect.get("adjustPurchasePrice"))) {
                                    each2.setPurchasePrice(new BigDecimal(adjustPurchasePriceList.get(0).getFieldValue()));
                                }
                            }
                            if (ObjectUtil.isNotEmpty(chngItemObjList)) {
                                List chngFeeNonList = chngItemObjList.stream().filter(item -> item.getChngFee() != null).collect(Collectors.toList());
                                List chngNumNonList = chngItemObjList.stream().filter(item -> item.getChngNum() != null).collect(Collectors.toList());
                                List chngTypeNonList = chngItemObjList.stream().filter(chngItem -> null != chngItem.getChngType()).collect(Collectors.toList());
                                each2.setChngState(chngItemObjList.get(0).getChngState());
                                Optional.ofNullable(changeItemMap.get(each2.getSaleOrderItemId())).ifPresent(x -> each2.setShipItemId(x.getShipOrderItemId()));
                                Optional.ofNullable(each2.getChngState()).ifPresent(x -> each2.setChngStateStr((String)shipStateMap.get(x)));
                                each2.setOtherChngValue(chngItemObjList.get(0).getOtherChngValue());
                                Optional.ofNullable(each2.getOtherChngValue()).ifPresent(x -> each2.setOtherChngValueStr((String)chngStateContentMap.get(x)));
                                if (ObjectUtil.isNotEmpty(chngFeeNonList)) {
                                    each2.setChngFee(((UocChngOrderItemObj)chngFeeNonList.get(0)).getChngFee());
                                }
                                if (ObjectUtil.isNotEmpty(chngNumNonList)) {
                                    each2.setChngNum(((UocChngOrderItemObj)chngNumNonList.get(0)).getChngNum());
                                }
                                if (ObjectUtil.isNotEmpty(chngTypeNonList)) {
                                    Map chngOrderItemObjMap = chngTypeNonList.stream().collect(Collectors.toMap(UocChngOrderItemObj::getChngType, Function.identity(), (k1, k2) -> k2));
                                    if (null != chngOrderItemObjMap.get(UocConstant.BUSI_TYPE.PRICE_CHG)) {
                                        each2.setSalePriceRear(((UocChngOrderItemObj)chngOrderItemObjMap.get(UocConstant.BUSI_TYPE.PRICE_CHG)).getChngFee());
                                    }
                                    if (null != each2.getSalePrice() && null != each2.getSalePriceRear()) {
                                        each2.setAdjustPriceRate(each2.getSalePriceRear().subtract(each2.getSalePrice()).divide(each2.getSalePrice(), 2, RoundingMode.HALF_UP));
                                    }
                                    if (null != chngOrderItemObjMap.get(UocConstant.BUSI_TYPE.PRICE_CHG)) {
                                        each2.setPurchasePriceRear(((UocChngOrderItemObj)chngOrderItemObjMap.get(UocConstant.BUSI_TYPE.PRICE_CHG)).getChngPurchaseFee());
                                    }
                                    if (chngOrder.getBusiType() == 2) {
                                        each2.setAdjustFlag(Boolean.valueOf(true));
                                        if (Objects.isNull(each2.getSalePriceRear()) || each2.getSalePrice().compareTo(each2.getSalePriceRear()) == 0) {
                                            each2.setAdjustFlag(Boolean.valueOf(false));
                                        }
                                    }
                                }
                            }
                            if (!ObjectUtil.isNotEmpty(shipOrderItemMap) || !shipOrderItemMap.containsKey(each2.getSaleOrderItemId())) continue;
                            each2.setInspCount(((UocShipOrderItem)shipOrderItemMap.get(each2.getSaleOrderItemId())).getInspCount());
                            each2.setPreReturnCount(((UocShipOrderItem)shipOrderItemMap.get(each2.getSaleOrderItemId())).getReturnCount());
                            each2.setCurReturnCount(((UocShipOrderItem)shipOrderItemMap.get(each2.getSaleOrderItemId())).getReturnCount());
                        }
                    }
                }
            }
            chngOrderInfo.setRemark(chngOrder.getRemark());
            uocQryChngOrderDetailsRspBo.setChngOrderInfo(chngOrderInfo);
        }
        return uocQryChngOrderDetailsRspBo;
    }

    private void val(UocQryChngOrderDetailsReqBo reqBo) {
        if (null == reqBo) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u4e3a\u7a7a");
        }
        if (null == reqBo.getChngOrderId() && null == reqBo.getSaleOrderId()) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u53d8\u66f4\u5355ID\u548c\u9500\u552e\u5355ID\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a");
        }
        if (null == reqBo.getOrderId()) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u8ba2\u5355ID\u4e3a\u7a7a");
        }
    }

    private Map<String, Map<String, String>> getDic(Long sysTenantId) {
        ArrayList<String> pCodes = new ArrayList<String>();
        pCodes.add("CHNG_ORDER_STATE_SALE_ORDER_CANCEL");
        pCodes.add("UOC_ORDER_ACCESSORY_ATTACHMENT_TYPE");
        pCodes.add("UOC_SALE_ORDER_STATE");
        pCodes.add("UOC_ORDER_STATE");
        pCodes.add("UOC_ORD_ADJUST_PRICE");
        pCodes.add("UOC_ORD_AGREEMENT_MODE");
        pCodes.add("UOC_COMMON_MODEL_SETTLE");
        pCodes.add("CHNG_ORDER_TYPE");
        pCodes.add("INTER_TYPE");
        pCodes.add("ORD_SHIP_ABNORMAL_STATUS");
        pCodes.add("SHIP_ORDER_STATE");
        pCodes.add("CHNG_ORDER_STATE");
        UocSysDictionaryQryBo uocSysDictionaryQryBo = new UocSysDictionaryQryBo();
        uocSysDictionaryQryBo.setSysTenantId(sysTenantId);
        uocSysDictionaryQryBo.setPCodes(pCodes);
        return this.iUocSysDictionaryModel.getDictionaryMap(uocSysDictionaryQryBo);
    }
}

