package com.tydic.dyc.oc.components.event.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.tydic.dyc.oc.components.es.IUocEsSyncQryReqBo;
import com.tydic.dyc.oc.components.event.EventConsumer;
import com.tydic.dyc.oc.components.event.IUocEsSyncQryEventReqBo;
import com.tydic.dyc.oc.config.UocIndexConfig;
import com.tydic.dyc.oc.constants.UocEventConstant;
import com.tydic.dyc.oc.service.domainservice.bo.UocCreateInspOrderReqShipBo;
import com.tydic.dyc.oc.utils.UocRu;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;


/**
 * 标题:EventConsumerShipCreate
 * 说明:发货单创建后解释
 * 时间:2022/3/10 20:10
 * 作者:罗有
 */
@Component
@Slf4j

public class EventConsumerInspCreate implements EventConsumer {

    @Autowired
    private UocIndexConfig uocIndexConfig;

    @Override
    public List<IUocEsSyncQryEventReqBo> parseMap(Map<String, Object> map) {
        log.info("event-EventConsumerInspCreate->{}", JSON.toJSONString(map));

        List<IUocEsSyncQryEventReqBo> retList = new ArrayList<>();
        Long orderId = UocRu.parseLong(map.get("orderId"));
        Long saleOrderId = UocRu.parseLong(map.get("saleOrderId"));
//        Long implOrderId = UocRu.parseLong(map.get("implOrderId"));
        Long inspOrderId = UocRu.parseLong(map.get("inspOrderId"));
        Long sysTenantId = UocRu.parseLong(map.get("sysTenantId"));
        Object objList = map.get("shipOrderList");
        if (ObjectUtil.isNotNull(objList)) {
            List<UocCreateInspOrderReqShipBo> shipOrderList = UocRu.jsl(objList, UocCreateInspOrderReqShipBo.class);

            List<IUocEsSyncQryReqBo> shipList = new ArrayList<>();
            shipOrderList.forEach(uocCreateInspOrderReqShipBo -> {
                IUocEsSyncQryReqBo ship = new IUocEsSyncQryReqBo();
                ship.setOrderId(orderId);
                ship.setObjId(uocCreateInspOrderReqShipBo.getShipOrderId());
                ship.setSysTenantId(sysTenantId);
                shipList.add(ship);
            });
            IUocEsSyncQryEventReqBo shipEvent = new IUocEsSyncQryEventReqBo();
            shipEvent.setIndexName(uocIndexConfig.getShipOrderIndex());
            shipEvent.setDataList(shipList);
            retList.add(shipEvent);
        }
        if (ObjectUtil.isNotEmpty(inspOrderId)) {
            List<IUocEsSyncQryReqBo> inspList = new ArrayList<>();
            IUocEsSyncQryReqBo insp = new IUocEsSyncQryReqBo();
            insp.setOrderId(orderId);
            insp.setObjId(inspOrderId);
            insp.setSysTenantId(sysTenantId);
            inspList.add(insp);
            IUocEsSyncQryEventReqBo inspEvent = new IUocEsSyncQryEventReqBo();
            inspEvent.setIndexName(uocIndexConfig.getInspOrderIndex());
            inspEvent.setDataList(inspList);
            retList.add(inspEvent);
        }
        List<IUocEsSyncQryReqBo> saleList = new ArrayList<>();
        IUocEsSyncQryReqBo sale = new IUocEsSyncQryReqBo();
        sale.setOrderId(orderId);
        sale.setObjId(saleOrderId);
        sale.setSysTenantId(sysTenantId);
        saleList.add(sale);
        IUocEsSyncQryEventReqBo saleEvent = new IUocEsSyncQryEventReqBo();
        saleEvent.setIndexName(uocIndexConfig.getSaleOrderIndex());
        saleEvent.setDataList(saleList);
        retList.add(saleEvent);

//        List<IUocEsSyncQryReqBo> implList = new ArrayList<>();
//        IUocEsSyncQryReqBo impl = new IUocEsSyncQryReqBo();
//        impl.setOrderId(orderId);
//        impl.setObjId(implOrderId);
//        implList.add(impl);
//        IUocEsSyncQryEventReqBo implEvent = new IUocEsSyncQryEventReqBo();
//        implEvent.setIndexName(uocIndexConfig.getImplOrderIndex());
//        implEvent.setDataList(implList);
//        retList.add(implEvent);
        return retList;
    }

    @Override
    public String getEvent() {
        return UocEventConstant.UOC_INSP_ORDER_SYNC;
    }
}


