/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.oc.model.sysdictionary.impl;

import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.base.bo.BasePageRspBo;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.model.sysdictionary.IUocSysDictionaryModel;
import com.tydic.dyc.oc.model.sysdictionary.UocSysDictionaryDo;
import com.tydic.dyc.oc.model.sysdictionary.qrybo.UocSysDictionaryQryBo;
import com.tydic.dyc.oc.repository.UocSysDictionaryRepository;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class IUocSysDictionaryModelImpl
implements IUocSysDictionaryModel {
    private static final Logger log = LoggerFactory.getLogger(IUocSysDictionaryModelImpl.class);
    @Autowired
    private UocSysDictionaryRepository uocSysDictionaryRepository;

    @Override
    public List<UocSysDictionaryDo> qryDicList(UocSysDictionaryQryBo reqBO) {
        if (null == reqBO) {
            throw new BaseBusinessException("102001", "\u65b9\u6cd5\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return this.uocSysDictionaryRepository.qryDicList(reqBO);
    }

    @Override
    public List<UocSysDictionaryDo> qryDicListByPCodes(UocSysDictionaryQryBo reqBO) {
        return this.uocSysDictionaryRepository.qryDicListByPCodes(reqBO);
    }

    @Override
    public Map<String, Map<String, String>> getDictionaryMap(UocSysDictionaryQryBo reqBO) {
        List<UocSysDictionaryDo> uocSysDictionaryDos = this.uocSysDictionaryRepository.qryDicListByPCodes(reqBO);
        HashMap<String, Map<String, String>> dicPCodeAndCodeMap = new HashMap<String, Map<String, String>>();
        if (ObjectUtil.isNotEmpty(uocSysDictionaryDos)) {
            Map<String, List<UocSysDictionaryDo>> dicPCodeMap = uocSysDictionaryDos.stream().collect(Collectors.groupingBy(UocSysDictionaryDo::getPCode));
            for (String pCode : dicPCodeMap.keySet()) {
                Map<String, String> dicCodeMap = dicPCodeMap.get(pCode).stream().collect(Collectors.toMap(UocSysDictionaryDo::getCode, UocSysDictionaryDo::getDescrip, (k1, k2) -> k2));
                dicPCodeAndCodeMap.put(pCode, dicCodeMap);
            }
        }
        return dicPCodeAndCodeMap;
    }

    @Override
    public UocSysDictionaryDo getModelBy(UocSysDictionaryQryBo reqBO) {
        if (null == reqBO) {
            throw new BaseBusinessException("102001", "\u65b9\u6cd5\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return this.uocSysDictionaryRepository.getModelBy(reqBO);
    }

    @Override
    public UocSysDictionaryDo createDic(UocSysDictionaryDo uocSysDictionaryDo) {
        if (null == uocSysDictionaryDo) {
            throw new BaseBusinessException("102001", "\u65b9\u6cd5\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        UocSysDictionaryQryBo qryBo = new UocSysDictionaryQryBo();
        qryBo.setPCode(uocSysDictionaryDo.getPCode());
        qryBo.setCode(uocSysDictionaryDo.getCode());
        UocSysDictionaryDo model = this.getModelBy(qryBo);
        if (null != model) {
            throw new BaseBusinessException("102002", "\u65b9\u6cd5\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return this.uocSysDictionaryRepository.createDic(uocSysDictionaryDo);
    }

    @Override
    public UocSysDictionaryDo updateDic(UocSysDictionaryDo uocSysDictionaryDo) {
        if (null == uocSysDictionaryDo) {
            throw new BaseBusinessException("102001", "\u65b9\u6cd5\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return this.uocSysDictionaryRepository.updateDic(uocSysDictionaryDo);
    }

    @Override
    public UocSysDictionaryQryBo deleteDic(UocSysDictionaryQryBo reqBO) {
        if (null == reqBO) {
            throw new BaseBusinessException("102001", "\u65b9\u6cd5\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return this.uocSysDictionaryRepository.deleteDic(reqBO);
    }

    @Override
    public List<UocSysDictionaryDo> getModelAmbiguousBy(UocSysDictionaryQryBo reqBO) {
        return this.uocSysDictionaryRepository.getModelAmbiguousBy(reqBO);
    }

    @Override
    public BasePageRspBo<UocSysDictionaryDo> getModelByPage(UocSysDictionaryQryBo reqBO) {
        return this.uocSysDictionaryRepository.getModelByPage(reqBO);
    }
}

