/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.oc.config;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.components.virgo.UocGetRuleVirgoUtil;
import com.tydic.dyc.oc.components.virgo.UocVirgoTriggerReqBo;
import com.tydic.dyc.oc.components.virgo.UocVirgoTriggerRspBo;
import com.tydic.dyc.oc.config.UocInitParamVirgoBo;
import com.tydic.dyc.oc.config.UocInitStateVirgoBo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;

@Configuration
public class UocInitConfig {
    private static final Logger log = LoggerFactory.getLogger(UocInitConfig.class);
    @Value(value="${uoc.init.initState:}")
    private String initState;
    private static final String SEPARATOR = "-";
    @Autowired
    private UocGetRuleVirgoUtil uocGetRuleVirgoUtil;
    @Value(value="${virgo.service.code.order.state:UOC_GET_ORDER_STATUS}")
    private String serviceCode;

    public String getStateByTachecode(String tacheCode, Integer objType, Long sysTenantId) {
        if (ObjectUtil.isEmpty((Object)tacheCode)) {
            throw new BaseBusinessException("100001", "\u73af\u8282\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)objType)) {
            throw new BaseBusinessException("100001", "\u4e1a\u52a1\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return this.getState(tacheCode, objType);
    }

    private String getState(String tacheCode, Integer objType) {
        String ruleId = this.uocGetRuleVirgoUtil.getRuleId(this.serviceCode);
        UocVirgoTriggerReqBo uocVirgoTriggerReqBo = new UocVirgoTriggerReqBo();
        uocVirgoTriggerReqBo.setRuleId(ruleId);
        UocInitParamVirgoBo uocInitParamVirgoBo = new UocInitParamVirgoBo();
        uocInitParamVirgoBo.setTacheCode(tacheCode);
        uocInitParamVirgoBo.setObjType(objType.toString());
        uocInitParamVirgoBo.setProperties(this.initState);
        uocVirgoTriggerReqBo.setParams(JSON.toJSONString((Object)uocInitParamVirgoBo));
        UocVirgoTriggerRspBo uocVirgoTriggerRspBo = this.uocGetRuleVirgoUtil.trigger(uocVirgoTriggerReqBo);
        if (!"0000".equals(uocVirgoTriggerRspBo.getRespCode())) {
            throw new BaseBusinessException("100001", "\u89e6\u53d1\u89c4\u5219\u5931\u8d25");
        }
        if (ObjectUtil.isEmpty((Object)uocVirgoTriggerRspBo.getResult())) {
            throw new BaseBusinessException("100001", "\u89e6\u53d1\u89c4\u5219\u8fd4\u56de\u7ed3\u679c\u4e3a\u7a7a");
        }
        UocInitStateVirgoBo uocInitStateVirgoBo = (UocInitStateVirgoBo)JSON.parseObject((String)uocVirgoTriggerRspBo.getResult(), UocInitStateVirgoBo.class);
        if (null == uocInitStateVirgoBo || ObjectUtil.isEmpty((Object)uocInitStateVirgoBo.getState())) {
            return null;
        }
        log.info("\u83b7\u53d6\u5230\u72b6\u6001:{}", (Object)uocInitStateVirgoBo.getState());
        return uocInitStateVirgoBo.getState();
    }
}

