/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.oc.service.order;

import cn.hutool.core.convert.Convert;
import com.tydic.dyc.base.bo.BasePageRspBo;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.model.order.IUocOrderModel;
import com.tydic.dyc.oc.model.order.qrybo.UocConfEffectiveQryBo;
import com.tydic.dyc.oc.model.order.sub.UocConfEffective;
import com.tydic.dyc.oc.model.sysdictionary.IUocSysDictionaryModel;
import com.tydic.dyc.oc.model.sysdictionary.qrybo.UocSysDictionaryQryBo;
import com.tydic.dyc.oc.service.order.UocProOrderEffectiveDealService;
import com.tydic.dyc.oc.service.order.bo.UocProOrderEffectiveDealReqBo;
import com.tydic.dyc.oc.service.order.bo.UocProOrderEffectiveDealRspBo;
import com.tydic.dyc.oc.utils.IdUtil;
import com.tydic.dyc.oc.utils.UocRu;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"OC_GROUP_DEV/3.0.0/com.tydic.dyc.oc.service.order.UocProOrderEffectiveDealService"})
public class UocProOrderEffectiveDealServiceImpl
implements UocProOrderEffectiveDealService {
    @Autowired
    private IUocOrderModel iUocOrderModel;
    @Autowired
    private IUocSysDictionaryModel iUocSysDictionaryModel;

    @PostMapping(value={"dealOrderEffective"})
    public UocProOrderEffectiveDealRspBo dealOrderEffective(@RequestBody UocProOrderEffectiveDealReqBo reqBo) {
        UocProOrderEffectiveDealRspBo rspBo = UocRu.success(UocProOrderEffectiveDealRspBo.class);
        this.validateArgs(reqBo);
        if (null != reqBo.getIsDelete() && reqBo.getIsDelete().booleanValue()) {
            this.deleteOrderEffective(reqBo);
            return rspBo;
        }
        if (null == reqBo.getEffectiveId() || 0L == reqBo.getEffectiveId()) {
            this.addOrderEffective(reqBo);
        } else {
            this.modifyOrderEffective(reqBo);
        }
        return rspBo;
    }

    private void deleteOrderEffective(UocProOrderEffectiveDealReqBo reqBo) {
        UocConfEffective uocConfEffective = new UocConfEffective();
        uocConfEffective.setEffectiveId(reqBo.getEffectiveId());
        UocConfEffective modelBy = this.iUocOrderModel.getConfEffectiveBy(uocConfEffective);
        if (null == modelBy) {
            throw new BaseBusinessException("101018", "\u5165\u53c2[effectiveId]\u67e5\u8be2\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u5220\u9664");
        }
        if ("0".equals(modelBy.getSourceCode())) {
            throw new BaseBusinessException("101018", "\u8be5\u6570\u636e\u4e3a\u7cfb\u7edf\u9884\u8bbe\u503c\uff0c\u4e0d\u5141\u8bb8\u5220\u9664");
        }
        this.iUocOrderModel.deleteConfEffective(uocConfEffective);
    }

    private void modifyOrderEffective(UocProOrderEffectiveDealReqBo reqBo) {
        if ("2".equals(reqBo.getBusinessTypeCode()) && UocDicConstant.ORDER_SOURCE.E_COMMERCE_IMPORT.equals(Convert.toInt((Object)reqBo.getBusinessTypeCode()))) {
            UocConfEffectiveQryBo uocConfEffective = new UocConfEffectiveQryBo();
            uocConfEffective.setEffectiveCode("1");
            uocConfEffective.setBusinessTypeCode(Convert.toStr((Object)UocDicConstant.ORDER_SOURCE.E_COMMERCE_IMPORT));
            uocConfEffective.setOrderBy("aging");
            uocConfEffective.setPageNo(1);
            uocConfEffective.setPageSize(1);
            BasePageRspBo<UocConfEffective> uocConfEffectiveBasePageRspBo = this.iUocOrderModel.qryListPageConfEffective(uocConfEffective);
            if (CollectionUtils.isEmpty((Collection)uocConfEffectiveBasePageRspBo.getRows())) {
                throw new BaseBusinessException("101018", "\u7531\u4e8e\u7535\u5546\u9884\u5360\u5e93\u5b58\u65f6\u9650\u6ca1\u6709\u8bbe\u7f6e\uff0c\u65e0\u6cd5\u914d\u7f6e \u7535\u5546\u91c7\u8d2d \u7684 \u8ba2\u5355\u786e\u8ba4\u4ed8\u6b3e\u65f6\u9650");
            }
            if (0L < ((UocConfEffective)uocConfEffectiveBasePageRspBo.getRows().get(0)).getAging() && reqBo.getAging() > ((UocConfEffective)uocConfEffectiveBasePageRspBo.getRows().get(0)).getAging()) {
                throw new BaseBusinessException("101018", "\u53ef\u8bbe\u7f6e\u7684\u65f6\u9650\u8303\u56f4\u5728" + this.formatDuring(((UocConfEffective)uocConfEffectiveBasePageRspBo.getRows().get(0)).getAging()) + "\u4e4b\u5185\uff1b");
            }
        }
        UocConfEffective effective = new UocConfEffective();
        effective.setAging(reqBo.getAging());
        effective.setOperatingTime(new Date());
        effective.setOperatorId(String.valueOf(reqBo.getUserId()));
        effective.setOperatorName(reqBo.getUsername());
        effective.setEffectiveId(reqBo.getEffectiveId());
        int updateBy = this.iUocOrderModel.updateEffectiveConfById(effective);
        if (updateBy != 1) {
            throw new BaseBusinessException("101018", "\u5165\u53c2[effectiveId]\u4e0d\u5bf9\uff0c\u5bfc\u81f4\u4fee\u6539\u5185\u5bb9\u4e0d\u5bf9");
        }
    }

    private void addOrderEffective(UocProOrderEffectiveDealReqBo reqBo) {
        String effectiveName = this.checkCodeCorrect(reqBo);
        UocConfEffectiveQryBo uocConfEffectiveQryBo = new UocConfEffectiveQryBo();
        UocConfEffective uocConfEffective = new UocConfEffective();
        uocConfEffective.setEffectiveCode(reqBo.getEffectiveCode());
        uocConfEffectiveQryBo.setEffectiveCode(reqBo.getEffectiveCode());
        if (!"2".equals(reqBo.getEffectiveCode())) {
            if ("1".equals(reqBo.getEffectiveCode()) && !UocDicConstant.ORDER_SOURCE.E_COMMERCE_IMPORT.equals(Convert.toInt((Object)reqBo.getBusinessTypeCode()))) {
                throw new BaseBusinessException("101018", "\u5165\u53c2[businessTypeCode]\u4e0d\u5141\u8bb8\u589e\u52a0\u65f6\u6548\u914d\u7f6e");
            }
            uocConfEffective.setSupplierNo(reqBo.getSupplierNo());
            uocConfEffectiveQryBo.setSupplierNo(reqBo.getSupplierNo());
            int checkBy = this.iUocOrderModel.getCheckConfEffectiveBy(uocConfEffectiveQryBo);
            if (checkBy > 0) {
                throw new BaseBusinessException("101018", "\u5df2\u5b58\u5728\u8be5\u7535\u5546\u7684" + effectiveName + "\uff0c\u8bf7\u91cd\u65b0\u8bbe\u7f6e\u3002");
            }
        } else {
            throw new BaseBusinessException("101018", "\u5165\u53c2[effectiveCode]\u4e0d\u5141\u8bb8\u589e\u52a0\u65f6\u6548\u914d\u7f6e");
        }
        uocConfEffective.setSupplierName(reqBo.getSupplierName());
        uocConfEffective.setEffectiveId(IdUtil.nextId());
        uocConfEffective.setBusinessTypeCode(reqBo.getBusinessTypeCode());
        uocConfEffective.setAging(reqBo.getAging());
        uocConfEffective.setSourceCode(reqBo.getSourceCode());
        uocConfEffective.setOperatingTime(new Date());
        uocConfEffective.setOperatorId(String.valueOf(reqBo.getUserId()));
        uocConfEffective.setOperatorName(reqBo.getUsername());
        this.iUocOrderModel.addConfEffective(uocConfEffective);
    }

    private String checkCodeCorrect(UocProOrderEffectiveDealReqBo reqBo) {
        ArrayList<String> pCodes = new ArrayList<String>();
        pCodes.add("EFFECTIVE_CODE");
        pCodes.add("UOC_SALE_ORDER_SOURCE");
        pCodes.add("SOURCE_CODE");
        UocSysDictionaryQryBo uocSysDictionaryQryBo = new UocSysDictionaryQryBo();
        uocSysDictionaryQryBo.setSysTenantId(reqBo.getSysTenantId());
        uocSysDictionaryQryBo.setPCodes(pCodes);
        Map<String, Map<String, String>> dictionaryMap = this.iUocSysDictionaryModel.getDictionaryMap(uocSysDictionaryQryBo);
        Map<String, String> orderSource = dictionaryMap.get("UOC_SALE_ORDER_SOURCE");
        if (!orderSource.containsKey(reqBo.getBusinessTypeCode())) {
            throw new BaseBusinessException("100001", "\u5165\u53c2[businessTypeCode]\u4e0d\u5408\u6cd5");
        }
        Map<String, String> sourceCode = dictionaryMap.get("SOURCE_CODE");
        if (!sourceCode.containsKey(reqBo.getSourceCode())) {
            throw new BaseBusinessException("100001", "\u5165\u53c2[sourceCode]\u4e0d\u5408\u6cd5");
        }
        Map<String, String> effectiveCode = dictionaryMap.get("EFFECTIVE_CODE");
        if (!effectiveCode.containsKey(reqBo.getEffectiveCode())) {
            throw new BaseBusinessException("100001", "\u5165\u53c2[effectiveCode]\u4e0d\u5408\u6cd5");
        }
        String effectiveName = effectiveCode.get(reqBo.getEffectiveCode());
        return effectiveName;
    }

    private String formatDuring(long aging) {
        long days = aging / 86400000L;
        long hours = aging % 86400000L / 3600000L;
        long minutes = aging % 3600000L / 60000L;
        return days + "\u5929" + hours + "\u5c0f\u65f6" + minutes + "\u5206";
    }

    private void validateArgs(UocProOrderEffectiveDealReqBo reqBo) {
        if (null == reqBo) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null != reqBo.getIsDelete() && reqBo.getIsDelete().booleanValue()) {
            if (null == reqBo.getEffectiveId() || 0L == reqBo.getEffectiveId()) {
                throw new BaseBusinessException("100001", "\u5165\u53c2\u5220\u9664[effectiveId]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            return;
        }
        if (null == reqBo.getEffectiveId() || 0L == reqBo.getEffectiveId()) {
            if (!StringUtils.hasText((String)reqBo.getEffectiveCode())) {
                throw new BaseBusinessException("100001", "\u5165\u53c2\u65b0\u589e[effectiveCode]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (!StringUtils.hasText((String)reqBo.getBusinessTypeCode())) {
                throw new BaseBusinessException("100001", "\u5165\u53c2\u65b0\u589e[businessTypeCode]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (!StringUtils.hasText((String)reqBo.getSourceCode())) {
                throw new BaseBusinessException("100001", "\u5165\u53c2\u65b0\u589e[sourceCode]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (!"2".equals(reqBo.getEffectiveCode())) {
                if (!StringUtils.hasText((String)reqBo.getSupplierNo())) {
                    throw new BaseBusinessException("100001", "\u5165\u53c2\u65b0\u589e[supplierNo]\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (!StringUtils.hasText((String)reqBo.getSupplierName())) {
                    throw new BaseBusinessException("100001", "\u5165\u53c2\u65b0\u589e[supplierName]\u4e0d\u80fd\u4e3a\u7a7a");
                }
            }
        }
        if (null == reqBo.getAging() || 0L > reqBo.getAging()) {
            throw new BaseBusinessException("100001", "\u5165\u53c2[aging]\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u4e14\u5927\u4e8e\u7b49\u4e8e0");
        }
    }
}

