/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.oc.service.saleorder;

import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo;
import com.tydic.dyc.oc.service.saleorder.UocSaleOrderRelateContractService;
import com.tydic.dyc.oc.service.saleorder.bo.UocSaleOrderRelateContractServiceReqBo;
import com.tydic.dyc.oc.service.saleorder.bo.UocSaleOrderRelateContractServiceRspBo;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"OC_GROUP_DEV/3.0.0/com.tydic.dyc.oc.service.saleorder.UocSaleOrderRelateContractService"})
public class UocSaleOrderRelateContractServiceImpl
implements UocSaleOrderRelateContractService {
    @Autowired
    private IUocSaleOrderModel iUocSaleOrderModel;

    @PostMapping(value={"relateContract"})
    public UocSaleOrderRelateContractServiceRspBo relateContract(@RequestBody UocSaleOrderRelateContractServiceReqBo reqBo) {
        this.verifyParam(reqBo);
        UocSaleOrderDo uocSaleOrderDo = new UocSaleOrderDo();
        uocSaleOrderDo.setOrderId(reqBo.getOrderId());
        uocSaleOrderDo.setSaleOrderId(reqBo.getSaleOrderId());
        UocSaleOrderDo saleOrderMain = this.iUocSaleOrderModel.getSaleOrderMain(uocSaleOrderDo);
        if (saleOrderMain == null) {
            throw new BaseBusinessException("100001", "\u672a\u6839\u636e\u5355\u636eid\u67e5\u627e\u5230\u9500\u552e\u5355\u4fe1\u606f");
        }
        if (!UocDicConstant.ORDER_SOURCE.SELF_SUPPORT_PRODUCT.equals(saleOrderMain.getOrderSource())) {
            throw new BaseBusinessException("100001", "\u8ba2\u5355\u7c7b\u578b\u9519\u8bef\uff0c\u53ea\u80fd\u5173\u8054\u5230\u65e0\u534f\u8bae\u8ba2\u5355");
        }
        if (StringUtils.isNotBlank((CharSequence)saleOrderMain.getContractNo())) {
            throw new BaseBusinessException("100001", "\u64cd\u4f5c\u5931\u8d25\uff0c\u8be5\u8ba2\u5355\u5df2\u5173\u8054\u5230\u4e00\u4e2a\u5408\u540c");
        }
        saleOrderMain.setContractNo(reqBo.getContractId());
        this.iUocSaleOrderModel.modifySaleOrderMain(saleOrderMain);
        UocSaleOrderRelateContractServiceRspBo rspBo = new UocSaleOrderRelateContractServiceRspBo();
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        return rspBo;
    }

    private void verifyParam(UocSaleOrderRelateContractServiceReqBo reqBo) {
        if (reqBo == null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBo.getOrderId() || 0L == reqBo.getOrderId()) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[orderId]\u5c5e\u6027\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBo.getSaleOrderId() || 0L == reqBo.getSaleOrderId()) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[saleVoucherId]\u5c5e\u6027\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)reqBo.getContractId())) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[contractId]\u5c5e\u6027\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

