/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.oc.service.shiporder;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.constants.UocAttachementTypeConstants;
import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.model.common.IUocCommonModel;
import com.tydic.dyc.oc.model.common.UocCommonDo;
import com.tydic.dyc.oc.model.order.sub.UocOrderAccessory;
import com.tydic.dyc.oc.model.shiporder.IUocShipOrderModel;
import com.tydic.dyc.oc.model.shiporder.UocShipOrderDo;
import com.tydic.dyc.oc.service.common.bo.UocBaseOrderAccessoryAddBo;
import com.tydic.dyc.oc.service.saleorder.bo.UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo;
import com.tydic.dyc.oc.service.shiporder.UocShipOrderArrivaRegistService;
import com.tydic.dyc.oc.service.shiporder.bo.UocShipOrderArrivaRegistReqBo;
import com.tydic.dyc.oc.service.shiporder.bo.UocShipOrderArrivaRegistRspBo;
import com.tydic.dyc.oc.utils.IdUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"OC_GROUP_DEV/3.0.0/com.tydic.dyc.oc.service.shiporder.UocShipOrderArrivaRegistService"})
public class UocShipOrderArrivaRegistServiceImpl
implements UocShipOrderArrivaRegistService {
    @Autowired
    private IUocShipOrderModel iUocShipOrderModel;
    @Autowired
    private IUocCommonModel iUocCommonModel;

    @PostMapping(value={"dealShipOrderArrivaRegist"})
    public UocShipOrderArrivaRegistRspBo dealShipOrderArrivaRegist(@RequestBody UocShipOrderArrivaRegistReqBo reqBo) {
        this.verifyParam(reqBo);
        this.updateShipOrderInfos(reqBo);
        this.submitShipOrderTask(reqBo);
        UocShipOrderArrivaRegistRspBo rspBo = new UocShipOrderArrivaRegistRspBo();
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        rspBo.setSysTenantId(reqBo.getSysTenantId());
        return rspBo;
    }

    private void submitShipOrderTask(UocShipOrderArrivaRegistReqBo reqBo) {
        UocCommonDo uocCommonDo = new UocCommonDo();
        ArrayList<UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo> taskInfos = new ArrayList<UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo>();
        reqBo.getTaskIds().forEach(taskId -> {
            UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo taskBo = new UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo();
            taskBo.setTaskId(taskId);
            taskInfos.add(taskBo);
        });
        uocCommonDo.setCompleteTaskInfos(taskInfos);
        uocCommonDo.setUserId(reqBo.getUserId());
        uocCommonDo.setOrderId(reqBo.getOrderId());
        this.iUocCommonModel.dealTask(uocCommonDo);
    }

    private void updateShipOrderInfos(UocShipOrderArrivaRegistReqBo reqBo) {
        UocShipOrderDo updateUocShipOrderDo = (UocShipOrderDo)JSONObject.parseObject((String)JSON.toJSONString((Object)reqBo), UocShipOrderDo.class);
        updateUocShipOrderDo.setUpdateTime(new Date());
        updateUocShipOrderDo.setUpdateOperId(reqBo.getUserId().toString());
        if (!CollectionUtils.isEmpty((Collection)reqBo.getOrderAccessoryList())) {
            ArrayList<UocOrderAccessory> orderAccessoryBoList = new ArrayList<UocOrderAccessory>();
            for (Long shipOrderId : reqBo.getShipOrderIdList()) {
                for (UocBaseOrderAccessoryAddBo uocBaseOrderAccessoryAddBo : reqBo.getOrderAccessoryList()) {
                    UocOrderAccessory uocOrderAccessory = (UocOrderAccessory)JSONObject.parseObject((String)JSON.toJSONString((Object)uocBaseOrderAccessoryAddBo), UocOrderAccessory.class);
                    uocOrderAccessory.setOrderId(reqBo.getOrderId());
                    uocOrderAccessory.setObjType(UocDicConstant.OBJ_TYPE.SHIP);
                    uocOrderAccessory.setCreateTime(new Date());
                    uocOrderAccessory.setCreateOperId(String.valueOf(reqBo.getUserId()));
                    uocOrderAccessory.setAttachmentType(UocAttachementTypeConstants.ARRIVAL_REGIST);
                    uocOrderAccessory.setId(IdUtil.nextId());
                    uocOrderAccessory.setObjId(shipOrderId);
                    orderAccessoryBoList.add(uocOrderAccessory);
                }
            }
            updateUocShipOrderDo.setOrderAccessoryBoList(orderAccessoryBoList);
        }
        updateUocShipOrderDo.setShipOrderState("FH_FH_DQR");
        this.iUocShipOrderModel.modifyShipOrderMain(updateUocShipOrderDo);
    }

    private void verifyParam(UocShipOrderArrivaRegistReqBo reqBo) {
        if (null == reqBo) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBo.getOrderId()) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u8ba2\u5355ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBo.getSaleOrderId()) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u9500\u552e\u5355ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (CollectionUtils.isEmpty((Collection)reqBo.getShipOrderIdList())) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u53d1\u8d27\u5355ID\u6570\u7ec4\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBo.getUserId()) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u7528\u6237ID\u4e3a\u7a7a");
        }
        if (CollectionUtils.isEmpty((Collection)reqBo.getTaskIds())) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u53d1\u8d27\u5355\u4efb\u52a1ID\u6570\u7ec4\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

