package com.tydic.dyc.oc.service.domainservice;

import com.tydic.dyc.base.constants.BaseRspConstant;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.constants.UocConstant;
import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.constants.UocRspConstants;
import com.tydic.dyc.oc.constants.UocStateConstants;
import com.tydic.dyc.oc.model.chngorder.IUocChngOrderModel;
import com.tydic.dyc.oc.model.chngorder.UocChngOrderDo;
import com.tydic.dyc.oc.model.chngorder.sub.UocChngOrderItemObj;
import com.tydic.dyc.oc.model.chngorder.sub.UocChngOrderObj;
import com.tydic.dyc.oc.model.common.IUocCommonModel;
import com.tydic.dyc.oc.model.common.UocCommonDo;
import com.tydic.dyc.oc.model.order.sub.UocOrderAccessory;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo;
import com.tydic.dyc.oc.service.common.bo.UocBaseOrderAccessoryAddBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocAdjustPriceOrderCreateReqBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocAdjustPriceOrderCreateReqItemBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocAdjustPriceOrderCreateRspBo;
import com.tydic.dyc.oc.service.saleorder.bo.UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo;
import com.tydic.dyc.oc.utils.IdUtil;
import com.tydic.dyc.oc.utils.UocRu;
import lombok.extern.ohaotian.HTServiceImpl;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 描述: 〈领域服务-销售单调价实现〉
 * @author : yuhao
 * @date : 2022/7/25 10:33
 */
@HTServiceImpl
public class UocAdjustPriceOrderCreateServiceImpl implements UocAdjustPriceOrderCreateService {
    @Autowired
    private IUocChngOrderModel iUocChngOrderModel;

    @Autowired
    private IUocCommonModel iUocCommonModel;

    @Autowired
    IUocSaleOrderModel iUocSaleOrderModel;

    @Override
    public UocAdjustPriceOrderCreateRspBo createAdjustPriceOrder(UocAdjustPriceOrderCreateReqBo reqBo) {

        //参数校验
        this.verifyParam(reqBo);
        //判断是否需要调价
        if(UocConstant.ADJUST_FLAG.YES.equals(reqBo.getAdjustFlag())){
            //调价
            //生成变更单
            Long changeOrderId = this.createAdjustChangeOrder(reqBo);
            //更新销售单主体信息
            this.updateSaleOrderMainInfo(reqBo,UocConstant.ADJUST_PRICE.MIDDLE_ADJUST);
            //提交订单任务
            this.submitProcessTask(reqBo);

            UocAdjustPriceOrderCreateRspBo rspBo = new UocAdjustPriceOrderCreateRspBo();
            rspBo.setChngOrderId(changeOrderId);
            rspBo.setRespCode(BaseRspConstant.RSP_CODE_SUCCESS);
            rspBo.setRespDesc(BaseRspConstant.RSP_DESC_SUCCESS);
            return rspBo;
        }else if(UocConstant.ADJUST_FLAG.NO.equals(reqBo.getAdjustFlag())){
            //跳过调价
            //更新销售单主体信息
            this.updateSaleOrderMainInfo(reqBo,UocConstant.ADJUST_PRICE.NO_ADJUST);
            //提交订单任务
            this.submitProcessTask(reqBo);

            UocAdjustPriceOrderCreateRspBo rspBo = new UocAdjustPriceOrderCreateRspBo();
            rspBo.setRespCode(BaseRspConstant.RSP_CODE_SUCCESS);
            rspBo.setRespDesc(BaseRspConstant.RSP_DESC_SUCCESS);
            return rspBo;
        }else{
            //错误的调价标识
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "错误的调价标识，无法识别");
        }
    }

    /**
     * 提交订单任务
     * @param reqBo
     */
    private void submitProcessTask(UocAdjustPriceOrderCreateReqBo reqBo){
        UocCommonDo uocCommonDo = new UocCommonDo();
        List<UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo> taskList = new ArrayList<>();
        UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo task = new UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo();
        task.setTaskId(reqBo.getTaskId());
        taskList.add(task);
        uocCommonDo.setCompleteTaskInfos(taskList);
        uocCommonDo.setUserId(reqBo.getUserId());
        uocCommonDo.setOrderId(reqBo.getOrderId());
        this.iUocCommonModel.dealTask(uocCommonDo);
    }

    /**
     * 更新销售单主体信息
     * @param reqBo
     */
    private void updateSaleOrderMainInfo(UocAdjustPriceOrderCreateReqBo reqBo,Integer adjustPrice){
        UocSaleOrderDo updateUocSaleOrderDo = new UocSaleOrderDo();
        updateUocSaleOrderDo.setSaleOrderId(reqBo.getSaleOrderId());
        updateUocSaleOrderDo.setOrderId(reqBo.getOrderId());
        updateUocSaleOrderDo.setAdjustPrice(adjustPrice);
        updateUocSaleOrderDo.setAdjustPriceOperId(String.valueOf(reqBo.getUserId()));
        updateUocSaleOrderDo.setAdjustPriceOperName(reqBo.getName());
        updateUocSaleOrderDo.setAdjustPriceTime(new Date());
        this.iUocSaleOrderModel.modifySaleOrderMain(updateUocSaleOrderDo);
    }

    /**
     * 生成调价变更单
     */
    private Long createAdjustChangeOrder(UocAdjustPriceOrderCreateReqBo reqBo){

        UocChngOrderDo uocChngOrderDo = new UocChngOrderDo();
        Long changeOrderId = IdUtil.nextId();
        //设置变更单信息
        uocChngOrderDo.setOrderId(reqBo.getOrderId());
        uocChngOrderDo.setChngOrderId(changeOrderId);
        uocChngOrderDo.setCreateOperId(String.valueOf(reqBo.getUserId()));
        uocChngOrderDo.setCreateOperName(reqBo.getName());
        uocChngOrderDo.setCreateTime(new Date());
        uocChngOrderDo.setRemark(reqBo.getRemark());
        uocChngOrderDo.setBusiType(UocConstant.BUSI_TYPE.PRICE_CHG);
        //设置变更对象信息
        Long changeOrderObjectId = IdUtil.nextId();
        List<UocChngOrderObj> uocChngOrderObjList = new ArrayList<>();
        UocChngOrderObj uocChngOrderObj = new UocChngOrderObj();
        uocChngOrderObj.setOrderId(reqBo.getOrderId());
        uocChngOrderObj.setChngOrderObjId(changeOrderObjectId);
        uocChngOrderObj.setChngOrderId(changeOrderId);
        uocChngOrderObj.setChngType(UocConstant.BUSI_TYPE.PRICE_CHG);
        uocChngOrderObj.setSaleOrderId(reqBo.getSaleOrderId());
        uocChngOrderObj.setCreateTime(new Date());
        uocChngOrderObj.setCreateOperId(String.valueOf(reqBo.getUserId()));
        // 设置变更对象明细
        List<UocChngOrderItemObj> uocChngOrderItemObjList = new ArrayList<>();
        for(UocAdjustPriceOrderCreateReqItemBo uocAdjustPriceOrderCreateReqItemBo: reqBo.getSaleItemList()){
            UocChngOrderItemObj uocChngOrderItemObj = new UocChngOrderItemObj();
            uocChngOrderItemObj.setOrderId(reqBo.getOrderId());
            uocChngOrderItemObj.setChngOrderId(changeOrderId);
            uocChngOrderItemObj.setChngOrderObjId(changeOrderObjectId);
            uocChngOrderItemObj.setId(IdUtil.nextId());
            uocChngOrderItemObj.setOrderItemId(uocAdjustPriceOrderCreateReqItemBo.getOrderItemId());
            uocChngOrderItemObj.setSaleOrderItemId(uocAdjustPriceOrderCreateReqItemBo.getSaleOrderItemId());
            uocChngOrderItemObj.setChngType(UocConstant.BUSI_TYPE.PRICE_CHG);
            uocChngOrderItemObj.setChngFee(uocAdjustPriceOrderCreateReqItemBo.getAdjustPrice());
            uocChngOrderItemObj.setCreateOperId(String.valueOf(reqBo.getUserId()));
            uocChngOrderItemObj.setCreateTime(new Date());
            uocChngOrderItemObjList.add(uocChngOrderItemObj);
        }
        uocChngOrderObj.setUocChngOrderItemObjList(uocChngOrderItemObjList);
        uocChngOrderObjList.add(uocChngOrderObj);
        uocChngOrderDo.setUocChngOrderObjList(uocChngOrderObjList);

        // 如果存在附件，设置附件信息
        if (!CollectionUtils.isEmpty(reqBo.getOrderAccessoryBoList())) {
            List<UocOrderAccessory> orderAccessoryBoList = new ArrayList<>();
            for(UocBaseOrderAccessoryAddBo uocBaseOrderAccessoryAddBo:reqBo.getOrderAccessoryBoList()){
                UocOrderAccessory uocOrderAccessory = new UocOrderAccessory();
                BeanUtils.copyProperties(uocBaseOrderAccessoryAddBo,uocOrderAccessory);
                uocOrderAccessory.setOrderId(reqBo.getOrderId());
                uocOrderAccessory.setId(IdUtil.nextId());
                uocOrderAccessory.setCreateOperId(reqBo.getUserId().toString());
                uocOrderAccessory.setCreateTime(new Date());
                uocOrderAccessory.setObjId(uocChngOrderDo.getChngOrderId());
                uocOrderAccessory.setObjType(UocDicConstant.OBJ_TYPE.CHNG);
                uocOrderAccessory.setAttachmentType(UocDicConstant.OBJ_TYPE.CHNG);
                orderAccessoryBoList.add(uocOrderAccessory);
            }
            uocChngOrderDo.setOrderAccessoryBoList(orderAccessoryBoList);
        }

        this.iUocChngOrderModel.createChngOrder(uocChngOrderDo);

        return changeOrderId;
    }

    /**
     * 入参校验
     */
    private void verifyParam(UocAdjustPriceOrderCreateReqBo reqBo) {
        if (null == reqBo) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象为空");
        }
        if (null == reqBo.getUserId()) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参当前登录人ID为空");
        }
        if (StringUtils.isEmpty(reqBo.getName())) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参当前登录人名称为空");
        }
        if (null == reqBo.getAdjustFlag()) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参是否调价标识为空");
        }
        if (null == reqBo.getOrderId()) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参订单ID为空");
        }
        if (null == reqBo.getSaleOrderId()) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参销售单ID为空");
        }
        if (StringUtils.isEmpty(reqBo.getTaskId())) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参任务ID为空");
        }
    }
}
