package com.tydic.dyc.oc.service.saleorder;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.sun.org.apache.xpath.internal.operations.Bool;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.constants.UocConstant;
import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.constants.UocRspConstants;
import com.tydic.dyc.oc.constants.UocStateConstants;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderItemQryBo;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleOrderItem;
import com.tydic.dyc.oc.model.shiporder.IUocShipOrderModel;
import com.tydic.dyc.oc.model.shiporder.UocShipOrderDo;
import com.tydic.dyc.oc.model.shiporder.qrybo.UocShipOrderQryBo;
import com.tydic.dyc.oc.model.sysdictionary.IUocSysDictionaryModel;
import com.tydic.dyc.oc.service.saleorder.bo.UocAfterServiceTypeQryServiceReqBo;
import com.tydic.dyc.oc.service.saleorder.bo.UocAfterServiceTypeQryServiceRspAfsBo;
import com.tydic.dyc.oc.service.saleorder.bo.UocAfterServiceTypeQryServiceRspBo;
import com.tydic.dyc.oc.utils.UocRu;
import lombok.extern.ohaotian.HTServiceImpl;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.*;

/**
 * 描述: 〈领域服务-售后方式查询 实现〉
 * @author : yuhao
 * @date : 2022/8/1 11:05
 */
@HTServiceImpl
@Slf4j
public class UocAfterServiceTypeQryServiceImpl implements UocAfterServiceTypeQryService{
    @Autowired
    private IUocSaleOrderModel iUocSaleOrderModel;

    @Autowired
    private IUocSysDictionaryModel iUocSysDictionaryModel;

    @Autowired
    private IUocShipOrderModel iUocShipOrderModel;

    @Override
    public UocAfterServiceTypeQryServiceRspBo qryAfterServiceType(UocAfterServiceTypeQryServiceReqBo reqBo) {
        UocAfterServiceTypeQryServiceRspBo rspBo = UocRu.success(UocAfterServiceTypeQryServiceRspBo.class);
        rspBo.setServerTypes(new ArrayList<>());

        //查询到货时间
        UocShipOrderQryBo uocShipOrderQryBo = new UocShipOrderQryBo();
        uocShipOrderQryBo.setShipOrderId(reqBo.getShipOrderId());
        uocShipOrderQryBo.setOrderId(reqBo.getOrderId());
        UocShipOrderDo shipOrderById = iUocShipOrderModel.getShipOrderById(uocShipOrderQryBo);
        //如果到货时间为空 就判断为今天 即是可以退货的
        log.info("改发货单："+shipOrderById);
        Date arriveTime = shipOrderById.getArriveTime()==null?new Date():shipOrderById.getArriveTime();
        //计算有没有超过七天
        //为true代表超过七天 不支持退货
        boolean returnEffectFlag = (new Date().getTime() - arriveTime.getTime()) / (24 * 60 * 60 * 1000) >= 7;

        //参数校验
        validateArg(reqBo);
        //查询销售单明细信息
        List<UocSaleOrderItem> saleOrderItems = new ArrayList<>();
        List<Long> ordItemList = reqBo.getOrdItemList();
        for (Long saleOrderItemId : ordItemList) {
            UocSaleOrderItemQryBo uocSaleOrderItemQryBo = new UocSaleOrderItemQryBo();
            uocSaleOrderItemQryBo.setSaleOrderItemId(saleOrderItemId);
            List<UocSaleOrderItem> saleOrderItemList = iUocSaleOrderModel.getSaleOrderItemList(uocSaleOrderItemQryBo);
            if (CollectionUtil.isNotEmpty(saleOrderItemList)) {
                saleOrderItems.addAll(saleOrderItemList);
            }
        }
        if (CollectionUtil.isEmpty(saleOrderItems)) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "查询销售单明细对象属性为空");
        }
        ArrayList<Integer> afTypesList = new ArrayList<>();
        //计算售后类型
        for (UocSaleOrderItem saleOrderItem : saleOrderItems) {
            ArrayList<Integer> afTypesLists = new ArrayList<>();
            //已验收的发货单不支持退货处理
            if (ObjectUtil.isNotEmpty(saleOrderItem.getRejectAllowDate()) && !UocStateConstants.ShipOrder.FH_FH_YS.equals(shipOrderById.getShipOrderState())) {
                afTypesLists.add(UocConstant.AFTERORDER_SERVTYPE.RETURN);
            }
            if (ObjectUtil.isNotEmpty(saleOrderItem.getExchangeAllowDate())) {
                afTypesLists.add(UocConstant.AFTERORDER_SERVTYPE.CHANGE);
            }
            if (ObjectUtil.isNotEmpty(saleOrderItem.getMaintainAllowDate())) {
                afTypesLists.add(UocConstant.AFTERORDER_SERVTYPE.FIX);
            }
            if (CollectionUtil.isNotEmpty(afTypesList)) {
                Collection<Integer> intersection = CollectionUtil.intersection(afTypesList, afTypesLists);
                intersection.forEach(x->{
                    afTypesList.add(x);
                });
            } else {
                afTypesList.addAll(afTypesLists);
            }
        }
        //字典查询封装数据
        List<String> pCodes = new ArrayList<>();
        pCodes.add(UocDicConstant.SERVICE_TYPE.P_CODE);
        Map<String, Map<String, String>> dicMap = iUocSysDictionaryModel.getDictionaryMap(pCodes);
        Map<String, String> serviceMaps = dicMap.get(UocDicConstant.SERVICE_TYPE.P_CODE);
        afTypesList.stream().sorted(new Comparator<Integer>() {
            @Override
            public int compare(Integer o1, Integer o2) {
                return o1-o2;
            }
        }).forEach(integer->{
            UocAfterServiceTypeQryServiceRspAfsBo uocAfterServiceTypeQryServiceRspAfsBo = new UocAfterServiceTypeQryServiceRspAfsBo();
            uocAfterServiceTypeQryServiceRspAfsBo.setServerType(integer);
            uocAfterServiceTypeQryServiceRspAfsBo.setServerName(serviceMaps.get(integer.toString()));
            //默认为true
            uocAfterServiceTypeQryServiceRspAfsBo.setCanApply(Boolean.TRUE);
            //退货情况下特殊处理
            if (integer.equals(UocDicConstant.SERVICE_TYPE.RETURN_GOODS)) {
                uocAfterServiceTypeQryServiceRspAfsBo.setCanApply(returnEffectFlag?Boolean.FALSE:Boolean.TRUE);
                uocAfterServiceTypeQryServiceRspAfsBo.setServerDesc(returnEffectFlag?"支持7天无理由退货，已超过规定的退货时间":"");
            }
            rspBo.getServerTypes().add(uocAfterServiceTypeQryServiceRspAfsBo);
        });
        return rspBo;
    }

    private void validateArg(UocAfterServiceTypeQryServiceReqBo reqBo) {
        if (reqBo == null) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象[UocAfterServiceTypeQryServiceReqBo]不能为空");
        }
        if (ObjectUtil.isEmpty(reqBo.getOrdItemList())) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性[订单明细id列表]不能为空");
        }
    }
}
