package com.tydic.dyc.oc.components.notice;

import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.constants.UocRspConstants;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

/**
 * 标题:UocNoticeProcessorManager
 * 说明:
 * 时间:2022/4/15 11:34
 * 作者:田桂银
 */
@Component
@Slf4j
public class UocNoticeProcessorManager {


    /**
     * 在系统启动时，缓存数据查询实现类
     */
    private final Map<String, UocNoticeProcessor> manageMap = new ConcurrentHashMap<>();


    /**
     * 描述:注册实现类
     *
     * @param intObj 入参
     * @return void
     * @author tgy
     * @date 2022/3/1 12:50
     */
    public void register(UocNoticeProcessor intObj) {
        String noticeCode = intObj.noticeCode();

        Assert.notNull(intObj, "intObj can not be null");
        Assert.notNull(noticeCode, "noticeCode can not be null");

        //此处获取到得必须为空，不为空则为重复
        UocNoticeProcessor intRet = manageMap.get(noticeCode);
        if (intRet != null) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_FAIL, "不同通知实现类(" + noticeCode + ")出现多个实现类！");
        }
        log.info(UocNoticeProcessorManager.class.getSimpleName() + ".register注册了通知实现类：" + noticeCode);

        manageMap.put(noticeCode, intObj);
    }

    public UocNoticeProcessor getInstance(String noticeCode) {
        //此处获取到得必须为空，不为空则为重复
        UocNoticeProcessor intRet = manageMap.get(noticeCode);
        if (intRet == null) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_FAIL, "通知实现类(" + noticeCode + ")不存在！");
        }
        return intRet;
    }

}


