package com.tydic.dyc.oc.service.shiporder;

import com.tydic.dyc.oc.model.shiporder.IUocShipOrderModel;
import com.tydic.dyc.oc.model.shiporder.UocShipOrderDo;
import com.tydic.dyc.oc.model.shiporder.qrybo.UocShipOrderQryBo;
import com.tydic.dyc.oc.service.shiporder.bo.UocQryShipOrderListBySaleOrderIdReqBo;
import com.tydic.dyc.oc.service.shiporder.bo.UocQryShipOrderListBySaleOrderIdRspBo;
import com.tydic.dyc.oc.service.shiporder.bo.UocShipOrderBo;
import com.tydic.dyc.oc.utils.UocRu;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

import java.util.List;

/**
 * 描述: 〈领域服务-发货单列表查询 实现〉
 * @author : yuhao
 * @date : 2022/8/1 11:05
 */
@HTServiceImpl
public class UocQryShipOrderListBySaleOrderIdServiceImpl implements UocQryShipOrderListBySaleOrderIdService {
    @Autowired
    private IUocShipOrderModel iUocShipOrderModel;

    @Override
    public UocQryShipOrderListBySaleOrderIdRspBo qryShipOrderListBySaleOrderId(UocQryShipOrderListBySaleOrderIdReqBo reqBo) {
        UocQryShipOrderListBySaleOrderIdRspBo rspBo = UocRu.success(UocQryShipOrderListBySaleOrderIdRspBo.class);
        UocShipOrderQryBo uocShipOrderQryBo = new UocShipOrderQryBo();
        uocShipOrderQryBo.setOrderId(reqBo.getOrderId());
        uocShipOrderQryBo.setSaleOrderId(reqBo.getSaleOrderId());
        List<UocShipOrderDo> dos = iUocShipOrderModel.getListShipOrder(uocShipOrderQryBo);
        if(!CollectionUtils.isEmpty(dos)){
            List<UocShipOrderBo>  bos = UocRu.jsl(dos,UocShipOrderBo.class);
            rspBo.setShipOrderList(bos);
        }
        return rspBo;
    }
}
