/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.oc.service.domainservice;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.constants.UocAttachementTypeConstants;
import com.tydic.dyc.oc.constants.UocConstant;
import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.model.common.IUocCommonModel;
import com.tydic.dyc.oc.model.common.UocCommonDo;
import com.tydic.dyc.oc.model.order.sub.UocOrderAccessory;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderItemQryBo;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleOrderItem;
import com.tydic.dyc.oc.model.shiporder.IUocShipOrderModel;
import com.tydic.dyc.oc.model.shiporder.UocShipOrderDo;
import com.tydic.dyc.oc.model.shiporder.qrybo.UocShipOrderItemQryBo;
import com.tydic.dyc.oc.model.shiporder.sub.UocShipOrderItem;
import com.tydic.dyc.oc.service.domainservice.UocShipOrderArrivaConfirmOrRefuseService;
import com.tydic.dyc.oc.service.domainservice.bo.UocShipOrderArrivaConfirmOrRefuseReqBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocShipOrderArrivaConfirmOrRefuseRspBo;
import com.tydic.dyc.oc.service.saleorder.bo.UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo;
import com.tydic.dyc.oc.utils.IdUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"OC_GROUP_DEV/3.0.0/com.tydic.dyc.oc.service.domainservice.UocShipOrderArrivaConfirmOrRefuseService"})
public class UocShipOrderArrivaConfirmOrRefuseServiceImpl
implements UocShipOrderArrivaConfirmOrRefuseService {
    private static final Logger log = LoggerFactory.getLogger(UocShipOrderArrivaConfirmOrRefuseServiceImpl.class);
    private static final Integer OP_FLAG_CONFIRM = 1;
    private static final Integer OP_FLAG_REFUSE = 2;
    @Autowired
    private IUocShipOrderModel iUocShipOrderModel;
    @Autowired
    private IUocSaleOrderModel iUocSaleOrderModel;
    @Autowired
    private IUocCommonModel iUocCommonModel;

    @PostMapping(value={"dealArriva"})
    public UocShipOrderArrivaConfirmOrRefuseRspBo dealArriva(@RequestBody UocShipOrderArrivaConfirmOrRefuseReqBo reqBo) {
        this.validateArg(reqBo);
        List<UocSaleOrderItem> saleOrderItemInfos = this.getSaleOrderItemInfos(reqBo);
        List<UocShipOrderItem> saleOrderAllShipItemInfos = this.getSaleOrderAllShipItemInfos(reqBo);
        List<UocShipOrderItem> shipOrderAllItemInfos = this.getShipOrderAllItemInfos(reqBo);
        this.updateShipOrderInfo(reqBo, shipOrderAllItemInfos);
        this.updateSaleOrderStatus(reqBo, saleOrderItemInfos, saleOrderAllShipItemInfos, shipOrderAllItemInfos);
        this.submitShipOrderTask(reqBo);
        UocShipOrderArrivaConfirmOrRefuseRspBo rspBo = new UocShipOrderArrivaConfirmOrRefuseRspBo();
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        return rspBo;
    }

    private void submitShipOrderTask(UocShipOrderArrivaConfirmOrRefuseReqBo reqBo) {
        for (String taskId : reqBo.getTaskIds()) {
            UocCommonDo uocCommonDo = new UocCommonDo();
            ArrayList<UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo> taskInfos = new ArrayList<UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo>();
            UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo task = new UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo();
            task.setTaskId(taskId);
            taskInfos.add(task);
            uocCommonDo.setCompleteTaskInfos(taskInfos);
            uocCommonDo.setUserId(reqBo.getUserId());
            uocCommonDo.setOrderId(reqBo.getOrderId());
            this.iUocCommonModel.dealTask(uocCommonDo);
        }
    }

    private List<UocShipOrderItem> getShipOrderAllItemInfos(UocShipOrderArrivaConfirmOrRefuseReqBo reqBo) {
        UocShipOrderItemQryBo uocShipOrderItemQryBo = new UocShipOrderItemQryBo();
        uocShipOrderItemQryBo.setShipOrderIdList(reqBo.getShipOrderIdList());
        uocShipOrderItemQryBo.setOrderId(reqBo.getOrderId());
        uocShipOrderItemQryBo.setSaleOrderId(reqBo.getSaleOrderId());
        UocShipOrderDo shipOrderDo = this.iUocShipOrderModel.getListShipOrderItem(uocShipOrderItemQryBo);
        if (null != shipOrderDo && !CollectionUtils.isEmpty(shipOrderDo.getShipOrderItemBoList())) {
            return shipOrderDo.getShipOrderItemBoList();
        }
        throw new BaseBusinessException("101003", "\u83b7\u53d6\u53d1\u8d27\u660e\u7ec6\u4e3a\u7a7a");
    }

    private List<UocShipOrderItem> getSaleOrderAllShipItemInfos(UocShipOrderArrivaConfirmOrRefuseReqBo reqBo) {
        UocShipOrderItemQryBo uocShipOrderItemQryBo = new UocShipOrderItemQryBo();
        uocShipOrderItemQryBo.setOrderId(reqBo.getOrderId());
        uocShipOrderItemQryBo.setSaleOrderId(reqBo.getSaleOrderId());
        UocShipOrderDo shipOrderDo = this.iUocShipOrderModel.getListShipOrderItem(uocShipOrderItemQryBo);
        if (null != shipOrderDo && !CollectionUtils.isEmpty(shipOrderDo.getShipOrderItemBoList())) {
            return shipOrderDo.getShipOrderItemBoList();
        }
        throw new BaseBusinessException("101003", "\u672a\u83b7\u53d6\u5230\u9500\u552e\u5355\u6240\u6709\u5df2\u53d1\u8d27\u660e\u7ec6");
    }

    private List<UocSaleOrderItem> getSaleOrderItemInfos(UocShipOrderArrivaConfirmOrRefuseReqBo reqBo) {
        UocSaleOrderItemQryBo qryBo = new UocSaleOrderItemQryBo();
        qryBo.setOrderId(reqBo.getOrderId());
        qryBo.setSaleOrderId(reqBo.getSaleOrderId());
        UocSaleOrderDo uocSaleOrderDo = this.iUocSaleOrderModel.qryListSaleOrderItem(qryBo);
        if (null != uocSaleOrderDo && !CollectionUtils.isEmpty(uocSaleOrderDo.getSaleOrderItems())) {
            return uocSaleOrderDo.getSaleOrderItems();
        }
        throw new BaseBusinessException("101003", "\u672a\u83b7\u53d6\u5230\u9500\u552e\u5355\u660e\u7ec6\u4fe1\u606f");
    }

    private void updateShipOrderInfo(UocShipOrderArrivaConfirmOrRefuseReqBo reqBo, List<UocShipOrderItem> shipOrderAllItemInfos) {
        UocShipOrderDo updateShipOrderDo = (UocShipOrderDo)JSONObject.parseObject((String)JSON.toJSONString((Object)reqBo), UocShipOrderDo.class);
        updateShipOrderDo.setUpdateOperId(String.valueOf(reqBo.getUserId()));
        updateShipOrderDo.setUpdateTime(new Date());
        updateShipOrderDo.setArriveTime(new Date());
        if (!CollectionUtils.isEmpty((Collection)reqBo.getOrderAccessoryBoList())) {
            ArrayList<UocOrderAccessory> orderAccessoryBoList = new ArrayList<UocOrderAccessory>();
            reqBo.getOrderAccessoryBoList().forEach(orderAccessoryAddBo -> {
                UocOrderAccessory uocOrderAccessory = (UocOrderAccessory)JSONObject.parseObject((String)JSON.toJSONString((Object)orderAccessoryAddBo), UocOrderAccessory.class);
                uocOrderAccessory.setOrderId(reqBo.getOrderId());
                uocOrderAccessory.setObjId(reqBo.getSaleOrderId());
                uocOrderAccessory.setObjType(UocDicConstant.OBJ_TYPE.SALE);
                uocOrderAccessory.setCreateTime(new Date());
                uocOrderAccessory.setCreateOperId(String.valueOf(reqBo.getUserId()));
                uocOrderAccessory.setId(IdUtil.nextId());
                uocOrderAccessory.setAttachmentType(UocAttachementTypeConstants.ARRIVAL_CONFIRM);
                orderAccessoryBoList.add(uocOrderAccessory);
            });
            updateShipOrderDo.setOrderAccessoryBoList(orderAccessoryBoList);
        }
        if (OP_FLAG_CONFIRM.equals(reqBo.getOpFlag())) {
            this.dealConfirm(updateShipOrderDo, shipOrderAllItemInfos);
        } else {
            this.dealRefuse(updateShipOrderDo, shipOrderAllItemInfos);
        }
    }

    private void dealConfirm(UocShipOrderDo uocShipOrderDo, List<UocShipOrderItem> uocShipOrderItemList) {
        uocShipOrderItemList.forEach(uocShipOrderItem -> {
            if (uocShipOrderItem.getRefuseCount().compareTo(BigDecimal.ZERO) > 0) {
                throw new BaseBusinessException("101003", "\u5df2\u62d2\u6536\u53d1\u8d27\u5355\u4e0d\u80fd\u505a\u5230\u8d27\u786e\u8ba4\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9");
            }
            if (uocShipOrderItem.getArriveCount().compareTo(BigDecimal.ZERO) > 0) {
                throw new BaseBusinessException("101003", "\u5b58\u5728\u5df2\u786e\u8ba4\u5230\u8d27\u53d1\u8d27\u5355\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9");
            }
        });
        uocShipOrderDo.setShipOrderState("FH_FH_YDH");
        this.iUocShipOrderModel.arrivaConfirm(uocShipOrderDo);
    }

    private void dealRefuse(UocShipOrderDo uocShipOrderDo, List<UocShipOrderItem> uocShipOrderItemList) {
        uocShipOrderItemList.forEach(uocShipOrderItem -> {
            if (uocShipOrderItem.getRefuseCount().compareTo(BigDecimal.ZERO) > 0) {
                throw new BaseBusinessException("101003", "\u5b58\u5728\u5df2\u62d2\u6536\u53d1\u8d27\u5355\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9");
            }
            if (uocShipOrderItem.getArriveCount().compareTo(BigDecimal.ZERO) > 0) {
                throw new BaseBusinessException("101003", "\u5df2\u786e\u8ba4\u5230\u8d27\u53d1\u8d27\u5355\u4e0d\u80fd\u505a\u62d2\u6536\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9");
            }
        });
        uocShipOrderDo.setShipOrderState("FH_FH_JS");
        uocShipOrderDo.setFinishFlag(UocConstant.SHIP_ORDER_FINISH_FLAG.FINISH);
        this.iUocShipOrderModel.arrivaRefuse(uocShipOrderDo);
    }

    /*
     * WARNING - void declaration
     */
    private void updateSaleOrderStatus(UocShipOrderArrivaConfirmOrRefuseReqBo reqBo, List<UocSaleOrderItem> saleOrderItemInfos, List<UocShipOrderItem> saleOrderAllShipItemInfos, List<UocShipOrderItem> shipOrderAllItemInfos) {
        void var9_15;
        BigDecimal purchaseCount = new BigDecimal(0);
        for (UocSaleOrderItem uocSaleOrderItem : saleOrderItemInfos) {
            purchaseCount = purchaseCount.add(uocSaleOrderItem.getPurchaseCount() == null ? new BigDecimal(0) : uocSaleOrderItem.getPurchaseCount());
        }
        BigDecimal arrivedCount = new BigDecimal(0);
        BigDecimal refusedCount = new BigDecimal(0);
        for (UocShipOrderItem uocShipOrderItem : saleOrderAllShipItemInfos) {
            arrivedCount = arrivedCount.add(uocShipOrderItem.getArriveCount() == null ? new BigDecimal(0) : uocShipOrderItem.getArriveCount());
            refusedCount = refusedCount.add(uocShipOrderItem.getRefuseCount() == null ? new BigDecimal(0) : uocShipOrderItem.getRefuseCount());
        }
        BigDecimal mutiplyCount = new BigDecimal(0);
        for (UocShipOrderItem uocShipOrderItem : shipOrderAllItemInfos) {
            mutiplyCount = mutiplyCount.add(uocShipOrderItem.getSendCount() == null ? new BigDecimal(0) : uocShipOrderItem.getSendCount());
        }
        if (OP_FLAG_CONFIRM.equals(reqBo.getOpFlag())) {
            arrivedCount = arrivedCount.add(mutiplyCount);
        } else {
            refusedCount = refusedCount.add(mutiplyCount);
        }
        Object var9_11 = null;
        if (purchaseCount.compareTo(arrivedCount) == 0) {
            String string = "XS_DH_DH";
        } else if (purchaseCount.compareTo(refusedCount) == 0) {
            String string = "XS_DH_JS";
        } else if (purchaseCount.compareTo(arrivedCount.add(refusedCount)) == 0) {
            String string = "XS_DH_BFDH";
        }
        if (!StringUtils.isBlank((CharSequence)var9_15)) {
            UocSaleOrderDo updateSaleOrderDo = new UocSaleOrderDo();
            updateSaleOrderDo.setSaleOrderState((String)var9_15);
            updateSaleOrderDo.setOrderId(reqBo.getOrderId());
            updateSaleOrderDo.setSaleOrderId(reqBo.getSaleOrderId());
            updateSaleOrderDo.setUpdateTime(new Date());
            updateSaleOrderDo.setUpdateOperId(String.valueOf(reqBo.getUserId()));
            this.iUocSaleOrderModel.updateSaleStatusAndProCode(updateSaleOrderDo);
        }
    }

    private void validateArg(UocShipOrderArrivaConfirmOrRefuseReqBo reqBo) {
        if (null == reqBo) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBo.getOrderId()) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u8ba2\u5355ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBo.getSaleOrderId()) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u9500\u552e\u5355ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (CollectionUtils.isEmpty((Collection)reqBo.getShipOrderIdList())) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u53d1\u8d27\u5355ID\u6570\u7ec4\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBo.getOpFlag()) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u64cd\u4f5c\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!OP_FLAG_CONFIRM.equals(reqBo.getOpFlag()) && !OP_FLAG_REFUSE.equals(reqBo.getOpFlag())) {
            throw new BaseBusinessException("100001", "\u64cd\u4f5c\u4ec5\u652f\u6301\u5230\u8d27\u786e\u8ba4\u6216\u62d2\u6536");
        }
        if (null == reqBo.getUserId()) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u7528\u6237ID\u4e3a\u7a7a");
        }
    }
}

