/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.oc.service.domainservice;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.constants.UocConstant;
import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.model.aforder.IUocAfOrderModel;
import com.tydic.dyc.oc.model.aforder.UocAfOrderDo;
import com.tydic.dyc.oc.model.aforder.sub.UocAfOrderItem;
import com.tydic.dyc.oc.model.aforder.sub.UocAfOrderMap;
import com.tydic.dyc.oc.model.aforder.sub.UocAfOrderObj;
import com.tydic.dyc.oc.model.common.IUocCommonModel;
import com.tydic.dyc.oc.model.order.sub.UocOrdLogisticsRela;
import com.tydic.dyc.oc.model.order.sub.UocOrderAccessory;
import com.tydic.dyc.oc.model.order.sub.UocOrderQueryIndex;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderItemQryBo;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleOrderItem;
import com.tydic.dyc.oc.model.shiporder.IUocShipOrderModel;
import com.tydic.dyc.oc.model.shiporder.UocShipOrderDo;
import com.tydic.dyc.oc.model.shiporder.qrybo.UocShipOrderItemQryBo;
import com.tydic.dyc.oc.model.shiporder.sub.UocShipOrderItem;
import com.tydic.dyc.oc.service.common.bo.UocBaseOrderAccessoryAddBo;
import com.tydic.dyc.oc.service.domainservice.UocAfterOrderCreateService;
import com.tydic.dyc.oc.service.domainservice.bo.UocAfterOrderCreateReqAddressBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocAfterOrderCreateReqBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocAfterOrderCreateReqItemBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocAfterOrderCreateRspBo;
import com.tydic.dyc.oc.utils.IdUtil;
import com.tydic.dyc.oc.utils.UocRu;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"OC_GROUP_DEV/3.0.0/com.tydic.dyc.oc.service.domainservice.UocAfterOrderCreateService"})
public class UocAfterOrderCreateServiceImpl
implements UocAfterOrderCreateService {
    @Autowired
    private IUocAfOrderModel afOrderModel;
    @Autowired
    private IUocShipOrderModel shipOrderModel;
    @Autowired
    private IUocSaleOrderModel saleOrderModel;
    @Autowired
    private IUocCommonModel iUocCommonModel;

    @PostMapping(value={"createAfterOrder"})
    public UocAfterOrderCreateRspBo createAfterOrder(@RequestBody UocAfterOrderCreateReqBo reqBo) {
        this.validateArg(reqBo);
        this.checkAfterCount(reqBo);
        UocAfOrderDo afterOrderApplyInfo = this.createAfterOrderApplyInfo(reqBo);
        this.updateAfingCount(reqBo, afterOrderApplyInfo);
        if (UocDicConstant.ORDER_SOURCE.E_COMMERCE_IMPORT.equals(reqBo.getOrderSource())) {
            this.saveOrderExternalRela(reqBo, afterOrderApplyInfo.getAfOrderId());
        }
        UocAfterOrderCreateRspBo rspBo = new UocAfterOrderCreateRspBo();
        rspBo.setAfOrderId(afterOrderApplyInfo.getAfOrderId());
        JSONObject saleOrderExtObj = new JSONObject();
        saleOrderExtObj.put("afterOrderFlag", (Object)UocConstant.SALEORDER_SYN_AFTERORDER.ING);
        rspBo.setSaleOrderExtObj(JSONObject.toJSONString((Object)saleOrderExtObj));
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        return rspBo;
    }

    private void saveOrderExternalRela(UocAfterOrderCreateReqBo reqBo, Long afOrderId) {
        UocOrderQueryIndex orderQueryIndex = new UocOrderQueryIndex();
        orderQueryIndex.setId(IdUtil.nextId());
        orderQueryIndex.setOrderId(reqBo.getOrderId());
        orderQueryIndex.setObjType(UocDicConstant.OBJ_TYPE.AFTER);
        orderQueryIndex.setObjId(afOrderId);
        orderQueryIndex.setOutObjId(reqBo.getServiceId());
        this.iUocCommonModel.saveOrderQueryIndex(orderQueryIndex);
    }

    private void updateAfingCount(UocAfterOrderCreateReqBo reqBo, UocAfOrderDo afOrderDo) {
        for (UocAfOrderItem uocAfOrderItem : afOrderDo.getAfOrderItemBoList()) {
            Long orderItemId = uocAfOrderItem.getSaleItemId();
            Long shipItemId = uocAfOrderItem.getShipItemId();
            Long orderId = uocAfOrderItem.getOrderId();
            BigDecimal returnCount = uocAfOrderItem.getReturnCount();
            UocShipOrderItem uocShipOrderItem = new UocShipOrderItem();
            uocShipOrderItem.setOrderId(orderId);
            uocShipOrderItem.setShipOrderItemId(shipItemId);
            uocShipOrderItem.setAfterServingCount(returnCount);
            uocShipOrderItem.setUpdateTime(new Date());
            uocShipOrderItem.setUpdateOperId(String.valueOf(reqBo.getUserId()));
            this.shipOrderModel.modifyShipOrderItemAfterServingCount(uocShipOrderItem);
            UocSaleOrderItem uocSaleOrderItem = new UocSaleOrderItem();
            uocSaleOrderItem.setOrderId(orderId);
            uocSaleOrderItem.setSaleOrderItemId(orderItemId);
            uocSaleOrderItem.setAfterServingCount(returnCount);
            uocSaleOrderItem.setUpdateTime(new Date());
            uocSaleOrderItem.setUpdateOperId(String.valueOf(reqBo.getUserId()));
            this.saleOrderModel.modifySaleOrderItemAfterServingCount(uocSaleOrderItem);
        }
    }

    private UocAfOrderDo createAfterOrderApplyInfo(UocAfterOrderCreateReqBo reqBo) {
        UocAfOrderDo createAfterOrder = UocRu.js(reqBo, UocAfOrderDo.class);
        createAfterOrder.setSubContactName(reqBo.getName());
        createAfterOrder.setSubContactMobile(reqBo.getCellphone());
        createAfterOrder.setCreateTime(new Date());
        createAfterOrder.setCreateOperId(String.valueOf(reqBo.getUserId()));
        createAfterOrder.setSubmiteTime(new Date());
        createAfterOrder.setSubmitterOperId(String.valueOf(reqBo.getUserId()));
        createAfterOrder.setSubmitterOperName(reqBo.getName());
        createAfterOrder.setSubDeptId(String.valueOf(reqBo.getOrgId()));
        createAfterOrder.setSubDeptName(reqBo.getOrgName());
        createAfterOrder.setSubCompId(String.valueOf(reqBo.getCompanyId()));
        createAfterOrder.setSubCompName(reqBo.getCompanyName());
        createAfterOrder.setExtField2(reqBo.getClientName());
        createAfterOrder.setExtField3(reqBo.getClientPhone());
        createAfterOrder.setExtAfId(reqBo.getServiceId());
        ArrayList<UocAfOrderItem> uocAfOrderItems = new ArrayList<UocAfOrderItem>();
        for (UocAfterOrderCreateReqItemBo uocAfterOrderCreateReqItemBo : reqBo.getShipItemList()) {
            UocShipOrderItemQryBo uocShipOrderItemQryBo = new UocShipOrderItemQryBo();
            uocShipOrderItemQryBo.setShipOrderItemId(uocAfterOrderCreateReqItemBo.getShipOrderItemId());
            uocShipOrderItemQryBo.setShipOrderId(reqBo.getShipOrderId());
            UocShipOrderDo shipOrderItemInfo = this.shipOrderModel.getListShipOrderItem(uocShipOrderItemQryBo);
            if (ObjectUtil.isNotEmpty((Object)shipOrderItemInfo) && CollectionUtil.isNotEmpty(shipOrderItemInfo.getShipOrderItemBoList())) {
                UocAfOrderItem createAfOrderItem = new UocAfOrderItem();
                BeanUtils.copyProperties((Object)reqBo, (Object)createAfOrderItem);
                BeanUtil.copyProperties((Object)shipOrderItemInfo.getShipOrderItemBoList().get(0), (Object)createAfOrderItem);
                createAfOrderItem.setCreateTime(new Date());
                createAfOrderItem.setCreateOperId(String.valueOf(reqBo.getUserId()));
                createAfOrderItem.setSaleItemId(shipOrderItemInfo.getShipOrderItemBoList().get(0).getSaleOrderItemId());
                createAfOrderItem.setShipItemId(shipOrderItemInfo.getShipOrderItemBoList().get(0).getShipOrderItemId());
                UocSaleOrderItemQryBo uocSaleOrderItemQryBo = new UocSaleOrderItemQryBo();
                uocSaleOrderItemQryBo.setSaleOrderItemId(shipOrderItemInfo.getShipOrderItemBoList().get(0).getSaleOrderItemId());
                List<UocSaleOrderItem> saleOrderItemInfo = this.saleOrderModel.getSaleOrderItemList(uocSaleOrderItemQryBo);
                if (CollectionUtil.isNotEmpty(saleOrderItemInfo)) {
                    BeanUtil.copyProperties((Object)saleOrderItemInfo.get(0), (Object)createAfOrderItem);
                    createAfOrderItem.setReturnCount(uocAfterOrderCreateReqItemBo.getReturnCount());
                    createAfOrderItem.setRetPurchaseFee(saleOrderItemInfo.get(0).getPurchasePrice().multiply(uocAfterOrderCreateReqItemBo.getReturnCount()));
                    createAfOrderItem.setRetSaleFee(saleOrderItemInfo.get(0).getSalePrice().multiply(uocAfterOrderCreateReqItemBo.getReturnCount()));
                    uocAfOrderItems.add(createAfOrderItem);
                    continue;
                }
                throw new BaseBusinessException("100001", "\u67e5\u8be2\u9500\u552e\u5355\u660e\u7ec6" + shipOrderItemInfo.getShipOrderItemBoList().get(0).getSaleOrderItemId() + "\u4fe1\u606f\u5931\u8d25");
            }
            throw new BaseBusinessException("100001", "\u67e5\u8be2\u53d1\u8d27\u5355\u660e\u7ec6" + uocAfterOrderCreateReqItemBo.getShipOrderItemId() + "\u4fe1\u606f\u5931\u8d25");
        }
        createAfterOrder.setAfOrderItemBoList(uocAfOrderItems);
        createAfterOrder.setRetTotalSaleFee(uocAfOrderItems.stream().map(UocAfOrderItem::getRetSaleFee).reduce(BigDecimal::add).orElse(BigDecimal.ZERO));
        createAfterOrder.setRetTotalPurchaseFee(uocAfOrderItems.stream().map(UocAfOrderItem::getRetPurchaseFee).reduce(BigDecimal::add).orElse(BigDecimal.ZERO));
        if (UocConstant.AFTERORDER_SERVTYPE.RETURN.equals(reqBo.getServType())) {
            createAfterOrder.setRealReturnFee(uocAfOrderItems.stream().map(UocAfOrderItem::getRetSaleFee).reduce(BigDecimal::add).orElse(BigDecimal.ZERO));
        }
        ArrayList<UocAfOrderObj> afOrderObjList = new ArrayList<UocAfOrderObj>();
        UocAfOrderObj createAfOrderObj = new UocAfOrderObj();
        createAfOrderObj.setOrderId(reqBo.getOrderId());
        createAfOrderObj.setSaleOrderId(reqBo.getSaleOrderId());
        createAfOrderObj.setShipOrderId(reqBo.getShipOrderId());
        createAfOrderObj.setCreateOperId(String.valueOf(reqBo.getUserId()));
        createAfOrderObj.setCreateTime(new Date());
        afOrderObjList.add(createAfOrderObj);
        createAfterOrder.setAfOrderObjList(afOrderObjList);
        if (CollectionUtil.isNotEmpty((Collection)reqBo.getOrderAccessoryBoList())) {
            ArrayList<UocOrderAccessory> orderAccessoryBoList = new ArrayList<UocOrderAccessory>();
            for (UocBaseOrderAccessoryAddBo uocBaseOrderAccessoryAddBo : reqBo.getOrderAccessoryBoList()) {
                UocOrderAccessory afterOrderAccessory = (UocOrderAccessory)JSONObject.parseObject((String)JSON.toJSONString((Object)uocBaseOrderAccessoryAddBo), UocOrderAccessory.class);
                afterOrderAccessory.setAttachmentType(UocDicConstant.ATTACHMENT_TYPE.OTHER_ATTACH_FOR_SUPPLIER);
                afterOrderAccessory.setCreateOperId(String.valueOf(reqBo.getUserId()));
                afterOrderAccessory.setCreateTime(new Date());
                orderAccessoryBoList.add(afterOrderAccessory);
            }
            createAfterOrder.setOrderAccessoryBoList(UocRu.jsl(orderAccessoryBoList, UocOrderAccessory.class));
        }
        if (ObjectUtil.isNotEmpty((Object)reqBo.getTakeAddress())) {
            UocOrdLogisticsRela takeAddress = new UocOrdLogisticsRela();
            BeanUtils.copyProperties((Object)reqBo.getTakeAddress(), (Object)takeAddress);
            takeAddress.setCreateOperId(String.valueOf(reqBo.getUserId()));
            takeAddress.setCreateTime(new Date());
            createAfterOrder.setTakeAddress(takeAddress);
        }
        if (ObjectUtil.isNotEmpty((Object)reqBo.getReturnAddress())) {
            UocOrdLogisticsRela returnAddress = new UocOrdLogisticsRela();
            BeanUtils.copyProperties((Object)reqBo.getReturnAddress(), (Object)returnAddress);
            returnAddress.setCreateOperId(String.valueOf(reqBo.getUserId()));
            returnAddress.setCreateTime(new Date());
            createAfterOrder.setReturnAddress(UocRu.js(returnAddress, UocOrdLogisticsRela.class));
        }
        UocSaleOrderDo querySaleOrderDo = new UocSaleOrderDo();
        querySaleOrderDo.setOrderId(reqBo.getOrderId());
        querySaleOrderDo.setSaleOrderId(reqBo.getSaleOrderId());
        UocSaleOrderDo saleOrderMain = this.saleOrderModel.getSaleOrderMain(querySaleOrderDo);
        if (null != saleOrderMain) {
            createAfterOrder.setPayType(saleOrderMain.getPayType());
            if (String.valueOf(UocDicConstant.PAY_TYPE.ADVANCE_PAYMENT_PRORATED).equals(saleOrderMain.getPayType())) {
                createAfterOrder.setPayState(UocDicConstant.PAY_AFTER_STATE.RETURNING);
            } else if (String.valueOf(UocDicConstant.PAY_TYPE.PAY_BY_PERIOD).equals(saleOrderMain.getPayType())) {
                if (UocDicConstant.PAY_STATE.WAIT_PAY.equals(saleOrderMain.getPayState())) {
                    createAfterOrder.setPayState(UocDicConstant.PAY_AFTER_STATE.UPDATEING);
                } else if (UocDicConstant.PAY_STATE.PAYED.equals(saleOrderMain.getPayState())) {
                    createAfterOrder.setPayState(UocDicConstant.PAY_AFTER_STATE.RETURNING);
                }
            }
        } else {
            throw new BaseBusinessException("100001", "\u67e5\u8be2\u9500\u552e\u5355\u652f\u4ed8\u4fe1\u606f\u5931\u8d25");
        }
        createAfterOrder.setPayTypeStr(saleOrderMain.getPayTypeStr());
        UocAfOrderDo afterOrderInfo = this.afOrderModel.dealPebTheZoneAfterApplication(createAfterOrder, reqBo.getOrderSource());
        return afterOrderInfo;
    }

    private void checkAfterCount(UocAfterOrderCreateReqBo reqBo) {
        UocShipOrderItemQryBo uocShipOrderQryBo = new UocShipOrderItemQryBo();
        uocShipOrderQryBo.setOrderId(reqBo.getOrderId());
        uocShipOrderQryBo.setShipOrderId(reqBo.getShipOrderId());
        UocShipOrderDo shipOrderInfo = this.shipOrderModel.getListShipOrderItem(uocShipOrderQryBo);
        Map<Long, UocShipOrderItem> shipOrderItemMap = shipOrderInfo.getShipOrderItemBoList().stream().collect(Collectors.toMap(UocShipOrderItem::getShipOrderItemId, o -> o));
        List shipItemList = reqBo.getShipItemList();
        for (UocAfterOrderCreateReqItemBo uocAfterOrderCreateReqItemBo : shipItemList) {
            UocShipOrderItem uocShipOrderItem = shipOrderItemMap.get(uocAfterOrderCreateReqItemBo.getShipOrderItemId());
            BigDecimal afterCountEnable = uocShipOrderItem.getSendCount().subtract(uocShipOrderItem.getReturnCount()).subtract(uocShipOrderItem.getAfterServingCount());
            if (uocAfterOrderCreateReqItemBo.getReturnCount().compareTo(afterCountEnable) <= 0) continue;
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027\u552e\u540e\u6570\u91cf\u4e0d\u80fd\u8d85\u8fc7\u53ef\u552e\u540e\u6570\u91cf");
        }
    }

    private void buildShipItem(UocAfterOrderCreateReqBo reqBo, UocAfOrderDo createDo) {
        ArrayList<UocAfOrderItem> uocAfOrderItems = new ArrayList<UocAfOrderItem>();
        List shipItemList = reqBo.getShipItemList();
        if (CollectionUtil.isNotEmpty((Collection)shipItemList)) {
            for (UocAfterOrderCreateReqItemBo uocAfterOrderCreateReqItemBo : shipItemList) {
                Long shipOrderItemId = uocAfterOrderCreateReqItemBo.getShipOrderItemId();
                UocShipOrderItemQryBo uocShipOrderItemQryBo = new UocShipOrderItemQryBo();
                uocShipOrderItemQryBo.setShipOrderItemId(shipOrderItemId);
                uocShipOrderItemQryBo.setShipOrderId(reqBo.getShipOrderId());
                UocShipOrderDo shipOrderItem = this.shipOrderModel.getListShipOrderItem(uocShipOrderItemQryBo);
                if (!ObjectUtil.isNotEmpty((Object)shipOrderItem) || !ObjectUtil.isNotEmpty(shipOrderItem.getShipOrderItemBoList())) continue;
                UocAfOrderItem uocAfOrderItem = new UocAfOrderItem();
                List<UocShipOrderItem> shipOrderItemBoList = shipOrderItem.getShipOrderItemBoList();
                UocShipOrderItem uocShipOrderItem = shipOrderItemBoList.get(0);
                BeanUtil.copyProperties((Object)uocShipOrderItem, (Object)uocAfOrderItem);
                Long saleOrderItemId = uocShipOrderItem.getSaleOrderItemId();
                UocSaleOrderItemQryBo uocSaleOrderItemQryBo = new UocSaleOrderItemQryBo();
                uocSaleOrderItemQryBo.setSaleOrderItemId(saleOrderItemId);
                List<UocSaleOrderItem> saleOrderItemList = this.saleOrderModel.getSaleOrderItemList(uocSaleOrderItemQryBo);
                UocSaleOrderItem uocSaleOrderItem = saleOrderItemList.get(0);
                BeanUtil.copyProperties((Object)uocSaleOrderItem, (Object)uocAfOrderItem);
                uocAfOrderItem.setSaleItemId(uocShipOrderItem.getSaleOrderItemId());
                uocAfOrderItem.setShipItemId(uocShipOrderItem.getShipOrderItemId());
                uocAfOrderItem.setReturnCount(uocAfterOrderCreateReqItemBo.getReturnCount());
                uocAfOrderItem.setRetPurchaseFee(uocSaleOrderItem.getPurchasePrice().multiply(uocAfterOrderCreateReqItemBo.getReturnCount()));
                uocAfOrderItem.setRetSaleFee(uocSaleOrderItem.getSalePrice().multiply(uocAfterOrderCreateReqItemBo.getReturnCount()));
                uocAfOrderItems.add(uocAfOrderItem);
            }
        }
        if (UocConstant.AFTERORDER_SERVTYPE.RETURN.equals(reqBo.getServType())) {
            createDo.setRealReturnFee(uocAfOrderItems.stream().map(UocAfOrderItem::getRetSaleFee).reduce(BigDecimal::add).orElse(BigDecimal.ZERO));
        }
        createDo.setAfOrderItemBoList(uocAfOrderItems);
        createDo.setRetTotalSaleFee(uocAfOrderItems.stream().map(UocAfOrderItem::getRetSaleFee).reduce(BigDecimal::add).orElse(BigDecimal.ZERO));
        createDo.setRetTotalPurchaseFee(uocAfOrderItems.stream().map(UocAfOrderItem::getRetPurchaseFee).reduce(BigDecimal::add).orElse(BigDecimal.ZERO));
    }

    private UocAfOrderDo convertOrderDo(UocAfterOrderCreateReqBo reqBo) {
        List orderAccessoryBoList;
        List shipItemList;
        UocAfOrderDo uocAfOrderDo = UocRu.js(reqBo, UocAfOrderDo.class);
        UocAfOrderObj uocAfOrderObj = UocRu.js(reqBo, UocAfOrderObj.class);
        ArrayList<UocAfOrderObj> uocAfOrderObjs = new ArrayList<UocAfOrderObj>();
        uocAfOrderObjs.add(uocAfOrderObj);
        uocAfOrderDo.setAfOrderObjList(uocAfOrderObjs);
        uocAfOrderDo.setExtAfId(reqBo.getServiceId());
        List extFields = reqBo.getExtFields();
        if (CollectionUtil.isNotEmpty((Collection)extFields)) {
            BeanUtils.copyProperties((Object)reqBo, (Object)uocAfOrderDo);
            uocAfOrderDo.setExtParallelBoList(UocRu.jsl(extFields, UocAfOrderMap.class));
            uocAfOrderDo.setCreateTime(new Date());
            uocAfOrderDo.setCreateOperId(String.valueOf(reqBo.getUserId()));
        }
        if (CollectionUtil.isNotEmpty((Collection)(shipItemList = reqBo.getShipItemList()))) {
            uocAfOrderDo.setAfOrderItemBoList(UocRu.jsl(shipItemList, UocAfOrderItem.class));
            for (UocAfOrderItem uocAfOrderItem : uocAfOrderDo.getAfOrderItemBoList()) {
                BeanUtils.copyProperties((Object)reqBo, (Object)uocAfOrderItem);
                uocAfOrderItem.setCreateTime(new Date());
                uocAfOrderItem.setCreateOperId(String.valueOf(reqBo.getUserId()));
            }
        }
        if (CollectionUtil.isNotEmpty((Collection)(orderAccessoryBoList = reqBo.getOrderAccessoryBoList()))) {
            uocAfOrderDo.setOrderAccessoryBoList(UocRu.jsl(orderAccessoryBoList, UocOrderAccessory.class));
            for (UocOrderAccessory uocOrderAccessory : uocAfOrderDo.getOrderAccessoryBoList()) {
                BeanUtils.copyProperties((Object)reqBo, (Object)uocOrderAccessory);
                uocOrderAccessory.setCreateTime(new Date());
                uocOrderAccessory.setAttachmentType(1);
                uocOrderAccessory.setCreateOperId(String.valueOf(reqBo.getUserId()));
            }
        }
        UocAfterOrderCreateReqAddressBo uocAfterOrderCreateReqAddressBo = reqBo.getTakeAddress();
        UocAfterOrderCreateReqAddressBo returnAddress = reqBo.getReturnAddress();
        if (ObjectUtil.isNotEmpty((Object)uocAfterOrderCreateReqAddressBo)) {
            uocAfOrderDo.setTakeAddress(UocRu.js(uocAfterOrderCreateReqAddressBo, UocOrdLogisticsRela.class));
            uocAfOrderDo.getTakeAddress().setCreateOperId(String.valueOf(reqBo.getUserId()));
        }
        if (ObjectUtil.isNotEmpty((Object)returnAddress)) {
            uocAfOrderDo.setReturnAddress(UocRu.js(returnAddress, UocOrdLogisticsRela.class));
            uocAfOrderDo.getReturnAddress().setCreateOperId(String.valueOf(reqBo.getUserId()));
        }
        uocAfOrderDo.setSubContactName(reqBo.getName());
        uocAfOrderDo.setSubContactMobile(reqBo.getCellphone());
        uocAfOrderDo.setCreateTime(new Date());
        uocAfOrderDo.setCreateOperId(String.valueOf(reqBo.getUserId()));
        uocAfOrderDo.setSubmiteTime(new Date());
        uocAfOrderDo.setSubmitterOperId(String.valueOf(reqBo.getUserId()));
        uocAfOrderDo.setSubmitterOperName(reqBo.getName());
        uocAfOrderDo.setSubDeptId(String.valueOf(reqBo.getOrgId()));
        uocAfOrderDo.setSubDeptName(reqBo.getOrgName());
        uocAfOrderDo.setSubCompId(String.valueOf(reqBo.getCompanyId()));
        uocAfOrderDo.setSubCompName(reqBo.getCompanyName());
        uocAfOrderDo.setExtField2(reqBo.getClientName());
        uocAfOrderDo.setExtField3(reqBo.getClientPhone());
        UocSaleOrderDo uocSaleOrderDo = new UocSaleOrderDo();
        uocSaleOrderDo.setOrderId(reqBo.getOrderId());
        uocSaleOrderDo.setSaleOrderId(reqBo.getSaleOrderId());
        UocSaleOrderDo saleOrderMain = this.saleOrderModel.getSaleOrderMain(uocSaleOrderDo);
        uocAfOrderDo.setPayType(saleOrderMain.getPayType());
        String payType = uocAfOrderDo.getPayType();
        Integer payState = saleOrderMain.getPayState();
        if (UocDicConstant.PAY_TYPE.ADVANCE_PAYMENT_PRORATED.toString().equals(payType)) {
            uocAfOrderDo.setPayState(UocDicConstant.PAY_AFTER_STATE.RETURNING);
        } else if (UocDicConstant.PAY_TYPE.PAY_BY_PERIOD.toString().equals(payType)) {
            if (UocDicConstant.PAY_STATE.WAIT_PAY.equals(payState)) {
                uocAfOrderDo.setPayState(UocDicConstant.PAY_AFTER_STATE.UPDATEING);
            } else if (UocDicConstant.PAY_STATE.PAYED.equals(payState)) {
                uocAfOrderDo.setPayState(UocDicConstant.PAY_AFTER_STATE.RETURNING);
            }
        }
        uocAfOrderDo.setPayTypeStr(saleOrderMain.getPayTypeStr());
        return uocAfOrderDo;
    }

    private void validateArg(UocAfterOrderCreateReqBo reqBo) {
        if (reqBo == null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[UocAfterOrderCreateReqBo]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getShipOrderId())) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[\u53d1\u8d27\u5355ID]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getOrderId())) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[\u8ba2\u5355ID]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getSaleOrderId())) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[\u9500\u552e\u5355ID]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getServType())) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[\u670d\u52a1\u7c7b\u578b]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getAfsReason())) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[\u552e\u540e\u539f\u56e0]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getPickwareType())) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[\u53d6\u8d27\u670d\u52a1\u7c7b\u578b]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (UocConstant.AFTERORDER_PICKWARETYPE.UPDOORPICK.equals(reqBo.getPickwareType())) {
            if (ObjectUtil.isEmpty((Object)reqBo.getTakeAddress())) {
                throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[\u53d6\u4ef6\u5730\u5740]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (ObjectUtil.isEmpty((Object)reqBo.getTakeAddress().getContactProvinceId())) {
                throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[\u8054\u7cfb\u4eba\u7701\u4efd\u7f16\u53f7]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (ObjectUtil.isEmpty((Object)reqBo.getTakeAddress().getContactProvinceName())) {
                throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[\u8054\u7cfb\u4eba\u7701\u4efd\u540d\u79f0]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (ObjectUtil.isEmpty((Object)reqBo.getTakeAddress().getContactCityId())) {
                throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[\u8054\u7cfb\u4eba\u5730\u5e02\u7f16\u53f7]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (ObjectUtil.isEmpty((Object)reqBo.getTakeAddress().getContactCityName())) {
                throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[\u8054\u7cfb\u4eba\u5730\u5e02\u540d\u79f0]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (ObjectUtil.isEmpty((Object)reqBo.getTakeAddress().getContactCountyId())) {
                throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[\u8054\u7cfb\u4eba\u533a\u53bf\u7f16\u53f7]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (ObjectUtil.isEmpty((Object)reqBo.getTakeAddress().getContactAddress())) {
                throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[\u6536\u8d27\u4eba\u5730\u5740]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (ObjectUtil.isEmpty((Object)reqBo.getTakeAddress().getContactEmail())) {
                throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[\u8054\u7cfb\u4eba\u90ae\u4ef6]\u4e0d\u80fd\u4e3a\u7a7a");
            }
        }
        if (UocConstant.AFTERORDER_SERVTYPE.CHANGE.equals(reqBo.getServType())) {
            if (ObjectUtil.isEmpty((Object)reqBo.getReturnAddress())) {
                throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[\u8fd4\u4ef6\u5730\u5740]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (ObjectUtil.isEmpty((Object)reqBo.getReturnAddress().getContactProvinceId())) {
                throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[\u8054\u7cfb\u4eba\u7701\u4efd\u7f16\u53f7]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (ObjectUtil.isEmpty((Object)reqBo.getReturnAddress().getContactProvinceName())) {
                throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[\u8054\u7cfb\u4eba\u7701\u4efd\u540d\u79f0]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (ObjectUtil.isEmpty((Object)reqBo.getReturnAddress().getContactCityId())) {
                throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[\u8054\u7cfb\u4eba\u5730\u5e02\u7f16\u53f7]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (ObjectUtil.isEmpty((Object)reqBo.getReturnAddress().getContactCityName())) {
                throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[\u8054\u7cfb\u4eba\u5730\u5e02\u540d\u79f0]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (ObjectUtil.isEmpty((Object)reqBo.getReturnAddress().getContactCountyId())) {
                throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[\u8054\u7cfb\u4eba\u533a\u53bf\u7f16\u53f7]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (ObjectUtil.isEmpty((Object)reqBo.getReturnAddress().getContactAddress())) {
                throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[\u6536\u8d27\u4eba\u5730\u5740]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (ObjectUtil.isEmpty((Object)reqBo.getReturnAddress().getContactEmail())) {
                throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[\u8054\u7cfb\u4eba\u90ae\u4ef6]\u4e0d\u80fd\u4e3a\u7a7a");
            }
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getShipItemList())) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[\u552e\u540e\u660e\u7ec6]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        for (UocAfterOrderCreateReqItemBo uocAfterOrderCreateReqItemBo : reqBo.getShipItemList()) {
            if (ObjectUtil.isEmpty((Object)uocAfterOrderCreateReqItemBo.getShipOrderItemId())) {
                throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[\u53d1\u8d27\u660e\u7ec6ID]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (!ObjectUtil.isEmpty((Object)uocAfterOrderCreateReqItemBo.getReturnCount())) continue;
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[\u552e\u540e\u6570\u91cf]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

