/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.oc.service.domainservice;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.model.order.IUocOrderModel;
import com.tydic.dyc.oc.model.order.qrybo.UocOrdLogisticsRelaQryBo;
import com.tydic.dyc.oc.model.order.sub.UocOrdLogisticsRela;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderItemQryBo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderQryBo;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleOrderItem;
import com.tydic.dyc.oc.model.shiporder.IUocShipOrderModel;
import com.tydic.dyc.oc.model.shiporder.UocShipOrderDo;
import com.tydic.dyc.oc.model.shiporder.qrybo.UocShipOrderItemQryBo;
import com.tydic.dyc.oc.model.shiporder.qrybo.UocShipOrderQryBo;
import com.tydic.dyc.oc.model.shiporder.sub.UocShipOrderItem;
import com.tydic.dyc.oc.model.sysdictionary.IUocSysDictionaryModel;
import com.tydic.dyc.oc.service.domainservice.UocQryShipOrderDetailsService;
import com.tydic.dyc.oc.service.domainservice.bo.UocQryShipOrderDetailsLogisticsRelaBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocQryShipOrderDetailsReqBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocQryShipOrderDetailsRspBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocQryShipOrderDetailsRspDetailBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocQryShipOrderDetailsRspDetailItemBo;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"OC_GROUP_DEV/3.0.0/com.tydic.dyc.oc.service.domainservice.UocQryShipOrderDetailsService"})
public class UocQryShipOrderDetailsServiceImpl
implements UocQryShipOrderDetailsService {
    @Autowired
    private IUocShipOrderModel iUocShipOrderModel;
    @Autowired
    private IUocSaleOrderModel iUocSaleOrderModel;
    @Autowired
    private IUocSysDictionaryModel iUocSysDictionaryModel;
    @Autowired
    private IUocOrderModel orderModel;

    @PostMapping(value={"qryShipOrderDetails"})
    public UocQryShipOrderDetailsRspBo qryShipOrderDetails(@RequestBody UocQryShipOrderDetailsReqBo reqBo) {
        this.validateArg(reqBo);
        Map<String, Map<String, String>> dicMap = this.getDic();
        UocQryShipOrderDetailsRspDetailBo shipOrderDetailsInfo = this.queryShipOrderInfo(reqBo, dicMap);
        UocQryShipOrderDetailsLogisticsRelaBo orderLogisicsInfo = this.queryLogisticsInfo(reqBo.getOrderId());
        UocQryShipOrderDetailsRspBo rspBo = new UocQryShipOrderDetailsRspBo();
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        rspBo.setShipOrderInfo(shipOrderDetailsInfo);
        rspBo.setOrdLogisticsRela(orderLogisicsInfo);
        return rspBo;
    }

    private List<UocShipOrderItem> getShipOrderItemInfos(Long shipOrderId, Long orderId) {
        UocShipOrderItemQryBo qryItemListBo = new UocShipOrderItemQryBo();
        qryItemListBo.setShipOrderId(shipOrderId);
        qryItemListBo.setOrderId(orderId);
        UocShipOrderDo shipOrderItems = this.iUocShipOrderModel.getListShipOrderItem(qryItemListBo);
        if (null != shipOrderItems) {
            return shipOrderItems.getShipOrderItemBoList();
        }
        throw new BaseBusinessException("100001", "\u67e5\u8be2\u53d1\u8d27\u5355\u660e\u7ec6\u4fe1\u606f\u5931\u8d25");
    }

    private UocQryShipOrderDetailsRspDetailBo queryShipOrderInfo(UocQryShipOrderDetailsReqBo reqBo, Map<String, Map<String, String>> dicMap) {
        UocShipOrderQryBo uocShipOrderQryBo = new UocShipOrderQryBo();
        uocShipOrderQryBo.setOrderId(reqBo.getOrderId());
        uocShipOrderQryBo.setShipOrderId(reqBo.getShipOrderId());
        UocShipOrderDo shipOrderInfo = this.iUocShipOrderModel.getShipOrderById(uocShipOrderQryBo);
        if (null != shipOrderInfo) {
            UocQryShipOrderDetailsRspDetailBo uocQryShipOrderDetailsRspDetailBo = (UocQryShipOrderDetailsRspDetailBo)JSONObject.parseObject((String)JSON.toJSONString((Object)shipOrderInfo), UocQryShipOrderDetailsRspDetailBo.class);
            uocQryShipOrderDetailsRspDetailBo.setShipOrderStateStr(dicMap.get("SHIP_ORDER_STATE").get(shipOrderInfo.getShipOrderState()));
            UocSaleOrderDo saleOrderInfo = this.getSaleOrderDo(shipOrderInfo.getSaleOrderId(), shipOrderInfo.getOrderId());
            if (ObjectUtil.isNotEmpty((Object)saleOrderInfo.getStakeholder())) {
                BeanUtils.copyProperties((Object)saleOrderInfo.getStakeholder(), (Object)uocQryShipOrderDetailsRspDetailBo);
                uocQryShipOrderDetailsRspDetailBo.setSaleOrderNo(saleOrderInfo.getSaleOrderNo());
            }
            List<UocSaleOrderItem> saleOrderItemInfos = this.getSaleOrderItemInfos(shipOrderInfo.getSaleOrderId(), shipOrderInfo.getOrderId());
            Map<Long, UocSaleOrderItem> saleOrderItemMap = saleOrderItemInfos.stream().collect(Collectors.toMap(UocSaleOrderItem::getSaleOrderItemId, o -> o));
            List<UocShipOrderItem> shipOrderItemInfos = this.getShipOrderItemInfos(reqBo.getShipOrderId(), reqBo.getOrderId());
            ArrayList<UocQryShipOrderDetailsRspDetailItemBo> shipOrderItemBoList = new ArrayList<UocQryShipOrderDetailsRspDetailItemBo>();
            for (UocShipOrderItem shipOrderItem : shipOrderItemInfos) {
                UocQryShipOrderDetailsRspDetailItemBo rspItemBo = new UocQryShipOrderDetailsRspDetailItemBo();
                BeanUtils.copyProperties((Object)shipOrderItem, (Object)rspItemBo);
                if (saleOrderItemMap.containsKey(shipOrderItem.getSaleOrderItemId())) {
                    UocSaleOrderItem saleOrderItem = saleOrderItemMap.get(shipOrderItem.getSaleOrderItemId());
                    if (shipOrderItem.getSendCount() != null && shipOrderItem.getReturnCount() != null && saleOrderItem.getAfterServingCount() != null) {
                        BigDecimal afterCountEnable = shipOrderItem.getSendCount().subtract(shipOrderItem.getReturnCount()).subtract(saleOrderItem.getAfterServingCount());
                        rspItemBo.setAvailableAfServCount(afterCountEnable);
                    }
                    BeanUtils.copyProperties((Object)saleOrderItem, (Object)rspItemBo);
                    rspItemBo.setRefuseCount(shipOrderItem.getRefuseCount());
                }
                if (ObjectUtil.isNotEmpty((Object)shipOrderItem.getShipItemState())) {
                    rspItemBo.setShipItemStateStr(dicMap.get("SHIP_ORDER_STATE").get(shipOrderItem.getShipItemState()));
                } else {
                    rspItemBo.setShipItemStateStr(dicMap.get("SHIP_ORDER_STATE").get(shipOrderInfo.getShipOrderState()));
                }
                shipOrderItemBoList.add(rspItemBo);
            }
            uocQryShipOrderDetailsRspDetailBo.setShipOrderItemBoList(shipOrderItemBoList);
            return uocQryShipOrderDetailsRspDetailBo;
        }
        throw new BaseBusinessException("100001", "\u67e5\u8be2\u53d1\u8d27\u5355\u4fe1\u606f\u5931\u8d25");
    }

    private UocQryShipOrderDetailsLogisticsRelaBo queryLogisticsInfo(Long orderId) {
        UocOrdLogisticsRelaQryBo uocOrdLogisticsRelaQryBo = new UocOrdLogisticsRelaQryBo();
        uocOrdLogisticsRelaQryBo.setOrderId(orderId);
        UocOrdLogisticsRela uocOrdLogisticsRela = this.orderModel.qryOrderLogisticsRela(uocOrdLogisticsRelaQryBo);
        if (null != uocOrdLogisticsRela) {
            UocQryShipOrderDetailsLogisticsRelaBo uocQryShipOrderDetailsLogisticsRelaBo = new UocQryShipOrderDetailsLogisticsRelaBo();
            BeanUtils.copyProperties((Object)uocOrdLogisticsRela, (Object)uocQryShipOrderDetailsLogisticsRelaBo);
            return uocQryShipOrderDetailsLogisticsRelaBo;
        }
        throw new BaseBusinessException("100001", "\u67e5\u8be2\u8ba2\u5355\u6536\u8d27\u5730\u5740\u4fe1\u606f\u5931\u8d25");
    }

    private void validateArg(UocQryShipOrderDetailsReqBo reqBo) {
        if (reqBo == null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[UocQryShipOrderDetailsReqBo]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getOrderId())) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[\u8ba2\u5355ID]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getShipOrderId())) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[\u53d1\u8d27\u5355ID]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private UocSaleOrderDo getSaleOrderDo(Long saleOrderId, Long orderId) {
        UocSaleOrderQryBo uocSaleOrderQryBo = new UocSaleOrderQryBo();
        uocSaleOrderQryBo.setSaleOrderId(saleOrderId);
        uocSaleOrderQryBo.setOrderId(orderId);
        UocSaleOrderDo uocSaleOrderDo = this.iUocSaleOrderModel.qrySaleOrder(uocSaleOrderQryBo);
        if (null != uocSaleOrderDo) {
            return uocSaleOrderDo;
        }
        throw new BaseBusinessException("100001", "\u67e5\u8be2\u9500\u552e\u5355\u4e3b\u4f53\u4fe1\u606f\u5931\u8d25");
    }

    private List<UocSaleOrderItem> getSaleOrderItemInfos(Long saleOrderId, Long orderId) {
        UocSaleOrderItemQryBo uocSaleOrderItemQryBo = new UocSaleOrderItemQryBo();
        uocSaleOrderItemQryBo.setSaleOrderId(saleOrderId);
        uocSaleOrderItemQryBo.setOrderId(orderId);
        UocSaleOrderDo saleOrderItems = this.iUocSaleOrderModel.qryListSaleOrderItem(uocSaleOrderItemQryBo);
        if (null != saleOrderItems) {
            return saleOrderItems.getSaleOrderItems();
        }
        throw new BaseBusinessException("100001", "\u67e5\u8be2\u9500\u552e\u5355\u660e\u7ec6\u4fe1\u606f\u5931\u8d25");
    }

    private Map<String, Map<String, String>> getDic() {
        ArrayList<String> pCodes = new ArrayList<String>();
        pCodes.add("SHIP_ORDER_STATE");
        Map<String, Map<String, String>> dictionaryMap = this.iUocSysDictionaryModel.getDictionaryMap(pCodes);
        if (CollectionUtil.isNotEmpty(dictionaryMap)) {
            return dictionaryMap;
        }
        throw new BaseBusinessException("100001", "\u67e5\u8be2\u5b57\u5178\u5931\u8d25");
    }
}

