/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.oc.service.domainservice;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.alibaba.fastjson.JSONObject;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.components.ordSourceProcessor.UocOrderSourceProcessor;
import com.tydic.dyc.oc.components.ordSourceProcessor.UocOrderSourceProcessorManager;
import com.tydic.dyc.oc.constants.UocConstant;
import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.model.order.IUocOrderModel;
import com.tydic.dyc.oc.model.order.UocOrderDo;
import com.tydic.dyc.oc.model.order.qrybo.UocOrderStakeholderQryBo;
import com.tydic.dyc.oc.model.order.sub.UocOrdInvoice;
import com.tydic.dyc.oc.model.order.sub.UocOrdLogisticsRela;
import com.tydic.dyc.oc.model.order.sub.UocOrderAccessory;
import com.tydic.dyc.oc.model.order.sub.UocOrderAgreement;
import com.tydic.dyc.oc.model.order.sub.UocOrderItem;
import com.tydic.dyc.oc.model.order.sub.UocOrderMap;
import com.tydic.dyc.oc.model.order.sub.UocOrderOperating;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleOrderItem;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleOrderPayConf;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleStakeholder;
import com.tydic.dyc.oc.service.common.bo.UocBaseExtParallelBo;
import com.tydic.dyc.oc.service.domainservice.UocCreateOrderService;
import com.tydic.dyc.oc.service.domainservice.bo.UocCreateOrderServiceReqAccessoryBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocCreateOrderServiceReqAddressBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocCreateOrderServiceReqAgrBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocCreateOrderServiceReqArgPayConfSupBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocCreateOrderServiceReqBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocCreateOrderServiceReqCommodityBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocCreateOrderServiceReqInvoiceBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocCreateOrderServiceReqPayConfBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocCreateOrderServiceReqPayConfSupBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocCreateOrderServiceReqProfessionalBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocCreateOrderServiceRspBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocCreateOrderServiceRspSaleOrderBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocCreateOrderServiceRspSaleOrderItemBo;
import com.tydic.dyc.oc.utils.UocRu;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;

@HSFProvider(serviceVersion="3.0.0", serviceGroup="OC_GROUP_DEV", serviceInterface=UocCreateOrderService.class)
public class UocCreateOrderServiceImpl
implements UocCreateOrderService {
    @Autowired
    private IUocOrderModel iUocOrderModel;
    @Autowired
    private IUocSaleOrderModel iUocSaleOrderModel;
    @Autowired
    private UocOrderSourceProcessorManager uocOrderSourceProcessorManager;

    public UocCreateOrderServiceRspBo createOrder(UocCreateOrderServiceReqBo reqBo) {
        this.validateArg(reqBo);
        UocCreateOrderServiceRspBo rspBo = UocRu.success(UocCreateOrderServiceRspBo.class);
        UocOrderDo createDo = this.convertOrderDo(reqBo);
        UocOrderDo createOrderRet = this.iUocOrderModel.createOrder(createDo);
        rspBo.setTotalSaleFee(createDo.getTotalSaleFee());
        rspBo.setTotalPurchaseFee(createDo.getTotalPurchaseFee());
        rspBo.setSaleOrderList(new ArrayList());
        JSONObject supSignInfo = reqBo.getJsonObj();
        if (reqBo.getCreateSaleOrder().booleanValue()) {
            List<UocSaleOrderItem> uocSaleOrderItemList = this.orderDo2SaleDo(createOrderRet, reqBo);
            List<UocSaleOrderDo> splitSaleOrderList = this.splitSaleOrder(createOrderRet, reqBo, uocSaleOrderItemList, supSignInfo);
            for (UocSaleOrderDo saleOrderDo : splitSaleOrderList) {
                UocSaleOrderDo saleOrderRet = this.iUocSaleOrderModel.createSaleOrder(saleOrderDo);
                UocCreateOrderServiceRspSaleOrderBo orderItemRspData = new UocCreateOrderServiceRspSaleOrderBo();
                BeanUtils.copyProperties((Object)saleOrderRet, (Object)orderItemRspData);
                BeanUtils.copyProperties((Object)saleOrderRet.getStakeholder(), (Object)orderItemRspData);
                orderItemRspData.setSaleOrderId(saleOrderRet.getSaleOrderId());
                List<UocCreateOrderServiceRspSaleOrderItemBo> itemList = UocRu.jsl(saleOrderRet.getSaleOrderItems(), UocCreateOrderServiceRspSaleOrderItemBo.class);
                orderItemRspData.setItemBoList(itemList);
                orderItemRspData.setSaleOrderNo(saleOrderRet.getSaleOrderNo());
                orderItemRspData.setOrderSource(saleOrderRet.getOrderSource());
                orderItemRspData.setAgrId(saleOrderRet.getAgreementId());
                orderItemRspData.setPayType(saleOrderRet.getPayType() != null ? Integer.valueOf(saleOrderRet.getPayType()) : null);
                rspBo.getSaleOrderList().add(orderItemRspData);
            }
        }
        rspBo.setOrderId(createDo.getOrderId());
        rspBo.setOrderNo(createDo.getOrderNo());
        return rspBo;
    }

    private List<UocSaleOrderDo> splitSaleOrder(UocOrderDo createOrderRet, UocCreateOrderServiceReqBo reqBo, List<UocSaleOrderItem> uocSaleOrderItemList, JSONObject supSignInfo) {
        ArrayList<UocSaleOrderDo> splitSaleOrderList = new ArrayList<UocSaleOrderDo>();
        ArrayList<List<UocSaleOrderItem>> splitSaleOrderRet = new ArrayList<List<UocSaleOrderItem>>();
        Map<Integer, List<UocSaleOrderItem>> saleItemMap = uocSaleOrderItemList.stream().collect(Collectors.groupingBy(UocSaleOrderItem::getSkuSource));
        for (Map.Entry<Integer, List<UocSaleOrderItem>> entry : saleItemMap.entrySet()) {
            UocOrderSourceProcessor instance = this.uocOrderSourceProcessorManager.getInstance(entry.getKey());
            splitSaleOrderRet.addAll(instance.splitSaleOrder(entry.getValue()));
        }
        UocOrderStakeholderQryBo qryStakeholderList = new UocOrderStakeholderQryBo();
        qryStakeholderList.setOrderId(createOrderRet.getOrderId());
        List<UocOrderStakeholderQryBo> uocOrderStakeholderQryBos = this.iUocOrderModel.qryStakeholderList(qryStakeholderList);
        Map<String, List<UocOrderStakeholderQryBo>> supStakeMap = uocOrderStakeholderQryBos.stream().collect(Collectors.groupingBy(UocOrderStakeholderQryBo::getSupId));
        List payConfigList = reqBo.getPayConfigList();
        Map<Object, Object> payConfMap = new HashMap();
        if (ObjectUtil.isNotEmpty((Object)payConfigList)) {
            payConfMap = payConfigList.stream().collect(Collectors.toMap(UocCreateOrderServiceReqPayConfSupBo::getSupId, item -> item));
        }
        List agrPayConfigList = reqBo.getAgrPayConfigList();
        Map<Object, Object> agrPayConfigMap = new HashMap();
        if (ObjectUtil.isNotEmpty((Object)agrPayConfigList)) {
            agrPayConfigMap = agrPayConfigList.stream().collect(Collectors.toMap(UocCreateOrderServiceReqArgPayConfSupBo::getAgrId, item -> item));
        }
        List<UocOrderItem> orderItems = createOrderRet.getOrderItems();
        List agrList = orderItems.stream().map(UocOrderItem::getAgrBo).collect(Collectors.toList());
        boolean hasAgrComm = false;
        for (UocOrderItem orderItem : orderItems) {
            if (!ObjectUtil.isNotEmpty((Object)orderItem.getAgrBo())) continue;
            hasAgrComm = true;
        }
        Map<Object, Object> agrMap = new HashMap();
        if (hasAgrComm) {
            agrMap = agrList.stream().collect(Collectors.toMap(UocOrderAgreement::getAgreementId, item -> item));
        }
        for (List list : splitSaleOrderRet) {
            UocSaleOrderDo saleOrderDo = UocRu.js((Object)createOrderRet, UocSaleOrderDo.class);
            splitSaleOrderList.add(saleOrderDo);
            String supplierId = ((UocSaleOrderItem)list.get(0)).getSupplierId();
            saleOrderDo.setOrderSource(((UocSaleOrderItem)list.get(0)).getSkuSource());
            saleOrderDo.setOrderId(createOrderRet.getOrderId());
            saleOrderDo.setCreateOperId(createOrderRet.getCreateOperId());
            saleOrderDo.setStakeholderId(supStakeMap.get(supplierId).get(0).getStakeholderId());
            saleOrderDo.setStakeholder(UocRu.js(supStakeMap.get(supplierId).get(0), UocSaleStakeholder.class));
            BigDecimal totalSaleFee = this.getTotalSaleFeeWithSaleItem(list);
            saleOrderDo.setTotalSaleFee(totalSaleFee);
            saleOrderDo.setTotalPurchaseFee(this.getTotalPurchaseFeeWithSaleItem(list));
            saleOrderDo.setSendTime(createOrderRet.getSendTime());
            saleOrderDo.setCreateOperId(createOrderRet.getCreateOperId());
            saleOrderDo.setCreatedResult(reqBo.getCreatedResult());
            String agreementId = ((UocSaleOrderItem)list.get(0)).getAgreementId();
            String monthReceiveNode = supSignInfo.getJSONObject(supplierId).getString("monthReceiveNode");
            if ("1".equals(monthReceiveNode)) {
                saleOrderDo.setIsCreateServiceFee(true);
            }
            if (ObjectUtil.isNotEmpty((Object)agreementId)) {
                saleOrderDo.setSaleOrderPayConfList(UocRu.jsl(((UocCreateOrderServiceReqArgPayConfSupBo)agrPayConfigMap.get(agreementId)).getConfBos(), UocSaleOrderPayConf.class));
                saleOrderDo.setModelSettle(((UocCreateOrderServiceReqArgPayConfSupBo)agrPayConfigMap.get(agreementId)).getConfBos().size() == 1 ? UocConstant.ModelSettle.CH : UocConstant.ModelSettle.MY);
            } else {
                saleOrderDo.setSaleOrderPayConfList(UocRu.jsl(((UocCreateOrderServiceReqPayConfSupBo)payConfMap.get(supplierId)).getConfBos(), UocSaleOrderPayConf.class));
                saleOrderDo.setModelSettle(((UocCreateOrderServiceReqPayConfSupBo)payConfMap.get(supplierId)).getConfBos().size() == 1 ? UocConstant.ModelSettle.CH : UocConstant.ModelSettle.MY);
            }
            List<UocSaleOrderPayConf> payConfs = saleOrderDo.getSaleOrderPayConfList();
            for (UocSaleOrderPayConf payConf : payConfs) {
                if (UocDicConstant.PAY_TYPE.ADVANCE_PAYMENT_PRORATED.equals(payConf.getPayType())) {
                    payConf.setPrePayFee(totalSaleFee);
                    continue;
                }
                if (UocDicConstant.PAY_TYPE.PAY_BY_AGR_CONSTRAINT.equals(payConf.getPayType())) {
                    if (ObjectUtil.isNotEmpty((Object)payConf.getPrePaySup())) {
                        payConf.setPrePayFee(totalSaleFee.multiply(payConf.getPrePaySup()));
                    }
                    if (ObjectUtil.isNotEmpty((Object)payConf.getVerPaySup())) {
                        payConf.setVerPayFee(totalSaleFee.multiply(payConf.getVerPaySup()));
                    }
                    if (ObjectUtil.isNotEmpty((Object)payConf.getPilPaySup())) {
                        payConf.setPilPayFee(totalSaleFee.multiply(payConf.getPilPaySup()));
                    }
                    if (!ObjectUtil.isNotEmpty((Object)payConf.getQuaPaySup())) continue;
                    payConf.setQuaPayFee(totalSaleFee.multiply(payConf.getQuaPaySup()));
                    continue;
                }
                payConf.setPrePayFee(new BigDecimal(0));
                payConf.setVerPayFee(new BigDecimal(0));
                payConf.setPilPayFee(new BigDecimal(0));
                payConf.setQuaPayFee(new BigDecimal(0));
            }
            saleOrderDo.setSaleOrderItems(list);
            if (!ObjectUtil.isNotEmpty((Object)agreementId)) continue;
            UocOrderAgreement uocOrderAgreement = (UocOrderAgreement)agrMap.get(agreementId);
            saleOrderDo.setAdjustPrice(uocOrderAgreement.getAdjustPrice());
            saleOrderDo.setAgreementId(agreementId);
            saleOrderDo.setAgreementNo(((UocSaleOrderItem)list.get(0)).getAgreementNo());
            saleOrderDo.setAgrDataId(uocOrderAgreement.getId());
            saleOrderDo.setProDeliveryId(uocOrderAgreement.getProducerId() != null ? uocOrderAgreement.getProducerId().toString() : null);
            saleOrderDo.setProDeliveryName(uocOrderAgreement.getProducerName());
        }
        return splitSaleOrderList;
    }

    private List<UocSaleOrderItem> orderDo2SaleDo(UocOrderDo createOrderRet, UocCreateOrderServiceReqBo reqBo) {
        List<UocOrderItem> orderItems = createOrderRet.getOrderItems();
        ArrayList<UocSaleOrderItem> saleOrderItemList = new ArrayList<UocSaleOrderItem>();
        for (UocOrderItem orderItem : orderItems) {
            UocSaleOrderItem saleItemDo = UocRu.js(orderItem, UocSaleOrderItem.class);
            saleOrderItemList.add(saleItemDo);
        }
        return saleOrderItemList;
    }

    private BigDecimal getTotalPurchaseFeeWithSaleItem(List<UocSaleOrderItem> orderItem) {
        BigDecimal saleFee = new BigDecimal(0);
        for (UocSaleOrderItem uocOrderItem : orderItem) {
            saleFee = saleFee.add(uocOrderItem.getPurchaseCount().multiply(uocOrderItem.getPurchasePrice()));
        }
        return saleFee;
    }

    private BigDecimal getTotalSaleFeeWithSaleItem(List<UocSaleOrderItem> orderItem) {
        BigDecimal saleFee = new BigDecimal(0);
        for (UocSaleOrderItem uocOrderItem : orderItem) {
            saleFee = saleFee.add(uocOrderItem.getPurchaseCount().multiply(uocOrderItem.getSalePrice()));
        }
        return saleFee;
    }

    private UocOrderDo convertOrderDo(UocCreateOrderServiceReqBo reqBo) {
        UocOrderDo orderDo = UocRu.js(reqBo, UocOrderDo.class);
        orderDo.setCreateOperId(reqBo.getUserId().toString());
        orderDo.setCreateOperName(reqBo.getName());
        if (ObjectUtil.isNotEmpty((Object)reqBo.getOrderParallelExtList())) {
            orderDo.setOrderExt(UocRu.jsl(reqBo.getOrderParallelExtList(), UocOrderMap.class));
        }
        if (ObjectUtil.isNotEmpty((Object)reqBo.getInvoiceBO())) {
            orderDo.setUocOrdInvoice(UocRu.js(reqBo.getInvoiceBO(), UocOrdInvoice.class));
        }
        if (ObjectUtil.isNotEmpty((Object)reqBo.getAddressBo())) {
            orderDo.setReceiverAddress(UocRu.js(reqBo.getAddressBo(), UocOrdLogisticsRela.class));
        }
        if (ObjectUtil.isNotEmpty((Object)reqBo.getInvoiceAddressBo())) {
            orderDo.setInvoiceAddress(UocRu.js(reqBo.getInvoiceAddressBo(), UocOrdLogisticsRela.class));
        }
        if (ObjectUtil.isNotEmpty((Object)reqBo.getAccessoryList())) {
            orderDo.setAccessoryList(UocRu.jsl(reqBo.getAccessoryList(), UocOrderAccessory.class));
        }
        orderDo.setOperating(UocRu.js(reqBo.getProfessionalBo(), UocOrderOperating.class));
        this.setOrderItems(reqBo, orderDo);
        return orderDo;
    }

    private void setOrderItems(UocCreateOrderServiceReqBo reqBo, UocOrderDo orderDo) {
        List commodityBos = reqBo.getCommodityBos();
        orderDo.setOrderItems(new ArrayList<UocOrderItem>(commodityBos.size()));
        for (UocCreateOrderServiceReqCommodityBo commodityBo : commodityBos) {
            UocOrderItem orderItem = UocRu.js(commodityBo, UocOrderItem.class);
            orderItem.setSupplierId(commodityBo.getSupId());
            orderItem.setSupplierName(commodityBo.getSupName());
            orderItem.setItemType(UocDicConstant.ORDER_ITEM_TYPE.SKU);
            orderDo.getOrderItems().add(orderItem);
        }
    }

    private void validateArg(UocCreateOrderServiceReqBo reqBo) {
        if (reqBo == null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[UocCreateOrderServiceReqBo]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getUserId())) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[\u7528\u6237id]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        BigDecimal totalSaleFee = reqBo.getTotalSaleFee();
        BigDecimal totalPurchaseFee = reqBo.getTotalPurchaseFee();
        if (ObjectUtil.isEmpty((Object)totalSaleFee)) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[\u9500\u552e\u603b\u91d1\u989d]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)totalPurchaseFee)) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[\u91c7\u8d2d\u603b\u91d1\u989d]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getCommodityBos())) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[\u5546\u54c1\u4fe1\u606f]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getAddressBo())) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[\u6536\u8d27\u4eba\u5730\u5740\u4fe1\u606f]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        BigDecimal realTotalSaleFee = new BigDecimal(0);
        BigDecimal realTotalPurchaseFee = new BigDecimal(0);
        for (UocCreateOrderServiceReqCommodityBo commodityBo : reqBo.getCommodityBos()) {
            this.validateCommodityBo(commodityBo);
            BigDecimal singleSalePrice = commodityBo.getSalePrice().multiply(commodityBo.getPurchaseCount());
            BigDecimal singlePurchasePrice = commodityBo.getPurchasePrice().multiply(commodityBo.getPurchaseCount());
            realTotalSaleFee = realTotalSaleFee.add(singleSalePrice);
            realTotalPurchaseFee = realTotalPurchaseFee.add(singlePurchasePrice);
        }
        if (totalSaleFee.compareTo(realTotalSaleFee) != 0) {
            throw new BaseBusinessException("100001", "\u9500\u552e\u603b\u4ef7\u683c(" + totalSaleFee + ")\u4e0d\u7b49\u4e8e\u6240\u6709\u5546\u54c1\u603b\u4ef7\u683c(" + realTotalSaleFee + ")");
        }
        if (totalPurchaseFee.compareTo(realTotalPurchaseFee) != 0) {
            throw new BaseBusinessException("100001", "\u91c7\u8d2d\u603b\u4ef7\u683c(" + totalPurchaseFee + ")\u4e0d\u7b49\u4e8e\u6240\u6709\u5546\u54c1\u603b\u4ef7\u683c(" + realTotalPurchaseFee + ")");
        }
        boolean hasAgrComm = false;
        for (UocCreateOrderServiceReqCommodityBo commodityBo : reqBo.getCommodityBos()) {
            if (!ObjectUtil.isNotEmpty((Object)commodityBo.getAgreementId())) continue;
            hasAgrComm = true;
            break;
        }
        if (hasAgrComm && ObjectUtil.isEmpty((Object)reqBo.getAgrPayConfigList())) {
            throw new BaseBusinessException("100001", "\u5f53\u6709\u534f\u8bae\u5546\u54c1\u65f6\uff0c\u534f\u8bae\u652f\u4ed8\u914d\u7f6e\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.validateNoArgPayConf(reqBo.getPayConfigList());
        this.validateArgPayConf(reqBo.getAgrPayConfigList());
        this.validateUocCreateOrderServiceReqAddressBo(reqBo.getAddressBo());
        if (ObjectUtil.isNotEmpty((Object)reqBo.getInvoiceAddressBo())) {
            this.validateUocCreateOrderServiceReqAddressBo(reqBo.getInvoiceAddressBo());
        }
        if (ObjectUtil.isNotEmpty((Object)reqBo.getInvoiceBO())) {
            this.validateUocCreateOrderServiceReqInvoiceBo(reqBo.getInvoiceBO());
        }
        if (ObjectUtil.isNotEmpty((Object)reqBo.getAccessoryList())) {
            for (UocCreateOrderServiceReqAccessoryBo uocCreateOrderServiceReqAccessoryBo : reqBo.getAccessoryList()) {
                this.validateUocCreateOrderServiceReqAccessoryBo(uocCreateOrderServiceReqAccessoryBo);
            }
        }
        if (ObjectUtil.isNotEmpty((Object)reqBo.getOrderParallelExtList())) {
            for (UocBaseExtParallelBo uocBaseExtParallelBo : reqBo.getOrderParallelExtList()) {
                this.validateUocBaseExtParallelBo(uocBaseExtParallelBo);
            }
        }
    }

    private void validateArgPayConf(List<UocCreateOrderServiceReqArgPayConfSupBo> agrPayConfigList) {
        if (ObjectUtil.isNotEmpty(agrPayConfigList)) {
            for (UocCreateOrderServiceReqArgPayConfSupBo uocCreateOrderServiceReqPayConfSupBo : agrPayConfigList) {
                this.validateAgrPayConfBo(uocCreateOrderServiceReqPayConfSupBo);
            }
        }
    }

    private void validateAgrPayConfBo(UocCreateOrderServiceReqArgPayConfSupBo reqBo) {
        if (reqBo == null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[UocCreateOrderServiceReqArgPayConfSupBo]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getAgrId())) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[\u534f\u8baeid]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getConfBos())) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[\u4f9b\u5e94\u5546\u914d\u7f6e]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        for (UocCreateOrderServiceReqPayConfBo confBo : reqBo.getConfBos()) {
            this.validatePayConfBo(confBo);
        }
    }

    private void validateNoArgPayConf(List<UocCreateOrderServiceReqPayConfSupBo> reqBo) {
        if (ObjectUtil.isNotEmpty(reqBo)) {
            for (UocCreateOrderServiceReqPayConfSupBo uocCreateOrderServiceReqPayConfSupBo : reqBo) {
                this.validateNoAgrPayConfBo(uocCreateOrderServiceReqPayConfSupBo);
            }
        }
    }

    private void validateNoAgrPayConfBo(UocCreateOrderServiceReqPayConfSupBo reqBo) {
        if (reqBo == null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[UocCreateOrderServiceReqPayConfSupBo]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getSupId())) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[\u4f9b\u5e94\u5546id]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getConfBos())) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[\u4f9b\u5e94\u5546\u914d\u7f6e]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        for (UocCreateOrderServiceReqPayConfBo confBo : reqBo.getConfBos()) {
            this.validatePayConfBo(confBo);
        }
    }

    private void validatePayConfBo(UocCreateOrderServiceReqPayConfBo reqBo) {
        if (reqBo == null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[UocCreateOrderServiceReqPayConfBo]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getModelSettle())) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[\u7ed3\u7b97\u6a21\u5f0f]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getPayType())) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[\u4ed8\u6b3e\u65b9\u5f0f]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private void validateUocCreateOrderServiceReqAccessoryBo(UocCreateOrderServiceReqAccessoryBo reqBo) {
        if (reqBo == null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[UocCreateOrderServiceReqAccessoryBo]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getAccessoryName())) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[\u9644\u4ef6\u540d\u79f0]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getAccessoryUrl())) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[\u9644\u4ef6url]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private void validateUocCreateOrderServiceReqInvoiceBo(UocCreateOrderServiceReqInvoiceBo reqBo) {
        if (reqBo == null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[UocCreateOrderServiceReqInvoiceBo]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private void validateUocCreateOrderServiceReqAddressBo(UocCreateOrderServiceReqAddressBo reqBo) {
        if (reqBo == null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[UocCreateOrderServiceReqAddressBo]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getContactProvinceId())) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[\u8054\u7cfb\u4eba\u7701\u4efd\u7f16\u53f7]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getContactProvinceName())) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[\u8054\u7cfb\u4eba\u7701\u4efd\u540d\u79f0]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getContactCityId())) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[\u8054\u7cfb\u4eba\u5730\u5e02\u7f16\u53f7]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getContactCityName())) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[\u8054\u7cfb\u4eba\u5730\u5e02\u540d\u79f0]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getContactCountyId())) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[\u8054\u7cfb\u4eba\u533a\u53bf\u7f16\u53f7]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getContactCountyName())) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[\u8054\u7cfb\u4eba\u533a\u53bf\u540d\u79f0]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getContactAddress())) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[\u6536\u8d27\u4eba\u5730\u5740]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getContactName())) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[\u8054\u7cfb\u4eba\u540d\u79f0]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getContactEmail())) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[\u8054\u7cfb\u4eba\u90ae\u4ef6]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getContactMobile())) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[\u8054\u7cfb\u4eba\u624b\u673a]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private void validateUocCreateOrderServiceReqProfessionalBo(UocCreateOrderServiceReqProfessionalBo reqBo) {
        if (reqBo == null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[UocCreateOrderServiceReqProfessionalBo]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getProId())) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[\u8fd0\u8425\u5355\u4f4d\u673a\u6784id]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getProName())) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[\u8fd0\u8425\u673a\u6784\u540d\u79f0]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getProOrgPath())) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[\u8fd0\u8425\u673a\u6784\u673a\u6784\u6811\u8def\u5f84]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private void validateCommodityBo(UocCreateOrderServiceReqCommodityBo reqBo) {
        if (reqBo == null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[UocCreateOrderServiceReqCommodityBo]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getSkuId())) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[\u5355\u54c1ID]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getSkuName())) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[\u5355\u54c1\u540d\u79f0]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getCommodityId())) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[\u5546\u54c1id]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getCommodityName())) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[\u5546\u54c1\u540d\u79f0]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getSupId())) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[\u4f9b\u5e94\u5546id]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getSupName())) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[\u4f9b\u5e94\u5546\u540d\u79f0]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getSupplierShopId())) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[\u5e97\u94faID]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getPurchasePrice())) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[\u91c7\u8d2d\u5355\u4ef7]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getSalePrice())) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[\u9500\u552e\u5355\u4ef7]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getPurchaseCount())) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[\u91c7\u8d2d\u6570\u91cf]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getSkuSource())) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[\u5546\u54c1\u6765\u6e90]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (UocDicConstant.ORDER_SOURCE.AGR_GENERATE.equals(reqBo.getSkuSource()) && ObjectUtil.isEmpty((Object)reqBo.getAgreementId())) {
            throw new BaseBusinessException("100001", "\u534f\u8bae\u5546\u54c1(skuId:" + reqBo.getSkuId() + ")\uff0c\u534f\u8baeid\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!ObjectUtil.isEmpty((Object)reqBo.getAgreementId())) {
            if (ObjectUtil.isEmpty((Object)reqBo.getAgrBo())) {
                throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[\u534f\u8bae\u5bf9\u8c61]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            this.validateAgrBo(reqBo.getAgrBo());
            reqBo.setAgreementCode(reqBo.getAgrBo().getAgreementCode().toString());
        }
        if (ObjectUtil.isNotEmpty((Object)reqBo.getSaleItemParallelExtList())) {
            for (UocBaseExtParallelBo uocBaseExtParallelBo : reqBo.getSaleItemParallelExtList()) {
                this.validateUocBaseExtParallelBo(uocBaseExtParallelBo);
            }
        }
    }

    private void validateAgrBo(UocCreateOrderServiceReqAgrBo reqBo) {
        if (reqBo == null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[UocCreateOrderServiceReqAgrBo]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getAgreementId())) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[\u534f\u8baeId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getAgreementCode())) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[\u534f\u8bae\u6a21\u5f0f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getAdjustPrice())) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[0\uff1a\u65e0\uff0c1\uff1a\u4e8b\u524d\u8c03\u4ef7\uff0c2\uff1a\u4e8b\u4e2d\u8c03\u4ef7 \u9ed8\u8ba4\u503c\uff1a0]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private void validateUocBaseExtParallelBo(UocBaseExtParallelBo reqBo) {
        if (reqBo == null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[UocBaseExtParallelBo]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getFieldCode())) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[\u5b57\u6bb5\u7f16\u7801]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getFieldValue())) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[\u5b57\u6bb5\u503c]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

