/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.oc.service.domainservice;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.constants.UocConstant;
import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.constants.UocStateConstants;
import com.tydic.dyc.oc.model.chngorder.IUocChngOrderModel;
import com.tydic.dyc.oc.model.chngorder.UocChngOrderDo;
import com.tydic.dyc.oc.model.chngorder.sub.UocChngOrderItemObj;
import com.tydic.dyc.oc.model.chngorder.sub.UocChngOrderMap;
import com.tydic.dyc.oc.model.chngorder.sub.UocChngOrderObj;
import com.tydic.dyc.oc.model.common.IUocCommonModel;
import com.tydic.dyc.oc.model.common.UocCommonDo;
import com.tydic.dyc.oc.model.order.sub.UocOrderAccessory;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleOrderMap;
import com.tydic.dyc.oc.service.domainservice.UocAdjustPriceOrderCreateService;
import com.tydic.dyc.oc.service.domainservice.bo.UocAdjustPriceOrderCreateReqBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocAdjustPriceOrderCreateRspBo;
import com.tydic.dyc.oc.service.saleorder.bo.UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo;
import com.tydic.dyc.oc.utils.IdUtil;
import com.tydic.dyc.oc.utils.UocRu;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

@HSFProvider(serviceVersion="3.0.0", serviceGroup="OC_GROUP_DEV", serviceInterface=UocAdjustPriceOrderCreateService.class)
public class UocAdjustPriceOrderCreateServiceImpl
implements UocAdjustPriceOrderCreateService {
    @Autowired
    private IUocChngOrderModel iUocChngOrderModel;
    @Autowired
    private IUocCommonModel iUocCommonModel;
    @Autowired
    IUocSaleOrderModel iUocSaleOrderModel;
    public static final String FIELD_CODE = "SKIP_ADJUST_PRICE_MEN";

    public UocAdjustPriceOrderCreateRspBo createAdjustPriceOrder(UocAdjustPriceOrderCreateReqBo reqBo) {
        UocAdjustPriceOrderCreateRspBo uocAdjustPriceOrderCreateRspBo = UocRu.success(UocAdjustPriceOrderCreateRspBo.class);
        if (reqBo.getAdjustFlag() == 1) {
            this.validateArg(reqBo);
            UocChngOrderDo uocChngOrderDo = this.convertChngOrderDo(reqBo, new Date());
            this.iUocChngOrderModel.createChngOrder(uocChngOrderDo);
            uocAdjustPriceOrderCreateRspBo.setChngOrderId(uocChngOrderDo.getChngOrderId());
        } else {
            UocSaleOrderDo add = new UocSaleOrderDo();
            add.setOrderId(reqBo.getOrderId());
            UocSaleOrderMap uocSaleOrderMap = new UocSaleOrderMap();
            uocSaleOrderMap.setOrderId(reqBo.getOrderId());
            uocSaleOrderMap.setSaleOrderId(reqBo.getSaleOrderId());
            uocSaleOrderMap.setId(IdUtil.nextId());
            uocSaleOrderMap.setRemark("\u8ba2\u5355\u8df3\u8fc7\u8c03\u4ef7");
            uocSaleOrderMap.setCreateOperId(String.valueOf(reqBo.getUserId()));
            uocSaleOrderMap.setFieldCode(FIELD_CODE);
            uocSaleOrderMap.setFieldName("\u8df3\u8fc7\u8c03\u4ef7\u4eba");
            uocSaleOrderMap.setFieldValue(reqBo.getUsername());
            uocSaleOrderMap.setCreateTime(new Date());
            add.setSaleOrderMapList(Collections.singletonList(uocSaleOrderMap));
            this.iUocSaleOrderModel.addSaleOrderMap(add);
            uocAdjustPriceOrderCreateRspBo.setChngOrderId(Long.valueOf(1L));
        }
        UocCommonDo uocCommonDo = new UocCommonDo();
        ArrayList<UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo> taskBos = new ArrayList<UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo>();
        UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo taskBo = new UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo();
        taskBo.setTaskId(reqBo.getTaskId());
        taskBo.setStepId(reqBo.getStepId());
        taskBos.add(taskBo);
        uocCommonDo.setCompleteTaskInfos(taskBos);
        uocCommonDo.setUserId(reqBo.getUserId());
        uocCommonDo.setOrderId(reqBo.getOrderId());
        this.iUocCommonModel.dealTask(uocCommonDo);
        return uocAdjustPriceOrderCreateRspBo;
    }

    private UocChngOrderDo convertChngOrderDo(UocAdjustPriceOrderCreateReqBo reqBo, Date newDate) {
        UocChngOrderDo uocChngOrderDo = new UocChngOrderDo();
        uocChngOrderDo.setOrderId(reqBo.getOrderId());
        uocChngOrderDo.setChngOrderId(IdUtil.nextId());
        uocChngOrderDo.setCreateOperId(reqBo.getUserId().toString());
        uocChngOrderDo.setCreateOperName(reqBo.getName());
        uocChngOrderDo.setCreateOperMobile(reqBo.getCellphone());
        uocChngOrderDo.setCreateTime(newDate);
        uocChngOrderDo.setRemark(reqBo.getRemark());
        uocChngOrderDo.setBusiType(UocConstant.BUSI_TYPE.PRICE_CHG);
        uocChngOrderDo.setTenantId(reqBo.getTenantId());
        ArrayList<UocChngOrderObj> uocChngOrderObjList = new ArrayList<UocChngOrderObj>();
        UocChngOrderObj uocChngOrderObj = new UocChngOrderObj();
        uocChngOrderObj.setOrderId(reqBo.getOrderId());
        uocChngOrderObj.setChngOrderObjId(IdUtil.nextId());
        uocChngOrderObj.setChngOrderId(uocChngOrderDo.getChngOrderId());
        uocChngOrderObj.setChngType(UocConstant.BUSI_TYPE.PRICE_CHG);
        uocChngOrderObj.setSaleOrderId(reqBo.getSaleOrderId());
        uocChngOrderObj.setCreateTime(newDate);
        uocChngOrderObj.setCreateOperId(reqBo.getUserId().toString());
        uocChngOrderObjList.add(uocChngOrderObj);
        ArrayList<UocChngOrderItemObj> uocChngOrderItemObjList = new ArrayList<UocChngOrderItemObj>();
        reqBo.getSaleItemList().forEach(itemBo -> {
            UocChngOrderItemObj uocChngOrderItemObj;
            if (itemBo.getAdjustPrice() != null) {
                uocChngOrderItemObj = new UocChngOrderItemObj();
                uocChngOrderItemObj.setOrderId(reqBo.getOrderId());
                uocChngOrderItemObj.setChngOrderId(uocChngOrderDo.getChngOrderId());
                uocChngOrderItemObj.setChngOrderObjId(uocChngOrderObj.getChngOrderObjId());
                uocChngOrderItemObj.setId(IdUtil.nextId());
                uocChngOrderItemObj.setOrderItemId(itemBo.getOrderItemId());
                uocChngOrderItemObj.setSaleOrderItemId(itemBo.getSaleOrderItemId());
                uocChngOrderItemObj.setChngType(UocStateConstants.ChngOrder.CHNG_TYPE.SALE_PRICE_CHNG);
                uocChngOrderItemObj.setChngFee(itemBo.getAdjustPrice());
                uocChngOrderItemObj.setCreateOperId(reqBo.getUserId().toString());
                uocChngOrderItemObj.setCreateTime(newDate);
                uocChngOrderItemObjList.add(uocChngOrderItemObj);
            }
            if (itemBo.getAdjustPurchasePrice() != null) {
                uocChngOrderItemObj = new UocChngOrderItemObj();
                uocChngOrderItemObj.setOrderId(reqBo.getOrderId());
                uocChngOrderItemObj.setChngOrderId(uocChngOrderDo.getChngOrderId());
                uocChngOrderItemObj.setChngOrderObjId(uocChngOrderObj.getChngOrderObjId());
                uocChngOrderItemObj.setId(IdUtil.nextId());
                uocChngOrderItemObj.setOrderItemId(itemBo.getOrderItemId());
                uocChngOrderItemObj.setSaleOrderItemId(itemBo.getSaleOrderItemId());
                uocChngOrderItemObj.setChngType(UocStateConstants.ChngOrder.CHNG_TYPE.PURCHASE_PRICE_CHNG);
                uocChngOrderItemObj.setChngFee(itemBo.getAdjustPurchasePrice());
                uocChngOrderItemObj.setCreateOperId(reqBo.getUserId().toString());
                uocChngOrderItemObj.setCreateTime(newDate);
                uocChngOrderItemObjList.add(uocChngOrderItemObj);
            }
        });
        uocChngOrderObj.setUocChngOrderItemObjList(uocChngOrderItemObjList);
        uocChngOrderDo.setUocChngOrderObjList(uocChngOrderObjList);
        if (!CollectionUtils.isEmpty((Collection)reqBo.getOrderAccessoryBoList())) {
            List<UocOrderAccessory> orderAccessoryBoList = UocRu.jsl(reqBo.getOrderAccessoryBoList(), UocOrderAccessory.class);
            orderAccessoryBoList.forEach(uocOrderAccessory -> {
                uocOrderAccessory.setOrderId(reqBo.getOrderId());
                uocOrderAccessory.setId(IdUtil.nextId());
                uocOrderAccessory.setCreateOperId(reqBo.getUserId().toString());
                uocOrderAccessory.setCreateTime(newDate);
                uocOrderAccessory.setObjId(uocChngOrderDo.getChngOrderId());
                uocOrderAccessory.setObjType(UocDicConstant.OBJ_TYPE.CHNG);
                uocOrderAccessory.setAttachmentType(UocDicConstant.OBJ_TYPE.CHNG);
            });
            uocChngOrderDo.setOrderAccessoryBoList(orderAccessoryBoList);
        }
        if (!CollectionUtils.isEmpty((Collection)reqBo.getExtParallelBoList())) {
            List<UocChngOrderMap> uocChngOrderMapList = UocRu.jsl(reqBo.getExtParallelBoList(), UocChngOrderMap.class);
            uocChngOrderMapList.forEach(uocChngOrderMap -> {
                uocChngOrderMap.setOrderId(reqBo.getOrderId());
                uocChngOrderMap.setChngOrderId(uocChngOrderDo.getChngOrderId());
                uocChngOrderMap.setId(IdUtil.nextId());
                uocChngOrderMap.setCreateOperId(reqBo.getUserId().toString());
                uocChngOrderMap.setCreateTime(newDate);
            });
            uocChngOrderDo.setUocChngOrderMapList(uocChngOrderMapList);
        }
        return uocChngOrderDo;
    }

    private void validateArg(UocAdjustPriceOrderCreateReqBo reqBo) {
        if (null == reqBo) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u4e3a\u7a7a");
        }
        if (null == reqBo.getOrderId()) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u8ba2\u5355ID\u4e3a\u7a7a");
        }
        if (null == reqBo.getSaleOrderId()) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u9500\u552e\u5355ID\u4e3a\u7a7a");
        }
        if (null == reqBo.getTaskId()) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u4efb\u52a1ID\u4e3a\u7a7a");
        }
        if (CollectionUtils.isEmpty((Collection)reqBo.getSaleItemList())) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u8c03\u4ef7\u4fe1\u606f\u4e3a\u7a7a");
        }
        reqBo.getSaleItemList().forEach(uocAdjustPriceOrderCreateReqItemBo -> {
            if (uocAdjustPriceOrderCreateReqItemBo.getOrderItemId() == null) {
                throw new BaseBusinessException("100001", "\u5165\u53c2\u8ba2\u5355\u660e\u7ec6ID\u4e3a\u7a7a");
            }
            if (uocAdjustPriceOrderCreateReqItemBo.getSaleOrderItemId() == null) {
                throw new BaseBusinessException("100001", "\u5165\u53c2\u9500\u552e\u660e\u7ec6ID\u4e3a\u7a7a");
            }
            if (uocAdjustPriceOrderCreateReqItemBo.getAdjustPrice() == null) {
                throw new BaseBusinessException("100001", "\u5165\u53c2\u8c03\u4ef7\u540e\u91d1\u989d\u4e3a\u7a7a");
            }
        });
    }
}

