/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.oc.service.order;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.model.order.IUocOrderModel;
import com.tydic.dyc.oc.model.order.UocOrderDo;
import com.tydic.dyc.oc.model.order.qrybo.UocOrderProcInstQryBo;
import com.tydic.dyc.oc.model.order.sub.UocOrderProcInst;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderQryBo;
import com.tydic.dyc.oc.service.order.UocCancelOrderService;
import com.tydic.dyc.oc.service.order.bo.UocCancelOrderBo;
import com.tydic.dyc.oc.service.order.bo.UocCancelOrderServiceReqBo;
import com.tydic.dyc.oc.service.order.bo.UocCancelOrderServiceReqCancelBo;
import com.tydic.dyc.oc.service.order.bo.UocCancelOrderServiceRspBo;
import com.tydic.dyc.oc.utils.UocRu;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

@HSFProvider(serviceVersion="3.0.0", serviceGroup="OC_GROUP_DEV", serviceInterface=UocCancelOrderService.class)
public class UocCancelOrderServiceImpl
implements UocCancelOrderService {
    @Autowired
    private IUocOrderModel iUocOrderModel;
    @Autowired
    private IUocSaleOrderModel iUocSaleOrderModel;

    public UocCancelOrderServiceRspBo cancelOrder(UocCancelOrderServiceReqBo reqBo) {
        this.val(reqBo);
        UocCancelOrderServiceRspBo uocCancelOrderServiceRspBo = UocRu.success(UocCancelOrderServiceRspBo.class);
        for (UocCancelOrderServiceReqCancelBo uocCancelOrderServiceReqCancelBo : reqBo.getCancelList()) {
            UocOrderDo uocOrderDo = new UocOrderDo();
            uocOrderDo.setOrderId(uocCancelOrderServiceReqCancelBo.getOrderId());
            uocOrderDo.setCancelReason(uocCancelOrderServiceReqCancelBo.getCancelReason());
            uocOrderDo.setOrderState("ZD_SP_QX");
            this.iUocOrderModel.updateOrderState(uocOrderDo);
        }
        UocSaleOrderQryBo uocSaleOrderQryBo = new UocSaleOrderQryBo();
        uocSaleOrderQryBo.setOrderIdList(reqBo.getCancelList().stream().map(UocCancelOrderServiceReqCancelBo::getOrderId).collect(Collectors.toList()));
        List<UocSaleOrderDo> saleOrderList = this.iUocSaleOrderModel.getSaleOrderList(uocSaleOrderQryBo);
        List<UocCancelOrderBo> uocCancelOrderBos = UocRu.jsl(saleOrderList, UocCancelOrderBo.class);
        uocCancelOrderServiceRspBo.setUocCancelOrderBoList(uocCancelOrderBos);
        UocOrderProcInstQryBo uocOrderProcInstQryBo = new UocOrderProcInstQryBo();
        uocOrderProcInstQryBo.setObjIdList(uocCancelOrderBos.stream().map(UocCancelOrderBo::getSaleOrderId).collect(Collectors.toList()));
        uocOrderProcInstQryBo.setObjType(UocDicConstant.OBJ_TYPE.SALE);
        List<UocOrderProcInst> uocOrderProcInsts = this.iUocOrderModel.qryOrderProcInstList(uocOrderProcInstQryBo);
        if (!CollectionUtils.isEmpty(uocOrderProcInsts)) {
            Map<Long, UocOrderProcInst> uocOrderProcInstMap = uocOrderProcInsts.stream().collect(Collectors.toMap(UocOrderProcInst::getObjId, o -> o));
            for (UocCancelOrderBo uocCancelOrderBo : uocCancelOrderBos) {
                UocOrderProcInst uocOrderProcInst = uocOrderProcInstMap.get(uocCancelOrderBo.getSaleOrderId());
                if (null == uocOrderProcInst) continue;
                uocCancelOrderBo.setProcInstId(uocOrderProcInst.getProcInstId());
            }
        }
        uocCancelOrderServiceRspBo.setOrderId(((UocCancelOrderServiceReqCancelBo)reqBo.getCancelList().get(0)).getOrderId());
        return uocCancelOrderServiceRspBo;
    }

    private void val(UocCancelOrderServiceReqBo reqBo) {
        if (null == reqBo) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (CollectionUtils.isEmpty((Collection)reqBo.getCancelList())) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u8ba2\u5355\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        for (UocCancelOrderServiceReqCancelBo uocCancelOrderServiceReqCancelBo : reqBo.getCancelList()) {
            if (null == uocCancelOrderServiceReqCancelBo) {
                throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (null != uocCancelOrderServiceReqCancelBo.getOrderId()) continue;
            throw new BaseBusinessException("100001", "\u5165\u53c2\u8ba2\u5355id\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

