/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.oc.service.order;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.model.audit.IUocAuditOrderModel;
import com.tydic.dyc.oc.model.audit.UocAuditOrderDo;
import com.tydic.dyc.oc.model.audit.qrybo.UocApprovalObjQryBo;
import com.tydic.dyc.oc.model.audit.qrybo.UocAuditOrderQryBo;
import com.tydic.dyc.oc.model.audit.sub.UocApprovalObj;
import com.tydic.dyc.oc.model.order.IUocOrderModel;
import com.tydic.dyc.oc.model.order.UocOrderDo;
import com.tydic.dyc.oc.model.order.qrybo.UocOrdLogisticsRelaQryBo;
import com.tydic.dyc.oc.model.order.qrybo.UocOrderAccessoryQryBo;
import com.tydic.dyc.oc.model.order.qrybo.UocOrderItemQryBo;
import com.tydic.dyc.oc.model.order.qrybo.UocOrderStakeholderQryBo;
import com.tydic.dyc.oc.model.order.sub.UocOrdLogisticsRela;
import com.tydic.dyc.oc.model.order.sub.UocOrderAccessory;
import com.tydic.dyc.oc.model.order.sub.UocOrderItem;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderItemQryBo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderQryBo;
import com.tydic.dyc.oc.model.sysdictionary.IUocSysDictionaryModel;
import com.tydic.dyc.oc.service.order.UocGetOrderAllDetailService;
import com.tydic.dyc.oc.service.order.bo.UocGetOrderAllDetailServiceReqBo;
import com.tydic.dyc.oc.service.order.bo.UocGetOrderAllDetailServiceRspAccessoryBo;
import com.tydic.dyc.oc.service.order.bo.UocGetOrderAllDetailServiceRspBo;
import com.tydic.dyc.oc.service.order.bo.UocGetOrderAllDetailServiceRspOrderCommInfoBo;
import com.tydic.dyc.oc.service.order.bo.UocGetOrderAllDetailServiceRspOrderLogisticsBo;
import com.tydic.dyc.oc.service.order.bo.UocGetOrderAllDetailServiceRspSaleStakeBo;
import com.tydic.dyc.oc.utils.UocRu;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;

@HSFProvider(serviceVersion="3.0.0", serviceGroup="OC_GROUP_DEV", serviceInterface=UocGetOrderAllDetailService.class)
public class UocGetOrderAllDetailServiceImpl
implements UocGetOrderAllDetailService {
    private static final Logger log = LoggerFactory.getLogger(UocGetOrderAllDetailServiceImpl.class);
    @Autowired
    private IUocOrderModel iUocOrderModel;
    @Autowired
    private IUocSaleOrderModel iUocSaleOrderModel;
    @Autowired
    private IUocSysDictionaryModel iUocSysDictionaryModel;
    @Autowired
    private IUocAuditOrderModel iUocAuditOrderModel;
    private static final String DEFAULT_PAY_TYPE = "2";
    private static final String DEFAULT_PAY_TYPE_STR = "\u5e10\u671f\u652f\u4ed8";

    public UocGetOrderAllDetailServiceRspBo getOrderAllDetail(UocGetOrderAllDetailServiceReqBo reqBo) {
        this.val(reqBo);
        UocOrderDo uocOrderDo = new UocOrderDo();
        uocOrderDo.setOrderId(reqBo.getOrderId());
        UocOrderDo orderDo = this.iUocOrderModel.qryOrderBy(uocOrderDo);
        if (orderDo == null) {
            throw new BaseBusinessException("101014", "\u672a\u67e5\u8be2\u5230 [ orderId = " + reqBo.getOrderId() + " ]\uff0c\u5bf9\u5e94\u7684\u8ba2\u5355\u4fe1\u606f\uff01");
        }
        UocGetOrderAllDetailServiceRspBo rspBo = UocRu.js((Object)orderDo, UocGetOrderAllDetailServiceRspBo.class);
        rspBo.setPayType(DEFAULT_PAY_TYPE);
        rspBo.setPayTypeStr(DEFAULT_PAY_TYPE_STR);
        UocOrdLogisticsRelaQryBo uocOrdLogisticsRelaQryBo = new UocOrdLogisticsRelaQryBo();
        uocOrdLogisticsRelaQryBo.setOrderId(reqBo.getOrderId());
        uocOrdLogisticsRelaQryBo.setContactId(orderDo.getContactId());
        log.info("\u67e5\u8be2\u6536\u8d27\u5730\u5740\u4fe1\u606f\u5165\u53c2,{}", (Object)uocOrdLogisticsRelaQryBo.toString());
        UocOrdLogisticsRela uocOrdLogisticsRela = this.iUocOrderModel.qryOrderLogisticsRela(uocOrdLogisticsRelaQryBo);
        rspBo.setLogisticsBo(UocRu.js(uocOrdLogisticsRela, UocGetOrderAllDetailServiceRspOrderLogisticsBo.class));
        UocOrderStakeholderQryBo uocOrderStakeholderQryBo = new UocOrderStakeholderQryBo();
        uocOrderStakeholderQryBo.setOrderId(reqBo.getOrderId());
        List<UocOrderStakeholderQryBo> uocOrderStakeholderQryBos = this.iUocOrderModel.qryStakeholderList(uocOrderStakeholderQryBo);
        rspBo.setSaleStakeBos(UocRu.jsl(uocOrderStakeholderQryBos, UocGetOrderAllDetailServiceRspSaleStakeBo.class));
        UocOrderAccessoryQryBo accessoryQryBo = new UocOrderAccessoryQryBo();
        accessoryQryBo.setObjId(reqBo.getOrderId());
        accessoryQryBo.setOrderId(reqBo.getOrderId());
        accessoryQryBo.setObjType(UocDicConstant.OBJ_TYPE.ORDER);
        List<UocOrderAccessory> orderAccessoryList = this.iUocOrderModel.getOrderAccessoryList(accessoryQryBo);
        rspBo.setAccessoryBos(UocRu.jsl(orderAccessoryList, UocGetOrderAllDetailServiceRspAccessoryBo.class));
        UocOrderItemQryBo uocOrderItemQryBo = new UocOrderItemQryBo();
        uocOrderItemQryBo.setOrderId(reqBo.getOrderId());
        List<UocOrderItem> uocOrderItems = this.iUocOrderModel.qryOrderItemList(uocOrderItemQryBo);
        List<UocGetOrderAllDetailServiceRspOrderCommInfoBo> commInfoBos = UocRu.jsl(uocOrderItems, UocGetOrderAllDetailServiceRspOrderCommInfoBo.class);
        for (UocGetOrderAllDetailServiceRspOrderCommInfoBo commInfoBo : commInfoBos) {
            BigDecimal saleFee = new BigDecimal(commInfoBo.getSalePrice()).multiply(commInfoBo.getPurchaseCount());
            BigDecimal purchaseFee = commInfoBo.getPurchasePrice().multiply(commInfoBo.getPurchaseCount());
            commInfoBo.setSaleFee(saleFee);
            commInfoBo.setPurchaseFee(purchaseFee);
            UocSaleOrderItemQryBo uocSaleOrderItemQryBo = new UocSaleOrderItemQryBo();
            uocSaleOrderItemQryBo.setOrderId(commInfoBo.getOrderId());
            uocSaleOrderItemQryBo.setOrderItemId(commInfoBo.getOrderItemId());
            UocSaleOrderDo uocSaleOrderDo = this.iUocSaleOrderModel.qryListSaleOrderItem(uocSaleOrderItemQryBo);
            uocSaleOrderItemQryBo.setSaleOrderId(uocSaleOrderDo.getSaleOrderItems().get(0).getSaleOrderId());
            String cmpOrderNo = uocSaleOrderDo.getSaleOrderItems().get(0).getCmpOrderNo();
            commInfoBo.setCmpOrderNo(cmpOrderNo);
            commInfoBo.setNoCmpReason(uocSaleOrderDo.getSaleOrderItems().get(0).getNoCmpReason());
        }
        rspBo.setCommInfoBos(commInfoBos);
        UocSaleOrderDo uocSaleOrderDo = new UocSaleOrderDo();
        UocSaleOrderQryBo uocSaleOrderQryBo = new UocSaleOrderQryBo();
        uocSaleOrderQryBo.setOrderId(reqBo.getOrderId());
        List<UocSaleOrderDo> saleOrderList = this.iUocSaleOrderModel.getSaleOrderList(uocSaleOrderQryBo);
        if (CollectionUtil.isNotEmpty(saleOrderList)) {
            UocSaleOrderDo saleOrderMain = saleOrderList.get(0);
            rspBo.setPayState(saleOrderMain.getPayState().toString());
            rspBo.setPurchaseMode(saleOrderMain.getPurchaseMode());
            rspBo.setCancelOperName(saleOrderMain.getCancelOperName());
            rspBo.setCancelTime(saleOrderMain.getCancelTime());
            rspBo.setCancelReason(saleOrderMain.getCancelReason());
        }
        UocApprovalObjQryBo uocApprovalObjQryBo = new UocApprovalObjQryBo();
        uocApprovalObjQryBo.setOrderId(reqBo.getOrderId());
        uocApprovalObjQryBo.setObjType(UocDicConstant.OBJ_TYPE.ORDER);
        List<UocApprovalObj> approvalObjList = this.iUocAuditOrderModel.qryApprovealObj(uocApprovalObjQryBo);
        if (ObjectUtil.isNotEmpty(approvalObjList)) {
            UocAuditOrderQryBo auditOrderQryBo = new UocAuditOrderQryBo();
            auditOrderQryBo.setAuditOrderId(approvalObjList.get(0).getAuditOrderId());
            UocAuditOrderDo uocAuditOrderDo = this.iUocAuditOrderModel.qryAuditOrder(auditOrderQryBo);
            rspBo.setAuditOrderStatus(uocAuditOrderDo.getAuditOrderStatus());
        }
        this.transelate(rspBo);
        return rspBo;
    }

    private void transelate(UocGetOrderAllDetailServiceRspBo rspBo) {
        Map<String, Map<String, String>> dic = this.getDic();
        if (rspBo.getPayState() != null) {
            String payStateStr = dic.get("UOC_SALE_ORDER_PAY_STATE").get(rspBo.getPayState());
            rspBo.setPayStateStr(payStateStr);
        }
        if (rspBo.getOrderState() != null) {
            String orderStateStr = dic.get("UOC_COMMON_ORDER_STATE").get(rspBo.getOrderState());
            rspBo.setOrderStateStr(orderStateStr);
        }
        if (rspBo.getPurchaseMode() != null) {
            String purchaseModeStr = dic.get("UOC_COMMON_PURCHASE_MODE").get(rspBo.getPurchaseMode().toString());
            rspBo.setPurchaseModeStr(purchaseModeStr);
        }
        if (rspBo.getPayType() != null) {
            String payTypeStr = dic.get("UOC_SALE_ORDER_PAY_TYPE").get(rspBo.getPayType());
            rspBo.setPayTypeStr(payTypeStr);
        }
        if (rspBo.getAuditOrderStatus() != null) {
            String auditOrderStatusStr = dic.get("UOC_COMMON_ORDER_STATE").get(rspBo.getAuditOrderStatus());
            rspBo.setAuditOrderStatusStr(auditOrderStatusStr);
        }
    }

    private void val(UocGetOrderAllDetailServiceReqBo reqBo) {
        if (reqBo == null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e0d\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((Object)reqBo.getOrderId())) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u3010orderId\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private Map<String, Map<String, String>> getDic() {
        ArrayList<String> pCodes = new ArrayList<String>();
        pCodes.add("UOC_SALE_ORDER_PAY_STATE");
        pCodes.add("UOC_COMMON_PURCHASE_MODE");
        pCodes.add("UOC_COMMON_ORDER_STATE");
        pCodes.add("UOC_SALE_ORDER_PAY_TYPE");
        return this.iUocSysDictionaryModel.getDictionaryMap(pCodes);
    }
}

