package com.tydic.dyc.oc.components.event.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.tydic.dyc.oc.components.es.IUocEsSyncQryReqBo;
import com.tydic.dyc.oc.components.event.EventConsumer;
import com.tydic.dyc.oc.components.event.IUocEsSyncQryEventReqBo;
import com.tydic.dyc.oc.config.UocIndexConfig;
import com.tydic.dyc.oc.constants.UocEventConstant;
import com.tydic.dyc.oc.utils.UocRu;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;

/**
 * 标题：类名称:EventConsumerSyncAfterOrder
 * 说明：描述一下类的作用TODO
 * 时间：2022/4/18 16:20
 * 作者 @author 尹栋梁
 */
@Slf4j
@Component
public class EventConsumerSyncAfterOrder implements EventConsumer {
    @Autowired
    private UocIndexConfig uocIndexConfig;

    @Override
    public List<IUocEsSyncQryEventReqBo> parseMap(Map<String, Object> map) {
        log.info("event-EventConsumerSyncAfterOrder->{}", JSON.toJSONString(map));

        List<IUocEsSyncQryEventReqBo> retList = new ArrayList<>();
        Long afOrderId = UocRu.parseLong(map.get("afOrderId"));
        Long orderId = UocRu.parseLong(map.get("orderId"));
        Long saleOrderId = UocRu.parseLong(map.get("saleOrderId"));
        Long shipOrderId = UocRu.parseLong(map.get("shipOrderId"));
        String extObj = UocRu.parseStr(map.get("saleOrderExtObj"));

        List<IUocEsSyncQryReqBo> afOrderList = new ArrayList<>();
        IUocEsSyncQryReqBo afOrder = new IUocEsSyncQryReqBo();
        afOrder.setOrderId(orderId);
        afOrder.setObjId(afOrderId);
        afOrderList.add(afOrder);
        IUocEsSyncQryEventReqBo saleEventReqBo = new IUocEsSyncQryEventReqBo();
        saleEventReqBo.setIndexName(uocIndexConfig.getAfOrderIndex());
        saleEventReqBo.setDataList(afOrderList);
        retList.add(saleEventReqBo);

        if (ObjectUtil.isNotEmpty(shipOrderId)) {
            List<IUocEsSyncQryReqBo> shipList = new ArrayList<>();
            IUocEsSyncQryReqBo ship = new IUocEsSyncQryReqBo();
            ship.setOrderId(orderId);
            ship.setObjId(shipOrderId);
            shipList.add(ship);
            IUocEsSyncQryEventReqBo shipEventReqBo = new IUocEsSyncQryEventReqBo();
            shipEventReqBo.setIndexName(uocIndexConfig.getShipOrderIndex());
            shipEventReqBo.setDataList(shipList);
            retList.add(shipEventReqBo);
        }

        if (ObjectUtil.isNotEmpty(saleOrderId)) {
            List<IUocEsSyncQryReqBo> saleList = new ArrayList<>();
            IUocEsSyncQryReqBo sale = new IUocEsSyncQryReqBo();
            sale.setOrderId(orderId);
            sale.setObjId(saleOrderId);
            Optional.ofNullable(extObj).ifPresent(x->sale.setJsonObj(JSONObject.parseObject(x)));
            saleList.add(sale);
            IUocEsSyncQryEventReqBo eventReqBo = new IUocEsSyncQryEventReqBo();
            eventReqBo.setIndexName(uocIndexConfig.getSaleOrderIndex());
            eventReqBo.setDataList(saleList);
            retList.add(eventReqBo);
        }


        return retList;
    }

    @Override
    public String getEvent() {
        return UocEventConstant.UOCE_ORDER_AFTER_SYNC;
    }
}
