package com.tydic.dyc.oc.model.saleorder.impl;

import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.constants.UocObjNoConstants;
import com.tydic.dyc.oc.constants.UocRspConstants;
import com.tydic.dyc.oc.constants.UocStateConstants;
import com.tydic.dyc.oc.model.order.qrybo.UocOrderAccessoryQryBo;
import com.tydic.dyc.oc.model.order.sub.*;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo;
import com.tydic.dyc.oc.model.saleorder.qrybo.*;
import com.tydic.dyc.oc.model.saleorder.sub.*;
import com.tydic.dyc.oc.repository.UocAgreementOrderRepository;
import com.tydic.dyc.oc.repository.UocCommonRepository;
import com.tydic.dyc.oc.repository.UocOrderRepository;
import com.tydic.dyc.oc.repository.UocSaleOrderRepository;
import com.tydic.dyc.oc.service.common.bo.UocProBusinessException;
import com.tydic.dyc.oc.service.common.bo.UocProRspConstants;
import com.tydic.dyc.oc.utils.IdUtil;
import com.tydic.dyc.oc.utils.UocMoneyUtil;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;


/**
 * 标题:IUocSaleOrderModelImpl
 * 说明:
 * 时间:2022/2/24 18:27
 * 作者:田桂银
 */
@Service
@Slf4j
public class UocSaleOrderModelImpl implements IUocSaleOrderModel {

    @Autowired
    private UocSaleOrderRepository uocSaleOrderRepository;

    @Autowired
    private UocCommonRepository uocCommonRepository;

    @Autowired
    private UocAgreementOrderRepository uocAgreementOrderRepository;
    
    @Autowired
    private UocOrderRepository uocOrderRepository;
    
    @Value("${isLimitPrice:true}")
    private boolean limitPrice;

    @Override
    public UocSaleOrderDo createSaleOrder(UocSaleOrderDo saleOrderDo) {
        validateCreateArg(saleOrderDo);
        saleOrderDo.setSaleOrderNo(genRequestCode(saleOrderDo));
        //设置销售单
        saleOrderDo.setSaleOrderId(IdUtil.nextId());
        saleOrderDo.setCreateTime(new Date());
        //默认设置为刚创建状态
        saleOrderDo.setSaleOrderState(null);

        //设置销售单扩展
        List<UocSaleOrderMap> saleOrderMapList = saleOrderDo.getSaleOrderMapList();
        if (ObjectUtil.isNotEmpty(saleOrderMapList)) {
            for (UocSaleOrderMap uocSaleOrderMap : saleOrderMapList) {
                uocSaleOrderMap.setId(IdUtil.nextId());
                uocSaleOrderMap.setSaleOrderId(saleOrderDo.getSaleOrderId());
                uocSaleOrderMap.setCreateOperId(saleOrderDo.getCreateOperId());
                uocSaleOrderMap.setCreateTime(saleOrderDo.getCreateTime());
            }
        }

        //设置支付配置
        List<UocSaleOrderPayConf> saleOrderPayConfList = saleOrderDo.getSaleOrderPayConfList();
        if (ObjectUtil.isNotEmpty(saleOrderPayConfList)) {
            for (UocSaleOrderPayConf payConf : saleOrderPayConfList) {
                payConf.setId(IdUtil.nextId());
                payConf.setOrderId(saleOrderDo.getOrderId());
                payConf.setCreateTime(saleOrderDo.getCreateTime());
                payConf.setCreateOperId(saleOrderDo.getCreateOperId());
                payConf.setSaleOrderId(saleOrderDo.getSaleOrderId());
                if(UocDicConstant.PAY_CONF_USE_TYPE.PUR.equals(payConf.getUserType())){
                    saleOrderDo.setPayType(payConf.getPayType() != null ? payConf.getPayType().toString() : null);
                }
            }
        }

        //设置附件
        List<UocOrderAccessory> saleOrderAccessoryList = saleOrderDo.getSaleOrderAccessoryList();
        if (ObjectUtil.isNotEmpty(saleOrderAccessoryList)) {
            for (UocOrderAccessory accessory : saleOrderAccessoryList) {
                accessory.setId(IdUtil.nextId());
                accessory.setObjId(saleOrderDo.getSaleOrderId());
                accessory.setObjType(UocDicConstant.OBJ_TYPE.SALE);
                accessory.setOrderId(saleOrderDo.getOrderId());
                accessory.setCreateTime(saleOrderDo.getCreateTime());
                accessory.setCreateOperId(saleOrderDo.getCreateOperId());
            }
        }

        //设置销售明细
        setSaleItems(saleOrderDo);
        
        //限额
        if(limitPrice){
            BigDecimal totalSale = saleOrderDo.getTotalSaleFee();
            totalSale = totalSale.multiply(new BigDecimal(10000));
            String supNo = saleOrderDo.getStakeholder().getSupId();
            String supName =  saleOrderDo.getStakeholder().getSupName();
            log.info("供应商 {}，下单金额为 {}",supNo,totalSale);
            UocConfSupplier uocConfSupplier = new UocConfSupplier();
            uocConfSupplier.setSupNo(Long.valueOf(supNo));
    
            uocConfSupplier = uocOrderRepository.getConfSupplierModelBy(uocConfSupplier);
    
            if(ObjectUtil.isNotEmpty(uocConfSupplier)){
                Long limit = uocConfSupplier.getOrderLimit();
                
                log.info("订单限额：{}",limit);
                //如果该供应商配置了订单最高限额，且大于0，则需要判断当前下单金额是否满足
        
                if (limit != null && limit > 0) {
                    if (limit > totalSale.longValue()) {
                        String money = null;
                        try {
                            money = UocMoneyUtil.long2BigDecimal(limit).toString();
                        } catch (Exception e) {
                            e.printStackTrace();
                        }
                        throw new BaseBusinessException(UocProRspConstants.RSP_CODE_THIRD_SUP_CRE_ORD_BUSI_ERROR, supName + "下的订单不满足" + money + "元，不允许下单。");
                    }
                }
        
            }
        }
        
        

        return uocSaleOrderRepository.createSaleOrder(saleOrderDo);
    }

    private void validateCreateArg(UocSaleOrderDo saleOrderDo) {
        if(ObjectUtil.isEmpty(saleOrderDo)){
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR,"入参对象不能为空");
        }
    }

    private void setSaleItems(UocSaleOrderDo saleOrderDo) {
        List<UocSaleOrderItem> saleOrderItems = saleOrderDo.getSaleOrderItems();
        for (UocSaleOrderItem saleOrderItem : saleOrderItems) {
            saleOrderItem.setOrderId(saleOrderDo.getOrderId());
            saleOrderItem.setSaleOrderItemId(IdUtil.nextId());
            saleOrderItem.setSaleOrderId(saleOrderDo.getSaleOrderId());
            saleOrderItem.setCreateOperId(saleOrderDo.getCreateOperId());
            saleOrderItem.setCreateTime(saleOrderDo.getCreateTime());
            saleOrderItem.setPurchaseFee(saleOrderItem.getPurchasePrice().multiply(saleOrderItem.getPurchaseCount()));

            List<UocSaleItemMap> saleItemMapList = saleOrderItem.getSaleItemMapList();
            if (ObjectUtil.isNotEmpty(saleItemMapList)) {
                for (UocSaleItemMap uocSaleItemMap : saleItemMapList) {
                    uocSaleItemMap.setId(IdUtil.nextId());
                    uocSaleItemMap.setSaleOrderItemId(saleOrderItem.getOrderItemId());
                    uocSaleItemMap.setSaleOrderId(saleOrderDo.getSaleOrderId());
                    uocSaleItemMap.setOrderId(saleOrderDo.getOrderId());
                    uocSaleItemMap.setCreateTime(saleOrderDo.getCreateTime());
                    uocSaleItemMap.setCreateOperId(saleOrderDo.getCreateOperId());
                }
            }

        }
    }


    @Override
    public List<UocSaleOrderItem> getSaleOrderItemList(UocSaleOrderItemQryBo uocSaleOrderItemQryBo) {
        if (null == uocSaleOrderItemQryBo) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "方法入参对象不能为空");
        }
        return uocSaleOrderRepository.getSaleOrderItemList(uocSaleOrderItemQryBo);
    }

    @Override
    public List<UocSaleOrderItem> getSaleOrderItemListByItemIds(List<Long> itemIds) {
        if(CollectionUtils.isEmpty(itemIds)){
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "销售单明细id集合不能为空");
        }
        return uocSaleOrderRepository.getSaleOrderItemListByItemIds(itemIds);
    }

    @Override
    public List<UocSaleItemMap> getSaleOrderItemMapList(UocSaleItemMapQryBo uocSaleItemMapQryBo) {
        if (null == uocSaleItemMapQryBo) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "方法入参对象不能为空");
        }
        return uocSaleOrderRepository.getSaleOrderItemMapList(uocSaleItemMapQryBo);
    }


    @Override
    public UocSaleOrderDo qrySaleOrder(UocSaleOrderQryBo uocSaleOrderQryBo) {
        if (null == uocSaleOrderQryBo) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "方法入参对象不能为空");
        }
        return uocSaleOrderRepository.qrySaleOrder(uocSaleOrderQryBo);
    }

    @Override
    public UocSaleOrderDo getSaleOrderAccessoryList(UocOrderAccessoryQryBo uocOrderAccessoryQryBo) {
        if (null == uocOrderAccessoryQryBo) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "方法入参对象不能为空");
        }
        return uocSaleOrderRepository.getSaleOrderAccessoryList(uocOrderAccessoryQryBo);
    }

    @Override
    public List<UocSaleOrderPayConf> getSaleOrderPayConfList(UocSaleOrderPayConfQryBo uocSaleOrderPayConfQryBo) {
        return uocSaleOrderRepository.getSaleOrderPayConfList(uocSaleOrderPayConfQryBo);
    }

    @Override
    public List<UocSaleOrderMap> getSaleOrderExpandList(UocSaleOrderMapQryBo uocSaleOrderMapQryBo) {
        if (null == uocSaleOrderMapQryBo) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "方法入参对象不能为空");
        }
        return uocSaleOrderRepository.getSaleOrderExpandList(uocSaleOrderMapQryBo);
    }

    @Override
    public UocSaleOrderDo qryListSaleOrderItem(UocSaleOrderItemQryBo uocSaleOrderItemQryBo) {
        return uocSaleOrderRepository.qryListSaleOrderItem(uocSaleOrderItemQryBo);
    }

    @Override
    public void modifySaleOrderMain(UocSaleOrderDo uocSaleOrderDo) {
        if (null == uocSaleOrderDo) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象不能为空");
        }
        if (null == uocSaleOrderDo.getOrderId()) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参订单ID不能为空");
        }
        if (null == uocSaleOrderDo.getSaleOrderId()) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参销售单ID不能为空");
        }

        uocSaleOrderRepository.modifySaleOrderMain(uocSaleOrderDo);
    }

    @Override
    public UocSaleOrderDo updateSaleStatusAndProCode(UocSaleOrderDo reqBo) {
        validateUpdateSaleOrderArg(reqBo);
        //查询销售单修改前状态
        UocSaleOrderQryBo qryBo = new UocSaleOrderQryBo();
        qryBo.setOrderId(reqBo.getOrderId());
        qryBo.setSaleOrderId(reqBo.getSaleOrderId());
        UocSaleOrderDo uocSaleOrderDo = qrySaleOrder(qryBo);
        if (ObjectUtil.isEmpty(uocSaleOrderDo)) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_SALE_UPDATE_STATE_ERROR, "该销售单" + reqBo.getSaleOrderId() + "不存在");
        }

        //记录变更日志
        UocOrderStateChgLog uocOrderStateChgLog = new UocOrderStateChgLog();
        uocOrderStateChgLog.setId(IdUtil.nextId());
        uocOrderStateChgLog.setObjId(reqBo.getSaleOrderId());
        uocOrderStateChgLog.setOrderId(reqBo.getOrderId());
        uocOrderStateChgLog.setObjType(UocDicConstant.OBJ_TYPE.SALE);
        uocOrderStateChgLog.setOldState(uocSaleOrderDo.getSaleOrderState());
        uocOrderStateChgLog.setNewState(reqBo.getSaleOrderState());
        uocOrderStateChgLog.setChgTime(new Date());
        uocOrderStateChgLog.setOperId(reqBo.getUpdateOperId());

        //调用通用repository，创建状态变更日志
        uocCommonRepository.createOrderStateChangeLog(uocOrderStateChgLog);

        //更新销售单数据
        return uocSaleOrderRepository.updateSaleStatusAndProCode(reqBo);
    }

    private void validateUpdateSaleOrderArg(UocSaleOrderDo reqBo) {
        if (reqBo == null) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象[UocUpdateSaleOrderStateServiceReqBo]不能为空");
        }
        if (ObjectUtil.isEmpty(reqBo.getUpdateOperId())) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性【更新人id】不能为空");
        }
        if (ObjectUtil.isEmpty(reqBo.getOrderId())) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性【订单id】不能为空");
        }
        if (ObjectUtil.isEmpty(reqBo.getSaleOrderId())) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性【销售单id】不能为空");
        }
        if (ObjectUtil.isEmpty(reqBo.getSaleOrderState())) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性【销售单状态】不能为空");
        }
    }

    @Override
    public void updateProcTaskInstToFinished(List<UocOrderTaskInst> uocOrderTaskInstList) {
        uocCommonRepository.updateToFinished(uocOrderTaskInstList);
    }

    @Override
    public void saveProcTaskInst(List<UocOrderTaskInst> saveTaskList) {
        Date createTime = new Date();
        if (ObjectUtil.isNotEmpty(saveTaskList)) {
            for (UocOrderTaskInst uocOrderTaskInst : saveTaskList) {
                uocOrderTaskInst.setCreateTime(createTime);
            }
            uocCommonRepository.saveProcTaskInst(saveTaskList);
        }
    }

    @Override
    public List<UocSaleOrderDo> qrySaleOrderList(UocSaleOrderDo qryDo) {
        if (null == qryDo) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "方法入参对象不能为空");
        }
        return uocSaleOrderRepository.qrySaleOrderList(qryDo);
    }

    @Override
    public UocOrderProcInst createProInst(UocOrderProcInst inst) {
        inst.setId(IdUtil.nextId());
        inst.setCreateTime(new Date());
        return uocCommonRepository.createProInst(inst);
    }

    @Override
    public List<UocOrderProcInst> qryProcInsList(UocOrderProcInst inst) {
        return uocCommonRepository.qryProcInsList(inst);
    }

    @Override
    public List<UocOrderTaskInst> qryTaskInstList(UocOrderTaskInst taskInst) {
        return uocCommonRepository.qryTaskInstList(taskInst);
    }

    @Override
    public void saveOrderTaskDealList(List<UocOrderTaskDeal> dealList) {
        uocCommonRepository.saveOrderTaskDealList(dealList);
    }

    @Override
    public UocSaleOrderDo getSaleOrderMain(UocSaleOrderDo uocSaleOrderDo) {
        if(null == uocSaleOrderDo){
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "入参对象为空");
        }
        return uocSaleOrderRepository.getSaleOrderMain(uocSaleOrderDo);
    }

    @Override
    public List<UocSaleStakeholder> qrySaleOrderStakeholder(UocSaleStakeholderQryBo qryBo) {
        return uocSaleOrderRepository.qrySaleOrderStakeholder(qryBo);
    }


    private String genRequestCode(UocSaleOrderDo saleOrderDo) {
        return uocCommonRepository.getOrderNoSingle(UocObjNoConstants.SALE_ORDER_NO + "_" + saleOrderDo.getOrderSource());
    }

    @Override
    public void addSaleOrderMap(UocSaleOrderDo uocSaleOrderDo) {
        valDo(uocSaleOrderDo);
        uocSaleOrderRepository.addSaleOrderMap(uocSaleOrderDo);
    }

    @Override
    public void updateBatchValue(UocSaleOrderDo uocSaleOrderDo) {
        valDo(uocSaleOrderDo);
        uocSaleOrderRepository.updateBatchValue(uocSaleOrderDo);
    }

    @Override
    public void updateInvalid(UocSaleOrderDo uocSaleOrderDo) {
        valDo(uocSaleOrderDo);
        uocSaleOrderRepository.updateInvalid(uocSaleOrderDo);
    }

    @Override
    public UocOrderAgreement getAgreementOrderBy(UocOrderAgreementQryBo uocOrderAgreementQryBo) {
        if (ObjectUtil.isNull(uocOrderAgreementQryBo)) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "入参对象不能为空");
        }
        return uocAgreementOrderRepository.getAgreementOrderBy(uocOrderAgreementQryBo);
    }

    @Override
    public List<UocOrderAgreement> getAgreementOrderList(UocOrderAgreementQryBo uocOrderAgreementQryBo) {
        if (ObjectUtil.isNull(uocOrderAgreementQryBo)) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "入参对象不能为空");
        }
        return uocAgreementOrderRepository.getAgreementOrderList(uocOrderAgreementQryBo);
    }

    @Override
    public UocSaleOrderDo qryTotalFeeAndCount(UocSaleOrderQryBo uocSaleOrderQryBo) {
        if ( ObjectUtil.isNull(uocSaleOrderQryBo) ) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "入参对象不能为空");
        }
        return uocSaleOrderRepository.qryTotalFeeAndCount(uocSaleOrderQryBo);
    }

    @Override
    public UocSaleOrderDo getListSaleOrderItem(UocSaleOrderItemQryBo uocSaleOrderItemQryBo) {
        if ( ObjectUtil.isNull(uocSaleOrderItemQryBo) ) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "入参对象不能为空");
        }
        return uocSaleOrderRepository.getListSaleOrderItem(uocSaleOrderItemQryBo);
    }

    @Override
    public void modifyBatchItemSendCount(UocSaleOrderDo convertSaleOrderDo) {
        valDo(convertSaleOrderDo);
        if (null == convertSaleOrderDo.getSaleOrderId()) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "方法入参销售单ID不能为空");
        }
        if (CollectionUtils.isEmpty(convertSaleOrderDo.getSaleOrderItems())) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "方法入参销售单明细列表不能为空");
        }
        convertSaleOrderDo.getSaleOrderItems().forEach(uocImplOrderItem -> {
            if (null == uocImplOrderItem.getSaleOrderItemId()) {
                throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "方法入参销售单明细ID不能为空");
            }
            if (null == uocImplOrderItem.getSendCount()) {
                throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "方法入参发货数量不能为空");
            }
        });
        uocSaleOrderRepository.modifyBatchItemSendCount(convertSaleOrderDo);
    }

    @Override
    public void modifyBatchItemArrivalTime(UocSaleOrderDo convertSaleOrderDo) {
        valDo(convertSaleOrderDo);
        if (null == convertSaleOrderDo.getSaleOrderId()) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "方法入参销售单ID不能为空");
        }
        if (CollectionUtils.isEmpty(convertSaleOrderDo.getSaleOrderItems())) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "方法入参销售单明细列表不能为空");
        }
        convertSaleOrderDo.getSaleOrderItems().forEach(uocImplOrderItem -> {
            if (null == uocImplOrderItem.getSaleOrderItemId()) {
                throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "方法入参销售单明细ID不能为空");
            }
            if (null == uocImplOrderItem.getArrivalTime()) {
                throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "方法入参到货周期不能为空");
            }
        });
        uocSaleOrderRepository.modifyBatchItemArrivalTime(convertSaleOrderDo);
    }

    @Override
    public UocSaleOrderDo getCollectCountImplOrderItem(UocSaleOrderItemQryBo uocSaleOrderItemQryBo) {
        if (null == uocSaleOrderItemQryBo) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象不能为空");
        }
        if (null == uocSaleOrderItemQryBo.getOrderId()) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参订单ID不能为空");
        }
        if (null == uocSaleOrderItemQryBo.getSaleOrderId()) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参销售单ID不能为空");
        }
        return uocSaleOrderRepository.getCollectCount(uocSaleOrderItemQryBo);
    }

    @Override
    public void modifyBatchItemInspCount(UocSaleOrderDo uocSaleOrderDo) {
        valDo(uocSaleOrderDo);
        if (null == uocSaleOrderDo.getSaleOrderId()) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "方法入参销售单ID不能为空");
        }
        if (CollectionUtils.isEmpty(uocSaleOrderDo.getSaleOrderItems())) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "方法入参销售单明细列表不能为空");
        }
        uocSaleOrderDo.getSaleOrderItems().forEach(uocSaleOrderItem -> {
            if (null == uocSaleOrderItem.getSaleOrderItemId()) {
                throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "方法入参销售单明细ID不能为空");
            }
            if (null == uocSaleOrderItem.getAcceptanceCount()) {
                throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "方法入参验收数量不能为空");
            }
        });
        uocSaleOrderRepository.modifyBatchItemInspCount(uocSaleOrderDo);

    }

    @Override
    public void modifySaleOrderStakeholder(UocSaleOrderDo uocSaleOrderDo) {
        if (null == uocSaleOrderDo.getStakeholder()) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "方法入参三方信息不能为空");
        }
        if(uocSaleOrderDo.getStakeholder().getOrderId()==null){
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "方法入参订单ID不能为空");
        }
        uocSaleOrderRepository.modifySaleOrderStakeholder(uocSaleOrderDo);
    }

    @Override
    public void modifySalePrice(UocSaleOrderDo uocSaleOrderDo) {
        // 修改销售单明细销售金额
        uocSaleOrderRepository.modifyBatchItemSalePrice(uocSaleOrderDo);
        // 统计销售单明细销售价总金额
        UocSaleOrderDo uocSaleOrderDo2 = new UocSaleOrderDo();
        uocSaleOrderDo2.setOrderId(uocSaleOrderDo.getOrderId());
        uocSaleOrderDo2.setSaleOrderId(uocSaleOrderDo.getSaleOrderId());
        UocSaleOrderDo uocSaleOrderDo4 = uocSaleOrderRepository.getSaleItemTotalPrice(uocSaleOrderDo2);
        // 更新销售单销售金额
        UocSaleOrderDo uocSaleOrderDo3 = new UocSaleOrderDo() ;
        uocSaleOrderDo3.setOrderId(uocSaleOrderDo.getOrderId());
        uocSaleOrderDo3.setSaleOrderId(uocSaleOrderDo.getSaleOrderId());
        uocSaleOrderDo3.setTotalSaleFee(uocSaleOrderDo4.getTotalSaleFee());
        uocSaleOrderDo3.setUpdateOperId(uocSaleOrderDo.getUpdateOperId());
        uocSaleOrderDo3.setUpdateTime(uocSaleOrderDo.getUpdateTime());
        uocSaleOrderRepository.modifySaleOrderMain(uocSaleOrderDo3);

    }

    @Override
    public void modifySaleOrderItemReturningCount(UocSaleOrderItem uocSaleOrderItem) {
        valSaleItem(uocSaleOrderItem);
        uocSaleOrderRepository.modifySaleOrderItemReturningCount(uocSaleOrderItem);
    }

    @Override
    public void modifyBatchItemChngingCount(UocSaleOrderDo convertImplOrderDo) {
        uocSaleOrderRepository.modifyBatchItemChngingCount(convertImplOrderDo);
    }

    @Override
    public void modifyBatchItemChngCountRefuse(UocSaleOrderDo convertSaleOrderDo) {
        if (null == convertSaleOrderDo) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "入参对象不能为空");
        }
        if (org.springframework.util.CollectionUtils.isEmpty(convertSaleOrderDo.getOrderIdList())) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "入参订单id不能为空");
        }
        if (org.springframework.util.CollectionUtils.isEmpty(convertSaleOrderDo.getSaleOrderItemsIdList())) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "入参销售单id不能为空");
        }
        uocSaleOrderRepository.modifyBatchItemChngCountRefuse(convertSaleOrderDo);
    }

    @Override
    public void modifyBatchItemReturnCountConfirm(UocSaleOrderDo convertSaleOrderDo) {
        if (null == convertSaleOrderDo) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "入参对象不能为空");
        }
        if (org.springframework.util.CollectionUtils.isEmpty(convertSaleOrderDo.getOrderIdList())) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "入参订单id不能为空");
        }
        if (org.springframework.util.CollectionUtils.isEmpty(convertSaleOrderDo.getSaleOrderItemsIdList())) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "入参销售单id不能为空");
        }
        uocSaleOrderRepository.modifyBatchItemReturnCountConfirm(convertSaleOrderDo);
    }

    @Override
    public void modifySaleOrderItemInspCountEqualArrivalCount(UocSaleOrderDo uocSaleOrderDo) {
        uocSaleOrderRepository.modifySaleOrderItemInspCountEqualArrivalCount(uocSaleOrderDo);
    }

    private void valSaleItem(UocSaleOrderItem uocSaleOrderItem) {
        if (null == uocSaleOrderItem) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象不能为空");
        }
        if (ObjectUtil.isEmpty(uocSaleOrderItem.getOrderId())) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参订单ID不能为空");
        }
        if (ObjectUtil.isEmpty(uocSaleOrderItem.getSaleOrderItemId())) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参销售单明细ID不能为空");
        }

    }

    private void valDo(UocSaleOrderDo uocSaleOrderDo) {
        if (null == uocSaleOrderDo) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象不能为空");
        }
        if (null == uocSaleOrderDo.getOrderId()) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参订单ID不能为空");
        }

    }

    @Override
    public void deleteSaleOrder(UocSaleOrderDo saleOrderDo) {
        //入参校验
        deleteSaleOrderValDo(saleOrderDo);
        //修改标志位
        uocSaleOrderRepository.deleteSaleOrder(saleOrderDo);

    }

    @Override
    public void updateProcInst(UocOrderProcInst uocOrderProcInst) {
        uocCommonRepository.updateProInst(uocOrderProcInst);
    }

    @Override
    public void updateTaskInst(UocOrderTaskInst uocOrderTaskInst) {
        uocCommonRepository.updateTaskInst(uocOrderTaskInst);
    }

    private void deleteSaleOrderValDo(UocSaleOrderDo uocSaleOrderDo) {
        if (null == uocSaleOrderDo) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象不能为空");
        }
        if (null == uocSaleOrderDo.getOrderId()) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参订单ID不能为空");
        }
        if (null == uocSaleOrderDo.getSaleOrderId()) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参销售单ID不能为空");
        }
    }

    @Override
    public void modifySaleOrderItemAfterServingCount(UocSaleOrderItem uocSaleOrderItem) {
        uocSaleOrderRepository.modifySaleOrderItemAfterServingCount(uocSaleOrderItem);
    }

    @Override
    public void modifyInspSuper(UocSaleOrderDo uocSaleOrderDo) {
        uocSaleOrderRepository.modifyInspSuper(uocSaleOrderDo);
    }

    @Override
    public void modifyItemRefuseCountConfirm(UocSaleOrderDo uocSaleOrderDo) {
        uocSaleOrderRepository.modifyItemRefuseCountConfirm(uocSaleOrderDo);
    }

    @Override
    public void modifyItemArriveCountConfirm(UocSaleOrderDo uocSaleOrderDo) {
        uocSaleOrderRepository.modifyItemArriveCountConfirm(uocSaleOrderDo);
    }

    @Override
    public void updateSaleItemWithOutSkuId(UocSaleOrderDo uocSaleOrderDo) {
        validateUpdateSaleItemWithOutSkuId(uocSaleOrderDo);
        uocSaleOrderRepository.updateItem(uocSaleOrderDo);

    }
    
    @Override
    public void updateSaleItemArriveAccount(UocSaleOrderDo uocSaleOrderDo) {
        uocSaleOrderRepository.updateItemArriveAccount(uocSaleOrderDo);
    }

    @Override
    public void modifyPurchasePrice(UocSaleOrderDo uocSaleOrderDo) {
        // 修改销售单明细采购金额
        uocSaleOrderRepository.modifyBatchItemPurchasePrice(uocSaleOrderDo);
        // 统计销售单明细采购价总金额
        UocSaleOrderDo uocSaleOrderDo2 = new UocSaleOrderDo();
        uocSaleOrderDo2.setOrderId(uocSaleOrderDo.getOrderId());
        uocSaleOrderDo2.setSaleOrderId(uocSaleOrderDo.getSaleOrderId());
        UocSaleOrderDo uocSaleOrderDo4 = uocSaleOrderRepository.getSaleItemTotalPrice(uocSaleOrderDo2);
        // 更新销售单采购金额
        UocSaleOrderDo uocSaleOrderDo3 = new UocSaleOrderDo() ;
        uocSaleOrderDo3.setOrderId(uocSaleOrderDo.getOrderId());
        uocSaleOrderDo3.setSaleOrderId(uocSaleOrderDo.getSaleOrderId());
        uocSaleOrderDo3.setTotalPurchaseFee(uocSaleOrderDo4.getTotalPurchaseFee());
        uocSaleOrderDo3.setUpdateOperId(uocSaleOrderDo.getUpdateOperId());
        uocSaleOrderDo3.setUpdateTime(uocSaleOrderDo.getUpdateTime());
        uocSaleOrderRepository.modifySaleOrderMain(uocSaleOrderDo3);
    }

    private void validateUpdateSaleItemWithOutSkuId(UocSaleOrderDo uocSaleOrderDo) {
        if(uocSaleOrderDo == null){
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象不能为空");
        }
        if(ObjectUtil.isEmpty(uocSaleOrderDo.getOrderId())){
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性[订单id]不能为空");
        }
        if(ObjectUtil.isEmpty(uocSaleOrderDo.getSaleOrderId())){
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性[销售单id]不能为空");
        }
        List<UocSaleOrderItem> saleOrderItems = uocSaleOrderDo.getSaleOrderItems();
        if(ObjectUtil.isEmpty(saleOrderItems)){
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性[saleOrderItems]不能为空");
        }
        for (UocSaleOrderItem saleOrderItem : saleOrderItems) {
            if(saleOrderItem == null){
                throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性[saleOrderItem]不能为空");
            }
            if(ObjectUtil.isEmpty(saleOrderItem.getSaleOrderId())){
                throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性[SaleOrderId]不能为空");
            }
            if(ObjectUtil.isEmpty(saleOrderItem.getOrderId())){
                throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性[SaleOrderId]不能为空");
            }
            if(ObjectUtil.isEmpty(saleOrderItem.getSkuExtSkuId())){
                throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性[SkuExtSkuId]不能为空");
            }
            if(ObjectUtil.isEmpty(saleOrderItem.getNakedPrice())){
                throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性[NakedPrice]不能为空");
            }
            if(ObjectUtil.isEmpty(saleOrderItem.getTax())){
                throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性[Tax]不能为空");
            }
            if(ObjectUtil.isEmpty(saleOrderItem.getTaxPrice())){
                throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性[TaxPrice]不能为空");
            }
        }


    }

    @Override
    public void modifyItemChngCountRefuse(UocSaleOrderDo convertSaleOrderDo) {
        uocSaleOrderRepository.modifyItemChngCountRefuse(convertSaleOrderDo);
    }

    @Override
    public void modifyItemChngCountConfirm(UocSaleOrderDo convertSaleOrderDo) {
        uocSaleOrderRepository.modifyItemChngCountConfirm(convertSaleOrderDo);
    }

    @Override
    public List<UocSaleOrderDo> getSaleOrderList(UocSaleOrderQryBo uocSaleOrderQryBo) {
        return uocSaleOrderRepository.getSaleOrderList(uocSaleOrderQryBo);
    }
}


